/*
 * Decompiled with CFR 0.152.
 */
package elgato;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MemoryProfiler {
    private static MemLogger memLogger;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] stringArray) {
        String string = System.getProperty("memprof.out");
        if (stringArray.length < 1 || string == null) {
            System.err.println("usage: java -Dmemprof.out=<file> MemoryProfiler <main-class> [args] [...]");
            return;
        }
        String string2 = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        MemoryProfiler.startLogging(string);
        MemoryProfiler.execute(string2, stringArray2);
    }

    private static void execute(String string, String[] stringArray) {
        Method method;
        try {
            method = Class.forName(string).getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = MemoryProfiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(string + ".main() not found.");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Can't run " + string + ": " + classNotFoundException);
            return;
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
            return;
        }
        try {
            method.invoke(null, new Object[]{stringArray});
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("RuntimeException thrown by program:");
            runtimeException.printStackTrace();
        }
    }

    private static void startLogging(String string) {
        memLogger = new MemLogger(string);
        memLogger.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MemLogger
    extends Thread {
        private static final int DELAY = 1000;
        private final String filename;
        private final Runtime runtime = Runtime.getRuntime();
        private long startupTime;
        private StringBuffer buf = new StringBuffer(128);
        private volatile boolean shutdown;

        public MemLogger(String string) {
            super("MemLogger");
            this.filename = string;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new FileWriter(this.filename);
                this.startupTime = System.currentTimeMillis();
                this.buf.setLength(0);
                this.appendAndPad("RelTime", 11, true);
                this.buf.append(' ');
                this.appendAndPad("UsedMem", 11, true);
                this.buf.append(' ');
                this.appendAndPad("FreeMem", 11, true);
                this.buf.append(' ');
                this.appendAndPad("TotalMem", 11, true);
                this.buf.append('\n');
                outputStreamWriter.write(this.buf.toString());
                while (!this.shutdown) {
                    this.log(outputStreamWriter);
                    outputStreamWriter.flush();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                System.err.println("MemLogger ERROR WRITING TO FILE: ");
                iOException.printStackTrace();
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }

        private void log(Writer writer) throws IOException {
            long l = System.currentTimeMillis();
            long l2 = l - this.startupTime;
            long l3 = this.runtime.freeMemory();
            long l4 = this.runtime.totalMemory();
            long l5 = l4 - l3;
            this.buf.setLength(0);
            this.appendAndPad(String.valueOf(l2), 11, true);
            this.buf.append(' ');
            this.appendAndPad(String.valueOf(l5), 11, true);
            this.buf.append(' ');
            this.appendAndPad(String.valueOf(l3), 11, true);
            this.buf.append(' ');
            this.appendAndPad(String.valueOf(l4), 11, true);
            this.buf.append('\n');
            writer.write(this.buf.toString());
        }

        private void appendAndPad(String string, int n, boolean bl) {
            int n2 = n - string.length();
            if (bl) {
                while (n2-- > 0) {
                    this.buf.append(' ');
                }
            }
            this.buf.append(string);
            if (!bl) {
                while (n2-- > 0) {
                    this.buf.append(' ');
                }
            }
        }

        void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }
    }
}

