/*
 * Decompiled with CFR 0.152.
 */
package elgato.gui;

import elgato.gui.ModelTypeMgr;
import elgato.infrastructure.actuators.EntryField;
import elgato.infrastructure.analyzer.LocationMonitor;
import elgato.infrastructure.analyzer.LocationMonitorWindow;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandChannelEmulator;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.mainScreens.Copyrights;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.Header;
import elgato.infrastructure.mainScreens.ModeScreen;
import elgato.infrastructure.mainScreens.PrintScreenMessageScreen;
import elgato.infrastructure.mainScreens.SaveDataMessageScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.StatusBar;
import elgato.infrastructure.mainScreens.StatusHandler;
import elgato.infrastructure.measurement.DefaultMeasurementFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.measurement.StubMeasurementFactory;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.scriptedTests.CertificationSuiteReader;
import elgato.infrastructure.scriptedTests.LocalUnixCardSoftwareFileSystem;
import elgato.infrastructure.scriptedTests.LocalUnixSoftwareFileSystem;
import elgato.infrastructure.scriptedTests.SoftwareFileSystem;
import elgato.infrastructure.scriptedTests.XmlCertificationSuiteReader;
import elgato.infrastructure.systemFunctions.BacklightAutoDimmer;
import elgato.infrastructure.util.DebugServer;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.TextMessage;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.vfp.ElgatoVirtualFrontPanel;
import elgato.infrastructure.vfp.ToroMainKeyFarmVFP;
import elgato.infrastructure.vfp.ToroUnderScreenVFP;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.powerSupply.PowerSupplyMonitor;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurement;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.BindException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MainWindow
extends JFrame
implements ScreenManager,
ScrollWheelListener {
    private static final Logger logger = LogManager.getLogger(class$elgato$gui$MainWindow == null ? (class$elgato$gui$MainWindow = MainWindow.class$("elgato.gui.MainWindow")) : class$elgato$gui$MainWindow);
    private static final Resources res = Resources.getResources((class$elgato$gui$MainWindow == null ? (class$elgato$gui$MainWindow = MainWindow.class$("elgato.gui.MainWindow")) : class$elgato$gui$MainWindow).getName());
    private static final String CARD_NORMAL = "normal";
    private static final String CARD_FULLSCREEN = "fullscreen";
    public static boolean serverIOReady = false;
    private CardLayout windowManager;
    private JPanel mainPanel;
    private JPanel globalPanel;
    private Component fullscreenComponent;
    private BacklightAutoDimmer backlightAutoDimmer;
    private GlobalKeyManager keyManager;
    private JPanel headerPanel;
    private Header header;
    private MenuPanel leftMenuPanel = new MenuPanel(this);
    private MenuPanel rightMenuPanel = new MenuPanel(this);
    private StatusBar statusBar;
    private JPanel displayPanel;
    private Component installedDisplay;
    private Screen installedScreen;
    private Vector screenStateStack = new Vector();
    private EntryField currentEntryField;
    private final FreqRefState freqRefState = new FreqRefState();
    private ELabel remoteLabel;
    private volatile boolean localEnabled = true;
    private ValueListener mainWindowFreqRefListener;
    private ValueListener mainWindowTimeRefListener;
    private static Runnable runInitializeApplication;
    private MeasurementListener mainWindowTimeFreqRefMeasurementListener;
    private static MainWindow window;
    static /* synthetic */ Class class$elgato$gui$MainWindow;
    static /* synthetic */ Class class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement;
    static /* synthetic */ Class class$elgato$measurement$powerSupply$PowerSupplyMeasurement;
    static /* synthetic */ Class class$elgato$infrastructure$util$FastMath;

    public MainWindow() {
        super(Text.Agilent_Test_Set_Client);
        if (logger.isDebugEnabled()) {
            logger.debug("MainWindow()");
        }
        Color color = MenuPanel.BG_COLOR;
        ((Component)this).setBackground(color);
        this.windowManager = new CardLayout();
        this.getContentPane().setLayout(this.windowManager);
        this.getContentPane().setBackground(null);
        this.globalPanel = new JPanel(new BorderLayout());
        this.globalPanel.setBackground(null);
        this.mainPanel = new JPanel(new BorderLayout(8, 0));
        this.mainPanel.setBackground(color);
        this.initMenus();
        this.leftMenuPanel.setFooter(Text.GPS_Locked);
        this.rightMenuPanel.setFooter("");
        this.mainPanel.add((Component)this.leftMenuPanel, "West");
        this.mainPanel.add((Component)this.rightMenuPanel, "East");
        this.remoteLabel = new ELabel(1);
        this.remoteLabel.setVAlignment(2);
        this.remoteLabel.setChunk(0, Text.Remote);
        this.remoteLabel.setChunkAttributes(0, res.getColor("remoteLabel.color"), res.getFont("remoteLabel.font"));
        this.remoteLabel.setVisible(false);
        this.headerPanel = this.createHeaderPanel();
        this.headerPanel.add((Component)this.remoteLabel, "East");
        this.header = new Header(this.headerPanel);
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.add((Component)this.header, "North");
        this.statusBar = new StatusBar();
        jPanel.add((Component)this.statusBar, "South");
        this.displayPanel = new JPanel(new BorderLayout());
        this.installDisplay(new Copyrights());
        jPanel.add((Component)this.displayPanel, "Center");
        this.mainPanel.add((Component)jPanel, "Center");
        this.globalPanel.add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.globalPanel, CARD_NORMAL);
        this.mainWindowFreqRefListener = new ValueListener(){
            private static final String listenerName = "mainWindowFreqRefListener";

            public String getListenerName() {
                return listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ((MainWindow)MainWindow.this).freqRefState.referenceFreq = valueInterface.intValue();
                ((MainWindow)MainWindow.this).freqRefState.externalFrequencyLocked = false;
                MainWindow.this.updateFreqRefDisplay();
            }
        };
        this.mainWindowTimeRefListener = new ValueListener(){
            private static final String listenerName = "mainWindowTimeRefListener";

            public String getListenerName() {
                return listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ((MainWindow)MainWindow.this).freqRefState.referenceTime = valueInterface.intValue();
                ((MainWindow)MainWindow.this).freqRefState.gpsDataValid = false;
                ((MainWindow)MainWindow.this).freqRefState.ppsPresent = 0;
                MainWindow.this.updateFreqRefDisplay();
            }
        };
        runInitializeApplication = new Runnable(){

            public void run() {
                MeasurementFactory measurementFactory = MeasurementFactory.instance();
                measurementFactory.setScreenManager(window);
                CommandProcessor commandProcessor = measurementFactory.getCommandProcessor();
                commandProcessor.setStatusHandler(window.statusBar);
                commandProcessor.connect();
                window.configureForModel();
                if (logger.isDebugEnabled()) {
                    logger.debug("MainWindow() starting measurement reader");
                }
                measurementFactory.getMeasurementReader().start();
                window.statusBar.getPowerSupplyIndicator().setLicenses();
                serverIOReady = true;
            }
        };
        this.mainWindowTimeFreqRefMeasurementListener = new MeasurementListener(){

            public void measurementReceived(Measurement measurement) {
                TimeFreqRefMeasurement timeFreqRefMeasurement = (TimeFreqRefMeasurement)measurement;
                Runnable runnable = new Runnable(this, timeFreqRefMeasurement){
                    private final /* synthetic */ TimeFreqRefMeasurement val$timeFreqRefMeasurement;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$timeFreqRefMeasurement = timeFreqRefMeasurement;
                    }

                    public void run() {
                        4.access$600(this.this$1).updateStateAndDisplay(this.val$timeFreqRefMeasurement);
                    }
                };
                EventDispatchThread.invokeLater(runnable, "MainWindow.TimeFreqRefMeasurement");
            }

            static /* synthetic */ MainWindow access$600(4 var0) {
                return var0.MainWindow.this;
            }
        };
        this.backlightAutoDimmer = new BacklightAutoDimmer();
        this.backlightAutoDimmer.installPowerSupplyMeasurementListener();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MeasurementFactory.instance().getCommandProcessor().send(new Command("closeGui"));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
    }

    private void configureForModel() {
        if (ModelTypeMgr.instance().getModelType() == 1) {
            MainWindow.getLeftPanel().setVisible(false);
            window.setTitle(Text.N1996x_Client);
        } else {
            window.setTitle(Text.E749x_Client);
        }
        if (!RuntimeConfiguration.isEmbedded()) {
            ((Component)window).hide();
            Point point = new Point(0, 0);
            Dimension dimension = window.getSize();
            if (ModelTypeMgr.instance().getModelType() == 1) {
                this.globalPanel.add((Component)new ToroUnderScreenVFP(this), "South");
                this.globalPanel.add((Component)new ToroMainKeyFarmVFP(this), "East");
                dimension.height += 80;
                dimension.width += 400;
            } else {
                this.globalPanel.add((Component)new ElgatoVirtualFrontPanel(this), "South");
                dimension.height += 160;
            }
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            point.x = (dimension2.width - dimension.width) / 2;
            point.y = (dimension2.height - dimension.height) / 2;
            ((Component)window).setLocation(point);
            ((Component)window).setSize(dimension);
            window.show();
        }
        this.repaint();
    }

    protected JPanel createHeaderPanel() {
        return new JPanel(new BorderLayout());
    }

    void initializeInputListeners() {
        this.requestFocus();
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                MainWindow.this.backlightAutoDimmer.keyPressed();
                this.getDelegate().keyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                this.getDelegate().keyReleased(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                this.getDelegate().keyTyped(keyEvent);
            }

            private GlobalKeyManager getDelegate() {
                return GlobalKeyManager.instance();
            }
        });
        ScrollWheelManager.instance().addScrollWheelListener(this);
    }

    private void registerGpsMeasurementListener() {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(MainWindow.this.mainWindowTimeFreqRefMeasurementListener, class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement == null ? (class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement = MainWindow.class$("elgato.measurement.timeFreqRef.TimeFreqRefMeasurement")) : class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement);
            }
        }, "addTimeFreqRefMeasurement");
        TimeFreqRefMeasurementSettings.instance().getTimeRef().addValueListener(this.mainWindowTimeRefListener);
        TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().addValueListener(this.mainWindowFreqRefListener);
    }

    protected void updateFreqRefDisplay() {
        MenuPanel menuPanel = this.getRightMenuPanel();
        menuPanel.setFooter(TimeFreqRefMeasurementSettings.instance().getTimeFreqRef().getSelectedValue().getLabel());
        menuPanel.setGpsDotColor(this.freqRefState.getDotColorForRightMenu());
        MenuPanel menuPanel2 = this.getLeftMenuPanel();
        if (this.freqRefState.gpsDataValid) {
            menuPanel2.setFooter(Text.GPS_Locked);
        } else {
            menuPanel2.setFooter(Text.GPS_Unlocked);
        }
    }

    public void updateStateAndDisplay(TimeFreqRefMeasurement timeFreqRefMeasurement) {
        this.freqRefState.referenceTime = timeFreqRefMeasurement.getTimeReference();
        this.freqRefState.gpsDataValid = timeFreqRefMeasurement.getGpsDataValid() != 0;
        this.freqRefState.ppsPresent = timeFreqRefMeasurement.getPpsPresent();
        TimeFreqRefMeasurementSettings.instance().getPpsState().setValue(this.freqRefState.ppsPresent);
        this.freqRefState.referenceFreq = timeFreqRefMeasurement.getFrequencyReference();
        this.freqRefState.externalFrequencyLocked = timeFreqRefMeasurement.isExternalFrequencyLocked();
        this.updateFreqRefDisplay();
    }

    private void initMenus() {
        this.leftMenuPanel.setOtherMenu(this.rightMenuPanel);
        this.rightMenuPanel.setOtherMenu(this.leftMenuPanel);
    }

    public void installFullscreenComponent(Component component) {
        if (logger.isDebugEnabled()) {
            logger.debug("installFullscreenComponent()");
        }
        if (this.fullscreenComponent != null) {
            this.getContentPane().remove(this.fullscreenComponent);
        }
        this.fullscreenComponent = component;
        this.getContentPane().add(component, CARD_FULLSCREEN);
        this.windowManager.show(this.getContentPane(), CARD_FULLSCREEN);
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void uninstallFullscreenComponent() {
        if (logger.isDebugEnabled()) {
            logger.debug("uninstallFullscreenComponent()");
        }
        if (this.fullscreenComponent == null) {
            return;
        }
        this.getContentPane().remove(this.fullscreenComponent);
        this.fullscreenComponent = null;
        this.windowManager.show(this.getContentPane(), CARD_NORMAL);
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    public void pushScreen(Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("Null screen passed to loadScreen()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("pushScreen() " + screen);
            this.dumpScreenStack();
        }
        if (this.installedScreen != null) {
            ScreenState screenState = new ScreenState();
            screenState.screen = this.installedScreen;
            screenState.display = this.installedDisplay;
            screenState.leftMenu = this.getLeftMenuPanel().getMenu();
            screenState.leftMenuSelectedItem = this.getLeftMenuPanel().getSelectedItem();
            screenState.rightMenu = this.rightMenuPanel.getMenu();
            screenState.rightMenuSelectedItem = this.rightMenuPanel.getSelectedItem();
            this.screenStateStack.addElement(screenState);
        }
        this.installedScreen = screen;
        screen.installScreen(this);
        if (logger.isDebugEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("pushScreen() done");
            }
            this.dumpScreenStack();
        }
    }

    public String getPreviousScreenMenuTitle() {
        if (this.screenStateStack.isEmpty()) {
            return "";
        }
        ScreenState screenState = (ScreenState)this.screenStateStack.lastElement();
        return screenState.leftMenu.getTitle();
    }

    public Screen getPreviousScreen() {
        if (this.screenStateStack.isEmpty()) {
            return null;
        }
        ScreenState screenState = (ScreenState)this.screenStateStack.lastElement();
        return screenState.screen;
    }

    public Vector getScreenStack() {
        int n = this.screenStateStack.size();
        Vector<Screen> vector = new Vector<Screen>(n);
        try {
            for (int i = 0; i < n; ++i) {
                ScreenState screenState = (ScreenState)this.screenStateStack.elementAt(i);
                vector.addElement(screenState.screen);
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public StatusHandler getStatusHandler() {
        return this.statusBar;
    }

    public void popScreen() {
        if (logger.isDebugEnabled()) {
            logger.debug("popScreen()");
            this.dumpScreenStack();
        }
        if (this.installedScreen != null) {
            this.uninstallCurrentScreen();
            int n = this.screenStateStack.size();
            if (n > 0) {
                ScreenState screenState = (ScreenState)this.screenStateStack.elementAt(n - 1);
                this.installedScreen = screenState.screen;
                this.screenStateStack.removeElementAt(n - 1);
                if (screenState.display != null) {
                    this.installDisplay(screenState.display);
                }
                this.leftMenuPanel.installMenu(screenState.leftMenu);
                this.leftMenuPanel.focusButton(screenState.leftMenuSelectedItem);
                this.rightMenuPanel.installMenu(screenState.rightMenu);
                this.rightMenuPanel.focusButton(screenState.rightMenuSelectedItem);
                if (this.installedScreen instanceof ModeScreen) {
                    this.statusBar.setStatus("");
                }
            }
        }
        if (logger.isDebugEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("popScreen() done");
            }
            this.dumpScreenStack();
        }
    }

    public void loadScreen(Screen screen) {
        if (logger.isDebugEnabled()) {
            logger.debug("loadScreen() screen=" + screen);
        }
        this.uninstallAllScreens();
        this.pushScreen(screen);
    }

    private void dumpScreenStack() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.screenStateStack.size(); ++i) {
            ScreenState screenState = (ScreenState)this.screenStateStack.elementAt(i);
            stringBuffer.append("    state[" + i + "] = " + screenState.screen + "\n");
        }
        stringBuffer.append("    current = " + this.installedScreen + "\n");
        logger.debug("dumpScreenStack() : \n" + stringBuffer.toString());
    }

    private void uninstallAllScreens() {
        if (logger.isDebugEnabled()) {
            logger.debug("uninstallAllScreens() installedScreen=" + this.installedScreen);
            this.dumpScreenStack();
        }
        if (this.installedScreen != null) {
            while (this.screenStateStack.size() > 0) {
                this.popScreen();
            }
            this.uninstallCurrentScreen();
        }
    }

    private void uninstallCurrentScreen() {
        if (this.installedScreen instanceof PrintScreenMessageScreen || this.installedScreen instanceof SaveDataMessageScreen) {
            this.statusBar.setStatus("");
        }
        this.installedScreen.uninstallScreen(this);
        this.installedScreen = null;
    }

    public Screen getCurrentScreen() {
        return this.installedScreen;
    }

    public MenuPanel getLeftMenuPanel() {
        return this.leftMenuPanel;
    }

    public MenuPanel getRightMenuPanel() {
        return this.rightMenuPanel;
    }

    public void installRightMenu(Menu menu) {
        this.getRightMenuPanel().installMenu(menu);
    }

    public void installLeftMenu(Menu menu) {
        if (ModelTypeMgr.instance().getModelType() == 0) {
            this.getLeftMenuPanel().installMenu(menu);
        } else {
            this.getRightMenuPanel().installMenu(menu);
        }
    }

    public void clearRightMenu() {
        this.getRightMenuPanel().clear();
    }

    public void installDisplay(Component component) {
        if (component == this.installedDisplay) {
            return;
        }
        if (this.installedDisplay != null) {
            this.displayPanel.remove(this.installedDisplay);
        }
        this.installedDisplay = component;
        this.displayPanel.add(component);
        this.displayPanel.validate();
        this.displayPanel.repaint();
    }

    public Component getInstalledDisplay() {
        return this.installedDisplay;
    }

    public void installField(EntryField entryField) {
        this.ASSERT_CALLED_FROM_GUI_THREAD("installField");
        this.currentEntryField = entryField;
        this.headerPanel.add((Component)entryField, "Center");
        this.headerPanel.validate();
        this.headerPanel.repaint();
    }

    public void uninstallField() {
        this.ASSERT_CALLED_FROM_GUI_THREAD("uninstallField");
        if (this.currentEntryField != null) {
            this.currentEntryField.dispose();
            this.headerPanel.remove(this.currentEntryField);
            this.headerPanel.validate();
            this.headerPanel.repaint();
            this.currentEntryField = null;
        }
    }

    private void ASSERT_CALLED_FROM_GUI_THREAD(String string) {
        if (!RuntimeConfiguration.isUnitTestMode() && !SwingUtilities.isEventDispatchThread()) {
            System.err.println("-----");
            System.err.println("ASSERT_CALLED_FROM_GUI_THREAD: assertion failed, method: " + string);
            Thread.dumpStack();
            System.err.println("-----");
        }
    }

    public void repaintImmediately() {
        this.paintEntireComponentImmediately((JComponent)this.getContentPane());
    }

    public boolean isGpsLocked() {
        return this.freqRefState.gpsDataValid;
    }

    public Color getGpsDotColor() {
        return this.freqRefState.getDotColorForRightMenu();
    }

    private void paintEntireComponentImmediately(JComponent jComponent) {
        jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        this.backlightAutoDimmer.keyPressed();
        if (this.currentEntryField != null) {
            this.currentEntryField.scrollWheelMoved(scrollWheelEvent);
        }
    }

    public void scrollWheelMoveComplete() {
        if (this.currentEntryField != null) {
            this.currentEntryField.scrollWheelMoveComplete();
        }
    }

    public boolean isLocal() {
        return this.localEnabled;
    }

    public void setLocalEnabled(final boolean bl) {
        this.localEnabled = bl;
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                MainWindow.this.remoteLabel.setVisible(!bl);
                MainWindow.this.remoteLabel.invalidate();
                MainWindow.this.header.validate();
                MainWindow.this.rightMenuPanel.setButtonsEnabled(bl);
                MainWindow.this.keyManager.setLocalEnabled(bl);
            }
        }, "MainWindow.setLocalEnabled");
    }

    public void printScreen() {
        Object object;
        boolean bl;
        this.statusBar.setStatus("Capturing Screen Data");
        Image image = null;
        Rectangle rectangle = MainWindow.getRootPanel().getBounds();
        Image image2 = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = image2.getGraphics();
        boolean bl2 = bl = SystemMeasurementSettings.instance().getPrintSchemeActuator().intValue() == 1;
        if (bl) {
            this.mainPanel.setBackground(this.mainPanel.getBackground().brighter().brighter());
            ((Component)this).setBackground(((Component)this).getBackground().brighter().brighter());
        }
        ((Container)MainWindow.getRootPanel()).print(graphics);
        this.mainPanel.setBackground(MenuPanel.BG_COLOR);
        ((Component)this).setBackground(MenuPanel.BG_COLOR);
        Image image3 = image2;
        this.statusBar.setStatus("Formatting Screen Data");
        if (bl) {
            object = this.displayPanel.getLocationOnScreen();
            Rectangle rectangle2 = this.displayPanel.getBounds();
            ((Point)object).x -= MainWindow.getRootPanel().getLocationOnScreen().x;
            ((Point)object).y -= MainWindow.getRootPanel().getLocationOnScreen().y;
            rectangle2.x = ((Point)object).x;
            rectangle2.y = ((Point)object).y;
            image3 = this.getCurrentScreen().filterPrintImage(image2, rectangle2);
        }
        if (DisplayGlobalMeasurementSettings.instance().getGpsLocationToggle().intValue() == 1) {
            image = LocationMonitorWindow.instance().renderToImage(bl);
        }
        this.statusBar.setStatus("Saving Screen Data");
        object = new PrintScreenThread(image3, image, bl);
        EventDispatchThread.invokeLater((Runnable)object, "MainWindow.printScreen");
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.getCurrentScreen() != null) {
            this.getCurrentScreen().keyPressed(keyEvent);
        }
        if (!keyEvent.isConsumed() && this.currentEntryField != null) {
            this.currentEntryField.keyPressed(keyEvent);
        }
    }

    public void handlePreset() {
        if (this.getCurrentScreen() != null) {
            this.getCurrentScreen().handlePreset();
        }
    }

    public String getHelpContext() {
        return this.getCurrentScreen().getHelpContext();
    }

    public static void main(String[] stringArray) throws BindException {
        MainWindow.initializeApplication();
    }

    public static JPanel getRootPanel() {
        return MainWindow.window.mainPanel;
    }

    public static MenuPanel getLeftPanel() {
        return MainWindow.window.leftMenuPanel;
    }

    public static MenuPanel getRightPanel() {
        return MainWindow.window.rightMenuPanel;
    }

    public static MainWindow initializeApplication() throws BindException {
        Locale.setDefault(Locale.US);
        return MainWindow.initializeApplication(false);
    }

    public static MainWindow initializeApplication(boolean bl) throws BindException {
        if (window == null) {
            Object object;
            if (RuntimeConfiguration.runningInStubMode()) {
                object = new CommandChannelEmulator(5028);
                ((CommandChannelEmulator)object).start();
                ((CommandChannelEmulator)object).sendSampleMessages();
                MeasurementFactory.registerInstance(new StubMeasurementFactory((CommandChannelEmulator)object));
            } else {
                object = new DefaultMeasurementFactory();
                MeasurementFactory.registerInstance((MeasurementFactory)object);
            }
            CertificationSuiteReader.setInstance(new XmlCertificationSuiteReader());
            SoftwareFileSystem.registerFileSystem(new LocalUnixSoftwareFileSystem("Internal Storage", "/flash/software"));
            SoftwareFileSystem.registerFileSystem(new LocalUnixCardSoftwareFileSystem("CF card", "/flash/mnt/cf/software", 1));
            SoftwareFileSystem.registerFileSystem(new LocalUnixCardSoftwareFileSystem("PCMCIA card", "/flash/mnt/pcmcia/software", 0));
            window = new MainWindow();
            window.initKeyManager();
            object = new Point(0, 0);
            Dimension dimension = new Dimension(640, 480);
            UIHelper.fixWindowLocation((Point)object);
            UIHelper.fixWindowSize(dimension);
            if (!RuntimeConfiguration.isEmbedded()) {
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                ((Point)object).x = (dimension2.width - dimension.width) / 2;
                ((Point)object).y = (dimension2.height - dimension.height) / 2;
            }
            ((Component)window).setLocation((Point)object);
            ((Component)window).setSize(dimension);
            DebugServer.startup();
            if (!bl) {
                window.show();
            }
            if (logger.isInfoEnabled()) {
                logger.info("Display area: " + MainWindow.window.displayPanel.getSize());
            }
            window.registerGpsMeasurementListener();
            window.registerBatteryMeasurementListener();
            LocationMonitor.initialize();
            Platform.initializeScrollWheelManager(window);
            MainWindow.initializeFastMath();
            window.initializeInputListeners();
            EventDispatchThread.invokeLater(runInitializeApplication, "MainWindow.initializeApplication");
        }
        return window;
    }

    void initKeyManager() {
        this.keyManager = GlobalKeyManager.makeInstance(this);
        Platform.initializeKeyEventFilter();
    }

    private void registerBatteryMeasurementListener() {
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(PowerSupplyMonitor.instance(), class$elgato$measurement$powerSupply$PowerSupplyMeasurement == null ? (class$elgato$measurement$powerSupply$PowerSupplyMeasurement = MainWindow.class$("elgato.measurement.powerSupply.PowerSupplyMeasurement")) : class$elgato$measurement$powerSupply$PowerSupplyMeasurement);
    }

    private static Class initializeFastMath() {
        if (logger.isDebugEnabled()) {
            logger.debug("Computing FastMath tables");
        }
        return class$elgato$infrastructure$util$FastMath == null ? (class$elgato$infrastructure$util$FastMath = MainWindow.class$("elgato.infrastructure.util.FastMath")) : class$elgato$infrastructure$util$FastMath;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrintScreenThread
    implements Runnable {
        Image screenImage;
        Image gpsLocImage;
        boolean lightBackground;

        PrintScreenThread(Image image, Image image2, boolean bl) {
            this.screenImage = image;
            this.gpsLocImage = image2;
            this.lightBackground = bl;
        }

        public void run() {
            PrintScreenMessageScreen printScreenMessageScreen = new PrintScreenMessageScreen(TextMessage.MEDIA_SCREEN_SAVE_PENDING, true, 4, MainWindow.this, this.screenImage, this.gpsLocImage, this.lightBackground);
            MainWindow.this.pushScreen(printScreenMessageScreen);
        }
    }

    private static class ScreenState {
        Screen screen;
        Component display;
        Menu leftMenu;
        Menu rightMenu;
        MenuItem leftMenuSelectedItem;
        MenuItem rightMenuSelectedItem;

        private ScreenState() {
        }
    }

    private static class FreqRefState {
        int referenceFreq;
        boolean externalFrequencyLocked;
        int referenceTime;
        boolean gpsDataValid;
        int ppsPresent;

        private FreqRefState() {
        }

        public Color getDotColorForRightMenu() {
            Color color = Color.red;
            if (this.referenceFreq == SettingsModel.VALUE_USE_TIME_REF) {
                if (this.ppsPresent == 2) {
                    color = Color.yellow;
                } else if (this.ppsPresent == 1) {
                    color = Color.green;
                }
            } else if (this.referenceFreq == SettingsModel.VALUE_INT_10M || this.externalFrequencyLocked) {
                color = Color.green;
            }
            return color;
        }
    }
}

