/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.valueobject.ValueChangeSupport;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public abstract class AbstractActuator
implements Actuator {
    private ValueInterface value;
    protected ValueChangeSupport valueChangeSupport = new ValueChangeSupport(this);

    AbstractActuator(ValueInterface valueInterface) {
        if (valueInterface == null) {
            throw new IllegalArgumentException("cannot construct an actuator with a null value");
        }
        this.value = valueInterface;
    }

    public void dispose() {
        this.valueChangeSupport.Dispose();
        this.valueChangeSupport = null;
        this.value = null;
    }

    protected ValueInterface getValueObject() {
        return this.value;
    }

    public boolean isSafeToChange() {
        return this.value != null;
    }

    public void increment(int n) {
        this.value.increment(n);
    }

    public void decrement(int n) {
        this.value.decrement(n);
    }

    public Palette getPalette() {
        return this.value.getPalette();
    }

    public void setPalette(Palette palette) {
        this.value.setPalette(palette);
    }

    public Conversion[] getConversions() {
        return this.value.getConversions();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public boolean booleanValue() {
        return this.value.booleanValue();
    }

    public String getLabel() {
        return this.getValueObject().getLabel();
    }

    public String toString() {
        return ((Object)this.getValueObject()).toString();
    }

    public void setValue(String string) {
        this.getValueObject().setValue(string);
    }

    public void setLabel(String string) {
        this.getValueObject().setLabel(string);
    }

    public void setLongLabel(String string) {
        this.getValueObject().setLongLabel(string);
    }

    public String getLongLabel() {
        return this.getValueObject().getLongLabel();
    }

    public void setValueObject(ValueInterface valueInterface) {
        this.value = valueInterface;
        this.valueChangeSupport.fireValueChanged(this.value);
    }

    public boolean isValid(String string) {
        return this.value.isValid(string);
    }

    public boolean isValid() {
        return this.value.isValid();
    }

    public abstract /* synthetic */ Command buildInitialGet(Command var1);

    public abstract /* synthetic */ void receive(Command var1);

    public abstract /* synthetic */ void send();

    public abstract /* synthetic */ String getPropertyName();

    public abstract /* synthetic */ String getTopic();

    public abstract /* synthetic */ void setValue(int var1);

    public abstract /* synthetic */ void setValue(long var1);

    public abstract /* synthetic */ void fireValueChanged();

    public abstract /* synthetic */ boolean hasListener(ValueListener var1);

    public abstract /* synthetic */ void removeValueListener(ValueListener var1);

    public abstract /* synthetic */ void addValueListener(ValueListener var1);
}

