/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.ActuatorButton;
import elgato.infrastructure.menu.ActionListener;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.widgets.ValueField;

public class ActuatorEditor
extends ActuatorButton
implements ActionListener {
    private final ValueInterface actuator;
    private ValueField valueField;

    public ActuatorEditor(ValueInterface valueInterface, String string, String string2) {
        super(valueInterface.getLabel(), ((Object)valueInterface).toString(), string, string2);
        this.actuator = valueInterface;
        this.addActionListener(this);
    }

    public void actionPerformed() {
        if (!this.isFocused() && this.getMenuPanel() != null) {
            this.getMenuPanel().focusButton(this);
        }
        this.repaintNow();
    }

    public void setFocused(boolean bl) {
        if (bl != this.isFocused()) {
            if (bl) {
                this.getField().showField();
            } else {
                this.getField().hideField();
            }
        }
        super.setFocused(bl);
    }

    public void addNotify(MenuPanel menuPanel) {
        this.removeNotify();
        super.addNotify(menuPanel);
        this.actuator.addValueListener(this);
        this.updateValue();
    }

    public void removeNotify() {
        this.actuator.removeValueListener(this);
        super.removeNotify();
    }

    protected ValueField createValueField() {
        return new ValueField(this.getActuator(), this.getListenerName());
    }

    public ValueField getField() {
        if (this.valueField == null) {
            this.valueField = this.createValueField();
        }
        return this.valueField;
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.updateValue();
    }

    private void updateValue() {
        this.setBodyText(((Object)this.actuator).toString());
        this.setText(this.actuator.getLabel());
        if (this.valueField != null) {
            this.valueField.valueChanged(null);
        }
    }

    public ValueInterface getActuator() {
        return this.actuator;
    }
}

