/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionListener;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.awt.Graphics;

public class ActuatorSubMenuButton
extends PushButton
implements ActionListener,
ValueListener {
    private Menu menu;
    Menu previousMenu;
    private ValueListInterface value;
    private boolean cancelButtonRequested;
    protected String listenerName;

    public ActuatorSubMenuButton(ValueListInterface valueListInterface, String string, boolean bl, String string2) {
        super(valueListInterface.getLabel(), string);
        this.cancelButtonRequested = bl;
        if (valueListInterface.getValueList().length > 7) {
            throw new IllegalArgumentException("can only handle 7 or fewer items");
        }
        if (valueListInterface.getValueList().length > 6 && bl) {
            throw new IllegalArgumentException("can only handle 6 or fewer items and have a cancel button");
        }
        this.menu = this.createMenu(valueListInterface);
        this.value = valueListInterface;
        this.setBodyText(valueListInterface.toString());
        this.addActionListener(this);
        this.listenerName = string2;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void actionPerformed() {
        this.previousMenu = this.getScreenManager().getRightMenuPanel().getMenu();
        this.getScreenManager().installRightMenu(this.menu);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setSubMenuTopTitle(String string) {
        this.menu.setTitle(string);
    }

    public void addNotify(MenuPanel menuPanel) {
        super.addNotify(menuPanel);
        this.value.addValueListener(this);
        this.updateValue();
    }

    public void removeNotify() {
        this.value.removeValueListener(this);
        super.removeNotify();
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
        super.drawExtras(graphics, n, n2, n3, n4);
        MenuSymbol.draw(graphics, n, n2, n3, n4);
    }

    ScreenManager getScreenManager() {
        return MeasurementFactory.instance().getScreenManager();
    }

    private Menu createMenu(final ValueListInterface valueListInterface) {
        ValueInterface[] valueInterfaceArray = this.getButtonValues(valueListInterface);
        MenuItem[] menuItemArray = new MenuItem[7];
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            final ValueInterface valueInterface = valueInterfaceArray[i];
            menuItemArray[i] = new PushButton(valueInterface.getLabel(), "", new ActionListener(){

                public void actionPerformed() {
                    valueListInterface.setValueObject(valueInterface);
                    valueListInterface.send();
                    ActuatorSubMenuButton.this.getScreenManager().installRightMenu(ActuatorSubMenuButton.this.previousMenu);
                    ActuatorSubMenuButton.this.getMenuPanel().focusButton(ActuatorSubMenuButton.this);
                }
            });
        }
        if (this.cancelButtonRequested) {
            menuItemArray[6] = new PushButton(Text.Cancel, "", new ActionListener(){

                public void actionPerformed() {
                    ActuatorSubMenuButton.this.getScreenManager().installRightMenu(ActuatorSubMenuButton.this.previousMenu);
                }
            });
        }
        return new Menu(valueListInterface.getLabel(), menuItemArray);
    }

    protected ValueInterface[] getButtonValues(ValueListInterface valueListInterface) {
        return valueListInterface.getValueList();
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.updateValue();
    }

    private void updateValue() {
        this.setBodyText(this.value.toString());
        this.setText(this.value.getLabel());
    }
}

