/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.strategies.PercentageAdjustmentStrategy;

public class AntennaFrequencyActuator
extends FrequencyActuator {
    public static final int RESOLUTION = 1000;
    static final int MIN_FREQ = 0;
    static final long MAX_FREQ = 2500000000L;
    private final PercentageAdjustmentStrategy percentageAdjustmentStrategy = new PercentageAdjustmentStrategy(1000);

    private AntennaFrequencyActuator(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void increment(int n) {
        long l = this.longValue();
        while (n != 0) {
            l = this.percentageAdjustmentStrategy.stepUp(l);
            --n;
        }
        this.setValue(l);
    }

    public void decrement(int n) {
        long l = this.longValue();
        while (n != 0) {
            l = this.percentageAdjustmentStrategy.stepDown(l);
            --n;
        }
        this.setValue(l);
    }

    public static FrequencyActuator createKilohertz(String string, String string2, String string3, long l) {
        AntennaFrequencyActuator antennaFrequencyActuator = new AntennaFrequencyActuator(string, string2, string3);
        antennaFrequencyActuator.setValidator(new RangeValidator(0L, 2500000000L, 3));
        antennaFrequencyActuator.setValue(l);
        return antennaFrequencyActuator;
    }
}

