/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class FreqChanActuatorConfigurator {
    private FrequencyActuator centerFreq;
    private ListActuator freqChanUnits;
    private ListActuator chanStd;
    private LongActuator channelStep;
    private FrequencyActuator frequencyStep;
    private BandSelector bandSelector;
    private String listenerBaseName;

    public FreqChanActuatorConfigurator(FrequencyActuator frequencyActuator, ListActuator listActuator, ListActuator listActuator2, LongActuator longActuator, FrequencyActuator frequencyActuator2, BandSelector bandSelector, String string) {
        this.centerFreq = frequencyActuator;
        this.freqChanUnits = listActuator;
        this.chanStd = listActuator2;
        this.channelStep = longActuator;
        this.frequencyStep = frequencyActuator2;
        this.bandSelector = bandSelector;
        this.listenerBaseName = string;
        this.configure();
    }

    private void configure() {
        ValueListener valueListener = new ValueListener(){

            public String getListenerName() {
                return FreqChanActuatorConfigurator.this.listenerBaseName + ".cfListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                FreqChanActuatorConfigurator.this.configureCenterFrequency();
            }
        };
        this.freqChanUnits.addValueListener(valueListener);
        this.chanStd.addValueListener(valueListener);
        this.channelStep.addValueListener(valueListener);
        this.frequencyStep.addValueListener(valueListener);
        this.configureCenterFrequency();
    }

    private void configureCenterFrequency() {
        if (this.freqChanUnits.intValue() == 1) {
            this.centerFreq.configureForChannels(Text.Channel, this.bandSelector, this.channelStep);
            this.setChannelIncrement(this.channelStep);
        } else {
            this.centerFreq.configureForFreq(Text.Frequency);
            this.centerFreq.setIncrement(this.frequencyStep.intValue());
        }
    }

    private void setChannelIncrement(LongActuator longActuator) {
        double d = Band.getCurrentBand(this.chanStd.intValue()).getBandSegments()[0].getChannelBandWidth();
        this.centerFreq.setIncrement((int)((double)longActuator.intValue() * d));
    }
}

