/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.strategies.ChannelAdjustmentStrategy;
import elgato.infrastructure.units.ChannelCountUnits;
import elgato.infrastructure.units.ChannelUnits;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.FrequencyUnits;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.ValueInterface;

public class FrequencyActuator
extends LongActuator {
    private FrequencyUnits frequencyUnits = new FrequencyUnits();
    private boolean channelMode;

    public static FrequencyActuator createHectohertz(String string, String string2, String string3) {
        FrequencyActuator frequencyActuator = new FrequencyActuator(string, string2, string3);
        frequencyActuator.setWebPlugConversion(WebplugConversions.createHectohertz(frequencyActuator, string, string2));
        return frequencyActuator;
    }

    public static FrequencyActuator createKilohertz(String string, String string2, String string3) {
        FrequencyActuator frequencyActuator = new FrequencyActuator(string, string2, string3);
        frequencyActuator.setWebPlugConversion(WebplugConversions.createKilohertz(frequencyActuator, string, string2));
        return frequencyActuator;
    }

    public static FrequencyActuator createGlobalKilohertz(String string, String string2, String string3) {
        FrequencyActuator frequencyActuator = new FrequencyActuator(string, string2, string3);
        frequencyActuator.setWebPlugConversion(WebplugConversions.createGlobalKilohertz(frequencyActuator, string, string2));
        return frequencyActuator;
    }

    public FrequencyActuator(String string, String string2, String string3) {
        super(string, string2, string3);
        this.configureForFreq(string3);
    }

    public void configureForFreq(String string) {
        this.channelMode = false;
        this.setLabel(string);
        this.setUnitsFactory(this.frequencyUnits);
        this.setPalette(Palette.createSignedDecimal());
        this.setAdjustmentStrategy(null);
        this.fireValueChanged();
    }

    public void configureForChannels(String string, BandSelector bandSelector, ValueInterface valueInterface) {
        this.channelMode = true;
        this.setLabel(string);
        this.setUnitsFactory(new ChannelUnits(bandSelector));
        this.setPalette(Palette.createUnsignedInteger());
        this.setAdjustmentStrategy(new ChannelAdjustmentStrategy(valueInterface, bandSelector));
        this.fireValueChanged();
    }

    private void setAdjustmentStrategy(ChannelAdjustmentStrategy channelAdjustmentStrategy) {
        this.getValidator().setAdjustmentStrategy(channelAdjustmentStrategy);
    }

    public void configureForChannelCount(String string, BandSelector bandSelector) {
        this.channelMode = false;
        this.setLabel(string);
        this.setUnitsFactory(new ChannelCountUnits(bandSelector));
        this.setPalette(Palette.createUnsignedInteger());
        Conversion conversion = this.getUnitsFactory().getUnits()[0];
        long l = conversion.longValue(this.toString());
        long l2 = Band.getCurrentBandChannelWidth(bandSelector);
        if (l < l2) {
            l = l2;
        }
        if (l != this.longValue()) {
            this.send(l);
        } else {
            this.fireValueChanged();
        }
    }
}

