/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.AbstractActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversion;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class ListActuator
extends AbstractActuator
implements ValueListInterface {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$actuators$ListActuator == null ? (class$elgato$infrastructure$actuators$ListActuator = ListActuator.class$("elgato.infrastructure.actuators.ListActuator")) : class$elgato$infrastructure$actuators$ListActuator);
    private ValueInterface[] valueList;
    private String label;
    private String longLabel;
    private WebplugConversion webPlug;
    static /* synthetic */ Class class$elgato$infrastructure$actuators$ListActuator;

    public static ListActuator makeListActuator(String string, String string2, String string3, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("cannot create ListActuator without a value list");
        }
        ValueInterface[] valueInterfaceArray = new Value[stringArray.length];
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            valueInterfaceArray[i] = Value.createValue(stringArray[i], i);
        }
        return new ListActuator(string, string2, string3, valueInterfaceArray);
    }

    public ListActuator(String string, String string2, String string3, ValueInterface[] valueInterfaceArray) {
        super(valueInterfaceArray[0]);
        if (valueInterfaceArray == null) {
            throw new IllegalArgumentException("cannot create ListActuator without a value list");
        }
        this.initValues(string, string2, string3, valueInterfaceArray);
    }

    public void dispose() {
        this.webPlug = null;
    }

    private void initValues(String string, String string2, String string3, ValueInterface[] valueInterfaceArray) {
        this.webPlug = WebplugConversions.create(this, string, string2);
        this.label = string3;
        this.valueList = valueInterfaceArray;
    }

    public void setValue(long l) {
        throw new IllegalStateException("not yet implemented");
    }

    public void setValue(String string) {
        this.setValue(Integer.parseInt(string));
    }

    public void setValue(int n) {
        this.setValueObject(this.getValue(n));
    }

    public void setValueObject(ValueInterface valueInterface) {
        for (int i = 0; i < this.valueList.length; ++i) {
            ValueInterface valueInterface2 = this.valueList[i];
            if (!valueInterface2.equals(valueInterface)) continue;
            super.setValueObject(valueInterface2);
            return;
        }
        logger.error("Value '" + valueInterface + "' is not in the list -" + this);
    }

    public String toString() {
        return this.getValueObject().getLabel();
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setLongLabel(String string) {
        this.longLabel = string;
    }

    public void setValueList(ValueInterface[] valueInterfaceArray) {
        this.valueList = valueInterfaceArray;
    }

    public ValueInterface[] getValueList() {
        return this.valueList;
    }

    public int getSelectedValueIndex() {
        ValueInterface[] valueInterfaceArray = this.getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            if (valueInterfaceArray[i] != this.getValueObject()) continue;
            return i;
        }
        throw new IllegalStateException("no value found for current value " + this.toString() + " for actuator " + this.getLabel());
    }

    public ValueInterface getSelectedValue() {
        return this.getValueObject();
    }

    public void increment() {
        int n = this.getSelectedValueIndex();
        int n2 = n == this.valueList.length - 1 ? 0 : n + 1;
        this.setValueObject(this.valueList[n2]);
        this.send(this.valueList[n2].intValue());
    }

    public void send(int n) {
        this.setValue(n);
        this.send();
    }

    public void send(ValueInterface valueInterface) {
        this.setValueObject(valueInterface);
        this.send();
    }

    public ValueInterface getValue(int n) {
        ValueInterface[] valueInterfaceArray = this.getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            ValueInterface valueInterface = valueInterfaceArray[i];
            if (valueInterface.intValue() != n) continue;
            return valueInterface;
        }
        throw new IllegalArgumentException("Could not find label for value: " + n);
    }

    public String getTopic() {
        return this.webPlug.getTopic();
    }

    public String getPropertyName() {
        return this.webPlug.getPropertyName();
    }

    public String getLabel() {
        return this.label;
    }

    public String getLongLabel() {
        if (this.longLabel == null) {
            return super.getLongLabel();
        }
        return this.longLabel;
    }

    public void send() {
        this.webPlug.send();
    }

    public void receive(Command command) {
        this.webPlug.receive(command);
    }

    public Command buildInitialGet(Command command) {
        return this.webPlug.buildInitialGet(command);
    }

    public void addValueListener(ValueListener valueListener) {
        this.valueChangeSupport.addValueListener(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        this.valueChangeSupport.removeValueListener(valueListener);
    }

    public boolean hasListener(ValueListener valueListener) {
        return this.valueChangeSupport.hasListener(valueListener);
    }

    public void fireValueChanged() {
        this.valueChangeSupport.fireValueChanged(this);
    }

    public static ListActuator createStandardAveraging(String string) {
        return new ListActuator(string, "avgType", Text.Averaging, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.Running_n_Average, 1), Value.createValue(Text.Max_Hold, 2), Value.createValue(Text.Group_n_Average, 3), Value.createValue(Text.Group_Max_n_Average, 4)});
    }

    public static ListActuator createAveragingOffOn(String string) {
        return new ListActuator(string, "avgType", Text.Averaging, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.On, 1)});
    }

    public static ListActuator createRangeHold(String string) {
        return new ListActuator(string, "rangeHold", Text.Range_Ctrl, new Value[]{Value.createValue(Text.Auto, 0), Value.createValue(Text.Hold, 1), Value.createValue(Text.Max, 2)});
    }

    public static ListActuator createInterferenceRejection(String string) {
        return new ListActuator(string, "intfrMode", Text.Interference_n_Rejection, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    }

    public static ListActuator createNoiseCorrection(String string) {
        return new ListActuator(string, "noiseCorrection", Text.Noise_n_Correction, new ValueInterface[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    }

    public static ListActuator createSensitivity(String string) {
        return new ListActuator(string, "sensitivity", "Sensitivity", new Value[]{Value.createValue(Text.Low, 0), Value.createValue(Text.High, 1)});
    }

    public void setWebPlugConversion(WebplugConversion webplugConversion) {
        this.webPlug = webplugConversion;
    }

    public static ListActuator createpowerDetector(String string) {
        return new ListActuator(string, MeasurementSettings.KEY_PEAK_POWER_DETECTOR, Text.Power_n_Detector, new Value[]{Value.createValue(Text.Avg, 0), Value.createValue(Text.Pk, 1)});
    }

    public static ListActuator createFormatType(String string) {
        return new ListActuator(string, "formatType", Text.Format_Type, new Value[]{Value.createValue(Text.Chan, 0), Value.createValue(Text.List, 1), Value.createValue(Text.Cust, 2)});
    }

    public static ListActuator createFormatList(String string, Value[] valueArray) {
        return new ListActuator(string, "selectedFormat", Text.Format_List, valueArray);
    }

    public int getNumValueListeners() {
        return this.valueChangeSupport.getNumListeners();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

