/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.ListScreen;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.infrastructure.widgets.EListCellRenderer;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ListActuatorButton
extends ActionButton {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$menu$ListButton == null ? (class$elgato$infrastructure$menu$ListButton = ListActuatorButton.class$("elgato.infrastructure.menu.ListButton")) : class$elgato$infrastructure$menu$ListButton).getName());
    public static final Font VALUE_FONT = res.getFont("valueFont");
    private static final DefaultEListCellRenderer DEFAULT_CELL_RENDERER = new DefaultEListCellRenderer(){

        protected String stringValue(Object object) {
            Value value = (Value)object;
            return value.getLongLabel();
        }
    };
    Vector listeners;
    private EListCellRenderer cellRenderer = DEFAULT_CELL_RENDERER;
    public ValueListener valueListener;
    ListActuator actuator;
    private final String listenerName;
    static /* synthetic */ Class class$elgato$infrastructure$menu$ListButton;

    public ListActuatorButton(ListActuator listActuator, String string, String string2) {
        super(listActuator.getLabel(), string);
        this.actuator = listActuator;
        this.setBodyText(listActuator.toString());
        this.setBodyFont(VALUE_FONT);
        this.listenerName = string2 + ".listener";
        this.valueListener = new ValueListener(){

            public String getListenerName() {
                return ListActuatorButton.this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                ListActuatorButton.this.updateValue();
            }
        };
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementFactory.instance().getScreenManager().pushScreen(ListActuatorButton.this.createListScreen());
            }
        });
    }

    public void dispose() {
        this.clearListeners();
        this.cellRenderer = null;
        this.valueListener = null;
        this.actuator = null;
    }

    public void clearListeners() {
        super.clearListeners();
        this.listeners.removeAllElements();
    }

    void updateValue() {
        this.setBodyText(this.actuator.toString());
        this.repaint();
    }

    public void addNotify(MenuPanel menuPanel) {
        super.addNotify(menuPanel);
        if (!this.actuator.hasListener(this.valueListener)) {
            this.actuator.addValueListener(this.valueListener);
        }
        this.updateValue();
    }

    public void removeNotify() {
        super.removeNotify();
        this.actuator.removeValueListener(this.valueListener);
    }

    ListScreen createListScreen() {
        ItemSelectionListener itemSelectionListener = new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ListActuatorButton.this.actuator.send((ValueInterface)itemSelectionEvent.getValue());
                MenuPanel menuPanel = ListActuatorButton.this.getMenuPanel();
                if (menuPanel != null) {
                    menuPanel.focusButton(ListActuatorButton.this);
                }
                for (int i = 0; ListActuatorButton.this.listeners != null && i < ListActuatorButton.this.listeners.size(); ++i) {
                    ItemSelectionListener itemSelectionListener = (ItemSelectionListener)ListActuatorButton.this.listeners.elementAt(i);
                    itemSelectionListener.itemSelected(itemSelectionEvent);
                }
            }
        };
        DefaultEListModel defaultEListModel = this.createListModel(this.actuator);
        ListScreen listScreen = new ListScreen(defaultEListModel, this.actuator.getSelectedValueIndex(), itemSelectionListener, this.actuator.getLabel(), this.cellRenderer){

            protected MenuItem makeCancelButton() {
                PushButton pushButton = (PushButton)super.makeCancelButton();
                pushButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        5.access$100(this.this$1).getMenuPanel().focusButton(5.access$100(this.this$1));
                    }
                });
                return pushButton;
            }

            static /* synthetic */ ListActuatorButton access$100(5 var0) {
                return var0.ListActuatorButton.this;
            }
        };
        return listScreen;
    }

    public void setCellRenderer(EListCellRenderer eListCellRenderer) {
        this.cellRenderer = eListCellRenderer;
    }

    protected DefaultEListModel createListModel(ListActuator listActuator) {
        return new DefaultEListModel(listActuator.getValueList());
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
        super.drawExtras(graphics, n, n2, n3, n4);
        MenuSymbol.draw(graphics, n, n2, n3, n4);
    }

    public void addItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(itemSelectionListener);
    }

    public EListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

