/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.AbstractActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversion;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.AbstractValidator;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.measurement.Validator;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.units.DefaultUnitsFactory;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.UnitsConversion;
import elgato.infrastructure.units.UnitsFactory;
import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class LongActuator
extends AbstractActuator {
    private UnitsFactory units = new DefaultUnitsFactory();
    private Validator validator = new NullValidator();
    private WebplugConversion webPlugConversion;
    public static final String NO_UNITS_FOR_DECIMAL = " ";

    public void dispose() {
        super.dispose();
        this.webPlugConversion = null;
        this.validator = null;
        this.units = null;
    }

    public static LongActuator createRefLevelActuator(String string, int n, String string2, int n2, int n3, ScaleDivActuator scaleDivActuator) {
        LongActuator longActuator = new LongActuator(string, "dbReferenceLevel", Text.Ref_Level, n);
        longActuator.setConversion(FactorConversion.createFixedPoint(string2, 1000, scaleDivActuator));
        longActuator.setValidator(new RangeValidator(n2, n3, 2));
        longActuator.setPalette(n2 < 0 ? Palette.createSignedDecimal() : Palette.createUnsignedDecimal());
        return longActuator;
    }

    public static LongActuator createNumAverages(String string, int n) {
        LongActuator longActuator = new LongActuator(string, "numAvg", Text.Average);
        longActuator.setValidator(new RangeValidator(0L, n));
        return longActuator;
    }

    public static LongActuator createLoss(String string, String string2, String string3, int n) {
        LongActuator longActuator = LongActuator.createGlobalActuator(string, string2, string3, n);
        longActuator.setValidator(new RangeValidator(-100000L, 100000L, 2));
        longActuator.setIncrement(100);
        longActuator.setConversion(FactorConversion.createFixedPoint("dB", 1000));
        longActuator.setPalette(Palette.createSignedDecimal());
        return longActuator;
    }

    public static LongActuator createStashingLoss(String string, String string2, int n) {
        LongActuator longActuator = new LongActuator(string, "stashing" + string2, "", n);
        longActuator.setValidator(new RangeValidator(-100000L, 100000L, 2));
        longActuator.setIncrement(100);
        longActuator.setConversion(FactorConversion.createFixedPoint("dB", 1000));
        longActuator.setPalette(Palette.createSignedDecimal());
        return longActuator;
    }

    public static LongActuator createGlobalActuator(String string, String string2, String string3, int n) {
        LongActuator longActuator = new LongActuator(string, string2, string3, n);
        longActuator.setWebPlugConversion(WebplugConversions.createGlobal(longActuator, string, string2));
        return longActuator;
    }

    public static LongActuator createPercentActuator(String string, String string2, String string3, int n, int n2) {
        LongActuator longActuator = new LongActuator(string, string2, string3);
        longActuator.setValidator(new RangeValidator(0L, n, FastMath.log10(n2 - 1)));
        longActuator.setConversion(FactorConversion.createPercent(n2));
        longActuator.setIncrement(100);
        longActuator.setPalette(Palette.createUnsignedDecimal());
        return longActuator;
    }

    public static LongActuator createPower(String string, String string2, String string3) {
        return LongActuator.createPower(string, string2, string3, "dB");
    }

    public static LongActuator createPower(String string, String string2, String string3, String string4) {
        return LongActuator.createDecimal(string, string2, string3, new RangeValidator(-100000L, 100000L, 2), string4, 1000);
    }

    public static LongActuator createPower(String string, String string2, String string3, RangeValidator rangeValidator) {
        return LongActuator.createDecimal(string, string2, string3, rangeValidator, "dB", 1000);
    }

    public static LongActuator createDecimal(String string, String string2, String string3, String string4, int n) {
        return LongActuator.createDecimal(string, string2, string3, new RangeValidator(-100000L, 100000L, 2), string4, n);
    }

    public static LongActuator createDecimal(String string, String string2, String string3, RangeValidator rangeValidator, String string4, int n) {
        LongActuator longActuator = new LongActuator(string, string2, string3);
        longActuator.setValidator(rangeValidator);
        longActuator.setConversion(FactorConversion.createFixedPoint(string4, n));
        longActuator.setPalette(Palette.createSignedDecimal());
        longActuator.setIncrement(n);
        return longActuator;
    }

    public static LongActuator createSlots(String string, String string2, String string3, long l, long l2, long l3, int n) {
        LongActuator longActuator = new LongActuator(string, string2, string3, l);
        longActuator.setValidator(new RangeValidator(l2, l3));
        longActuator.setIncrement(n);
        longActuator.setConversion(FactorConversion.createFixedPoint("Slots", 1000));
        longActuator.setPalette(Palette.createUnsignedDecimal());
        return longActuator;
    }

    public static LongActuator createEstRho(String string, String string2, String string3, String string4, int n) {
        LongActuator longActuator = new LongActuator(string, string2, string3);
        longActuator.setValidator(new RangeValidator(-100000L, 100000L, 2));
        longActuator.setConversion(FactorConversion.createFixedPoint(string4, n));
        longActuator.setPalette(Palette.createSignedDecimal());
        longActuator.setIncrement(n / 100);
        return longActuator;
    }

    public static LongActuator createPower(String string, String string2, String string3, RangeValidator rangeValidator, String string4, int n) {
        LongActuator longActuator = new LongActuator(string, string2, string3);
        longActuator.setValidator(rangeValidator);
        longActuator.setConversion(FactorConversion.createFixedPoint(string4, 1000));
        longActuator.setPalette(Palette.createSignedDecimal());
        longActuator.setIncrement(n);
        return longActuator;
    }

    public static LongActuator createWattsPower(String string, String string2, String string3, String string4, String string5) {
        LongActuator longActuator = new LongActuator(string, string2, string3);
        Conversion conversion = DbmUnitsFactory.getWattsConversion();
        DbmUnitsFactory dbmUnitsFactory = new DbmUnitsFactory();
        dbmUnitsFactory.setDefaultUnits(conversion);
        RangeValidator rangeValidator = new RangeValidator(conversion.longValue(string4), conversion.longValue(string5)){

            public long decrement(long l, int n) {
                return this.increment(l, -n);
            }

            public long increment(long l, int n) {
                double d = Math.pow(10.0, (double)l / 10000.0);
                int n2 = (int)(d + 50.0) / 100 * 100;
                int n3 = 100 * n;
                double d2 = Math.log(n2 + n3) / Math.log(10.0);
                return (long)(d2 * 10000.0);
            }
        };
        longActuator.setValidator(rangeValidator);
        longActuator.setUnitsFactory(dbmUnitsFactory);
        longActuator.setPalette(Palette.createUnsignedDecimal());
        return longActuator;
    }

    public LongActuator(String string, String string2, String string3) {
        this(new Conversion(), string, string2, string3, 0L);
    }

    public LongActuator(String string, String string2, String string3, long l) {
        this(new Conversion(), string, string2, string3, l);
    }

    public LongActuator(String string, String string2, String string3, long l, Validator validator) {
        this(new Conversion(), string, string2, string3, l);
        this.validator = validator;
    }

    public LongActuator(String string, String string2, String string3, Conversion conversion) {
        this(conversion, string, string2, string3, 0L);
    }

    public LongActuator(Conversion conversion, String string, String string2, String string3, long l) {
        super(Value.createValue(string3, l));
        this.webPlugConversion = WebplugConversions.createIdentity(this, string, string2);
        this.units.setDefaultUnits(conversion);
        this.setPalette(Palette.createUnsignedInteger());
    }

    public void receive(Command command) {
        this.webPlugConversion.receive(command);
    }

    public Command buildInitialGet(Command command) {
        return this.webPlugConversion.buildInitialGet(command);
    }

    public String getTopic() {
        return this.webPlugConversion.getTopic();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
        if (this.validator != null) {
            long l = validator.validValue(this.getValueObject().longValue());
            ValueInterface valueInterface = this.getValueObject();
            valueInterface.setValue(l);
            this.setValueObject(valueInterface);
        }
    }

    public String getPropertyName() {
        return this.webPlugConversion.getPropertyName();
    }

    public void setValue(long l) {
        long l2 = this.getValidator().validValue(l);
        if (l2 == this.longValue()) {
            return;
        }
        ValueInterface valueInterface = this.getValueObject();
        valueInterface.setValue(l2);
        this.setValueObject(valueInterface);
    }

    public void send() {
        this.webPlugConversion.send();
    }

    public void send(Conversion conversion, String string) {
        this.send(conversion.longValue(string));
    }

    public void send(long l) {
        this.setValue(l);
        this.send();
    }

    public void setValue(String string) {
        this.setValue(this.getConversion().longValue(string));
    }

    public void setValue(int n) {
        this.setValue((long)n);
    }

    public boolean isValid() {
        return this.getValidator().isValid(this.toString());
    }

    public boolean isValid(String string) {
        return this.isValid(string, this.units.getDefaultUnits());
    }

    public boolean isValid(String string, Conversion conversion) {
        try {
            return this.validator.isValid(conversion.longValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getUnits() {
        return this.getConversion().getLabel();
    }

    public void setUnits(String string) {
        this.setConversion(new UnitsConversion(string));
    }

    public String toString() {
        return this.getUnitsFactory().toString(this.longValue());
    }

    public Conversion getConversion() {
        return this.units.getDefaultUnits();
    }

    public void setConversion(Conversion conversion) {
        this.units.setDefaultUnits(conversion);
    }

    public Conversion[] getConversions() {
        return this.units.getUnits();
    }

    public UnitsFactory getUnitsFactory() {
        return this.units;
    }

    public void setUnitsFactory(UnitsFactory unitsFactory) {
        this.units = unitsFactory;
    }

    public void setWebPlugConversion(WebplugConversion webplugConversion) {
        this.webPlugConversion = webplugConversion;
    }

    public void setIncrement(int n) {
        this.getUnitsFactory().setIncrement(n);
    }

    public int getIncrement() {
        return this.getUnitsFactory().getIncrement();
    }

    public void decrement(int n) {
        this.setValue(this.getValidator().decrement(this.longValue(), this.getUnitsFactory().increment(n)));
    }

    public void increment(int n) {
        this.setValue(this.getValidator().increment(this.longValue(), this.getUnitsFactory().increment(n)));
    }

    public int getNumValueListeners() {
        return this.valueChangeSupport.getNumListeners();
    }

    public WebplugConversion getWebPlugConversion() {
        return this.webPlugConversion;
    }

    public void addValueListener(ValueListener valueListener) {
        this.valueChangeSupport.addValueListener(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        this.valueChangeSupport.removeValueListener(valueListener);
    }

    public boolean hasListener(ValueListener valueListener) {
        return this.valueChangeSupport.hasListener(valueListener);
    }

    public void fireValueChanged() {
        this.valueChangeSupport.fireValueChanged(this);
    }

    private static class NullValidator
    extends AbstractValidator {
        private NullValidator() {
        }

        protected long doDecrement(long l, int n) {
            return l - (long)n;
        }

        protected long doIncrement(long l, int n) {
            return l + (long)n;
        }

        public boolean isValid(long l) {
            return true;
        }

        public boolean isValid(String string) {
            return true;
        }

        public long validValue(long l) {
            return l;
        }
    }
}

