/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.MultiStateLayoutMetrics;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MultiStateActuatorButton
extends ActionButton
implements ActionListener {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$actuators$MultiStateActuatorButton == null ? (class$elgato$infrastructure$actuators$MultiStateActuatorButton = MultiStateActuatorButton.class$("elgato.infrastructure.actuators.MultiStateActuatorButton")) : class$elgato$infrastructure$actuators$MultiStateActuatorButton).getName());
    private static final Font STATE_FONT = res.getFont("toggleOption.font");
    private static final Color STATE_SELECTED_COLOR = res.getColor("toggleOption.color.selected");
    private static final Color STATE_NORMAL_COLOR = res.getColor("toggleOption.color");
    private static final HydroBorderPainterConfig STATE_SELECTED_BORDER = res.getBorderConfig("toggleBorder");
    private final ValueListInterface listValue;
    private MultiStateLayoutMetrics layoutMetrics;
    private ValueListener multistateListener;
    protected final String listenerBaseName;
    static /* synthetic */ Class class$elgato$infrastructure$actuators$MultiStateActuatorButton;

    public MultiStateActuatorButton(ValueListInterface valueListInterface, String string, String string2) {
        super(valueListInterface.getLabel(), string);
        this.listValue = valueListInterface;
        this.listenerBaseName = string2 + ".multistateListener";
        this.addActionListener(this);
        this.multistateListener = new ValueListener(){

            public String getListenerName() {
                return MultiStateActuatorButton.this.listenerBaseName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                MultiStateActuatorButton.this.repaint();
            }
        };
    }

    public MultiStateActuatorButton(ValueListInterface valueListInterface, String string, String string2, ValueInterface valueInterface) {
        super(valueInterface.getLabel(), string);
        this.listValue = valueListInterface;
        this.listenerBaseName = string2 + ".multistateListener";
        this.addActionListener(this);
        this.multistateListener = new ValueListener(){

            public String getListenerName() {
                return MultiStateActuatorButton.this.listenerBaseName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                MultiStateActuatorButton.this.repaint();
            }
        };
    }

    public void addNotify(MenuPanel menuPanel) {
        this.getActuator().addValueListener(this.multistateListener);
        super.addNotify(menuPanel);
    }

    public void removeNotify() {
        this.getActuator().removeValueListener(this.multistateListener);
        super.removeNotify();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isFocused()) {
            this.getMenuPanel().focusButton(this);
        }
        ValueInterface[] valueInterfaceArray = this.listValue.getValueList();
        this.listValue.setValueObject(valueInterfaceArray[(this.listValue.getSelectedValueIndex() + 1) % valueInterfaceArray.length]);
        this.listValue.send();
        this.repaint();
    }

    public String getSelectedString() {
        return this.listValue.getSelectedValue().getLabel();
    }

    protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
        super.drawExtras(graphics, n, n2, n3, n4);
        graphics.setFont(STATE_FONT);
        MultiStateLayoutMetrics multiStateLayoutMetrics = this.getLayoutMetricsInstance(graphics, n3, n4);
        ValueInterface[] valueInterfaceArray = this.listValue.getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            graphics.setColor(STATE_NORMAL_COLOR);
            if (valueInterfaceArray[i].equals(this.listValue.getSelectedValue())) {
                graphics.fillRect(n + multiStateLayoutMetrics.getStateBoxX(i), n2 + multiStateLayoutMetrics.getStateBoxY(), multiStateLayoutMetrics.getStateBoxWidth(i), multiStateLayoutMetrics.getStateBoxHeight());
                graphics.setColor(STATE_SELECTED_COLOR);
            }
            graphics.drawString(valueInterfaceArray[i].getLabel(), n + multiStateLayoutMetrics.getTextX(i), n2 + multiStateLayoutMetrics.getTextY());
        }
    }

    private MultiStateLayoutMetrics getLayoutMetricsInstance(Graphics graphics, int n, int n2) {
        if (this.layoutMetrics == null) {
            this.layoutMetrics = this.createLayoutMetrics(graphics, n, n2);
        }
        return this.layoutMetrics;
    }

    MultiStateLayoutMetrics createLayoutMetrics(Graphics graphics, int n, int n2) {
        return new MultiStateLayoutMetrics(graphics.getFontMetrics(), this.getValueStrings(), n, STATE_SELECTED_BORDER.getBorderWidth(), n2);
    }

    private String[] getValueStrings() {
        ValueInterface[] valueInterfaceArray = this.listValue.getValueList();
        String[] stringArray = new String[valueInterfaceArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = valueInterfaceArray[i].getLabel();
        }
        return stringArray;
    }

    public void setCurrentState(int n) {
        ValueInterface[] valueInterfaceArray = this.listValue.getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            ValueInterface valueInterface = valueInterfaceArray[i];
            if (valueInterface.intValue() != n) continue;
            this.listValue.setValueObject(valueInterface);
            break;
        }
        this.listValue.send();
    }

    public ValueListInterface getActuator() {
        return this.listValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

