/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;

public class ScaleDivActuator
extends LongActuator {
    private static final int FACTOR = 1000;
    private static final int MIN_VALUE = 1000;
    private static final int MAX_VALUE = 20000;
    private final RangeValidator rangeValidator = new RangeValidator(1000L, 20000L);
    private FactorConversion factor = new FactorConversion("dB", 1000L);

    public ScaleDivActuator(String string, int n) {
        super(string, "dbScaleDiv", Text.Scale_slash_Div, n);
        if (!this.rangeValidator.isValid(n)) {
            throw new IllegalArgumentException("Default value out of range.  Allowable range is 1000 to 2000");
        }
        this.setConversion(this.factor);
        this.setValidator(this.rangeValidator);
        this.setIncrement(1000);
    }

    public ScaleDivActuator(String string) {
        this(string, 1000);
    }

    public void increment(int n) {
        super.increment(n);
        this.send();
    }

    public void decrement(int n) {
        super.decrement(n);
        this.send();
    }
}

