/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.actuators;

import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.ValueField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TrimodeActuatorButton
extends MultiStateActuatorButton {
    static final int MANUAL = 0;
    static final int AUTO = 1;
    protected ValueListInterface listActuator;
    private KeyListener keyListener;
    private ValueField valueField;
    private ValueInterface[] displayValues;
    private ValueListener bodytextUpdater = new ValueListener(){

        public String getListenerName() {
            return TrimodeActuatorButton.this.listenerBaseName + ".bodytextUpdater";
        }

        public void valueChanged(ValueInterface valueInterface) {
            TrimodeActuatorButton.this.updateBodyText();
            TrimodeActuatorButton.this.repaint();
        }
    };
    private ValueListener valueShowUpdater = new ValueListener(){

        public String getListenerName() {
            return TrimodeActuatorButton.this.listenerBaseName + ".valueShowUpdater";
        }

        public void valueChanged(ValueInterface valueInterface) {
            TrimodeActuatorButton.this.updateValueField();
        }
    };
    private int readOnlyValueIndex = -1;
    private boolean bLabelChange = false;

    public TrimodeActuatorButton(ValueListInterface valueListInterface, String string, ValueInterface valueInterface, String string2) {
        super(valueListInterface, string, string2);
        this.listActuator = valueListInterface;
        this.displayValues = new ValueInterface[]{null, valueInterface};
        this.keyListener = this.createKeyListener();
    }

    public TrimodeActuatorButton(ValueListInterface valueListInterface, String string, ValueInterface[] valueInterfaceArray, String string2) {
        super(valueListInterface, string, string2);
        this.TrimodeActuatorButtonBody(valueListInterface, string, valueInterfaceArray, string2);
    }

    public TrimodeActuatorButton(ValueListInterface valueListInterface, String string, ValueInterface[] valueInterfaceArray, String string2, boolean bl) {
        super(valueListInterface, string, string2);
        this.bLabelChange = bl;
        this.TrimodeActuatorButtonBody(valueListInterface, string, valueInterfaceArray, string2);
    }

    protected void TrimodeActuatorButtonBody(ValueListInterface valueListInterface, String string, ValueInterface[] valueInterfaceArray, String string2) {
        if (valueInterfaceArray.length != valueListInterface.getValueList().length) {
            throw new RuntimeException("editableValues.length must match number of values in the list actuator");
        }
        int n = 0;
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            if (valueInterfaceArray[i] != null) continue;
            ++n;
        }
        if (n > 1) {
            throw new RuntimeException("A TriModeActuatorButton can only have 1, null displayValue");
        }
        this.listActuator = valueListInterface;
        this.displayValues = valueInterfaceArray;
        this.keyListener = this.createKeyListener();
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                boolean bl;
                ValueInterface valueInterface = TrimodeActuatorButton.this.getNextDisplayValue();
                boolean bl2 = bl = (keyEvent.getModifiers() & 0xB) == 0;
                if (!keyEvent.isConsumed() && !TrimodeActuatorButton.this.isCurrentValueEditable() && valueInterface != null && valueInterface.getPalette().containsCharacter(keyEvent.getKeyChar()) && bl) {
                    TrimodeActuatorButton.this.goToNextValue();
                    if (TrimodeActuatorButton.this.valueField != null) {
                        TrimodeActuatorButton.this.valueField.keyPressed(keyEvent);
                        keyEvent.consume();
                    }
                }
            }
        };
    }

    public void addNotify(MenuPanel menuPanel) {
        super.addNotify(menuPanel);
        MeasurementFactory.instance().getScreenManager().addKeyListener(this.keyListener);
        for (int i = 0; i < this.displayValues.length; ++i) {
            ValueInterface valueInterface = this.displayValues[i];
            if (valueInterface == null) continue;
            valueInterface.addValueListener(this.bodytextUpdater);
        }
        this.listActuator.addValueListener(this.bodytextUpdater);
        this.listActuator.addValueListener(this.valueShowUpdater);
        this.updateBodyText();
        this.updateValueField();
    }

    public void removeNotify() {
        this.hideField();
        MeasurementFactory.instance().getScreenManager().removeKeyListener(this.keyListener);
        for (int i = 0; i < this.displayValues.length; ++i) {
            ValueInterface valueInterface = this.displayValues[i];
            if (valueInterface == null) continue;
            valueInterface.removeValueListener(this.bodytextUpdater);
        }
        this.listActuator.removeValueListener(this.bodytextUpdater);
        this.listActuator.removeValueListener(this.valueShowUpdater);
        super.removeNotify();
    }

    public ValueInterface[] getDisplayValues() {
        return (ValueInterface[])this.displayValues.clone();
    }

    private void updateBodyText() {
        String string;
        ValueInterface valueInterface = this.displayValues[this.listActuator.getSelectedValueIndex()];
        if (valueInterface == null) {
            string = "";
        } else {
            string = ((Object)valueInterface).toString();
            if (this.bLabelChange) {
                this.setText(valueInterface.getLabel());
            }
        }
        this.setBodyText(string);
    }

    public int intValue() {
        ValueInterface valueInterface = this.displayValues[this.listActuator.getSelectedValueIndex()];
        if (valueInterface == null) {
            return Integer.MIN_VALUE;
        }
        return valueInterface.intValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isFocused()) {
            this.getMenuPanel().focusButton(this);
            if (!this.isCurrentValueEditable()) {
                this.goToNextValue();
            }
        } else {
            this.goToNextValue();
        }
        this.repaint();
    }

    private boolean isCurrentValueEditable() {
        return this.displayValues[this.listActuator.getSelectedValueIndex()] != null && this.listActuator.getSelectedValueIndex() != this.readOnlyValueIndex;
    }

    private void goToNextValue() {
        ValueInterface valueInterface = this.getNextListValue();
        this.listActuator.setValueObject(valueInterface);
        this.listActuator.send();
    }

    private ValueInterface getNextListValue() {
        return this.nextValue(this.listActuator.getValueList());
    }

    private ValueInterface getNextDisplayValue() {
        return this.nextValue(this.displayValues);
    }

    private ValueInterface nextValue(ValueInterface[] valueInterfaceArray) {
        return valueInterfaceArray[(this.listActuator.getSelectedValueIndex() + 1) % valueInterfaceArray.length];
    }

    public boolean shouldValueShow() {
        return this.displayValues[this.listActuator.getSelectedValueIndex()] != null;
    }

    ValueField getValueField() {
        return this.valueField;
    }

    private void updateValueField() {
        this.hideField();
        this.showField();
    }

    private void showField() {
        int n = this.listActuator.getSelectedValueIndex();
        ValueInterface valueInterface = this.displayValues[n];
        boolean bl = this.isFocused();
        if (bl && valueInterface != null && this.readOnlyValueIndex != n) {
            this.valueField = new ValueField(valueInterface, this.listenerBaseName);
            if (bl) {
                this.valueField.showField();
            }
        }
    }

    private void hideField() {
        if (this.valueField != null) {
            this.valueField.hideField();
            this.valueField = null;
        }
    }

    public void setFocused(boolean bl) {
        super.setFocused(bl);
        this.updateValueField();
    }

    public void setReadOnlyValueIndex(int n) {
        this.readOnlyValueIndex = n;
    }

    KeyListener getKeyListener() {
        return this.keyListener;
    }
}

