/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.LabelPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractLabelPainter
implements LabelPainter {
    private static final Color backgroundColor = Color.black;
    protected Vector labels = new Vector();
    private Hashtable previousLabels = new Hashtable();

    public void addLabel(String string, Color color, Font font) {
        Label label;
        Label label2 = this.createLabel(string, color, font);
        if (this.previousLabels != null && (label = (Label)this.previousLabels.get(label2)) != null) {
            label2 = label;
        }
        this.labels.addElement(label2);
    }

    protected abstract Label createLabel(String var1, Color var2, Font var3);

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public void clearLabels() {
        this.previousLabels.clear();
        for (int i = 0; i < this.labels.size(); ++i) {
            Label label = (Label)this.labels.elementAt(i);
            this.previousLabels.put(label, label);
        }
        this.labels.removeAllElements();
    }

    public abstract /* synthetic */ void paintLabel(int var1, Component var2, Graphics var3, int var4, int var5, int var6, int var7);

    public abstract /* synthetic */ int getMaximumHeight();

    protected static class Label {
        protected final String text;
        protected final Color color;
        protected final Font font;

        public Label(String string, Color color, Font font) {
            this.text = string;
            this.color = color;
            this.font = font;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Label)) {
                return false;
            }
            Label label = (Label)object;
            if (!this.color.equals(label.color)) {
                return false;
            }
            if (!this.font.equals(label.font)) {
                return false;
            }
            return this.text.equals(label.text);
        }

        public int hashCode() {
            int n = this.text.hashCode();
            n = 29 * n + this.color.hashCode();
            n = 29 * n + this.font.hashCode();
            return n;
        }
    }
}

