/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.BasicBarChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ActiveCodeChTablePanel
extends JPanel {
    private static final Color lightBlue = new Color(140, 160, 255);
    private JPanel chartPanel;
    private JPanel bottomChartPanel;
    private JScrollPane tablePanel;
    private JPanel centerPanel;
    private BorderWrapper centerPanelWithBorder;
    private JTable table;
    private TraceChart traceChart;
    private BasicBarChart barChart;
    private Container metricsPanel;
    private DynamicLabel averagingLabel;
    private ActiveCodeTableModel tableModel;
    Vector tableData;

    public ActiveCodeChTablePanel(TraceChart traceChart, BasicBarChart basicBarChart, Container container, DynamicLabel dynamicLabel) {
        super(new BorderLayout());
        this.setBackground(null);
        this.traceChart = traceChart;
        this.barChart = basicBarChart;
        this.metricsPanel = container;
        if (dynamicLabel != null) {
            this.averagingLabel = dynamicLabel;
        }
        this.traceChart.setPreferredSize(new Dimension(130, 96));
        this.barChart.setPreferredSize(new Dimension(165, 153));
        this.chartPanel = new JPanel(new BorderLayout(2, 2));
        this.chartPanel.setBackground(null);
        this.bottomChartPanel = new JPanel(new BorderLayout(2, 2));
        this.bottomChartPanel.setBackground(null);
        this.chartPanel.add((Component)this.bottomChartPanel, "South");
        this.addCharts(true);
        this.tableModel = new ActiveCodeTableModel(3, 0);
        this.table = new JTable(this.tableModel);
        this.table.setBackground(Color.black);
        this.table.setForeground(Color.white);
        this.table.setSelectionForeground(Color.black);
        this.table.setSelectionBackground(Color.yellow);
        this.table.getTableHeader().setBackground(lightBlue);
        this.table.setShowGrid(false);
        this.tablePanel = new JScrollPane(this.table);
        this.tablePanel.setBackground(null);
        this.tablePanel.getViewport().setBackground(null);
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setBackground(null);
        this.centerPanel.add((Component)this.tablePanel, "Center");
        this.centerPanel.add((Component)this.chartPanel, "East");
        this.tableModel.setRowCount(18);
        HydroBorderPainterConfig hydroBorderPainterConfig = new HydroBorderPainterConfig(Color.black, 2, TraceAnalyzer.getChartBorder().getBorderColors());
        this.centerPanelWithBorder = new BorderWrapper(this.centerPanel, hydroBorderPainterConfig, true);
        this.add((Component)this.centerPanelWithBorder, "Center");
    }

    public void dispose() {
        this.removeAll();
        this.traceChart = null;
        this.barChart = null;
        this.metricsPanel = null;
    }

    public void addCharts(boolean bl) {
        if (bl) {
            this.add((Component)this.metricsPanel, "South");
            this.chartPanel.add((Component)this.barChart, "North");
            if (this.averagingLabel != null) {
                this.bottomChartPanel.add((Component)this.averagingLabel, "North");
            }
            this.bottomChartPanel.add((Component)this.traceChart, "South");
        } else {
            this.remove(this.metricsPanel);
            this.chartPanel.remove(this.barChart);
            this.bottomChartPanel.remove(this.averagingLabel);
            this.bottomChartPanel.remove(this.traceChart);
        }
    }

    public void updateTable(Vector vector) {
        this.tableData = vector;
        this.tableModel.setRowCount(this.tableData.size());
        this.tableModel.fireTableDataChanged();
    }

    public void pageUp() {
        int n = this.tablePanel.getVerticalScrollBar().getValue();
        this.tablePanel.getVerticalScrollBar().setValue(n -= this.calculateSingleRowScrollSize() * 18);
    }

    public void pageDown() {
        int n = this.tablePanel.getVerticalScrollBar().getValue();
        this.tablePanel.getVerticalScrollBar().setValue(n += this.calculateSingleRowScrollSize() * 18);
    }

    public void rowUp() {
        int n = this.tablePanel.getVerticalScrollBar().getValue();
        this.tablePanel.getVerticalScrollBar().setValue(n -= this.calculateSingleRowScrollSize());
    }

    public void rowDown() {
        int n = this.tablePanel.getVerticalScrollBar().getValue();
        this.tablePanel.getVerticalScrollBar().setValue(n += this.calculateSingleRowScrollSize());
    }

    private int calculateSingleRowScrollSize() {
        int n = this.table.getRowCount();
        int n2 = this.tablePanel.getVerticalScrollBar().getMaximum();
        int n3 = (int)Math.ceil(n2 / n);
        return n3;
    }

    public void setSelectedRow(int n) {
        this.table.getSelectionModel().clearSelection();
        if (n >= 0 && n <= this.table.getRowCount()) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    public Rectangle getChartsPanelBounds() {
        return this.centerPanelWithBorder.getBounds();
    }

    protected class ActiveCodeTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Code", "Type", "CDP (dBc)"};
        int iRow;
        int iCol;

        public ActiveCodeTableModel(int n, int n2) {
            this.iCol = n;
            this.iRow = n2;
        }

        public void setColumnCount(int n) {
            this.iCol = n;
        }

        public void setRowCount(int n) {
            this.iRow = n;
        }

        public int getColumnCount() {
            return this.iCol;
        }

        public int getRowCount() {
            return this.iRow;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((String[])ActiveCodeChTablePanel.this.tableData.elementAt(n))[n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

