/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.marker.MarkerListener;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AntennaTraceAnalyzer
extends TraceAnalyzer {
    private LongActuator refLevel;
    private LongActuator scaleDiv;
    protected AntennaTraceChart lineChart;
    private Container pane;
    JComponent chartPanel;
    protected JPanel topPanel;
    protected DynamicLabel markerLabel;
    protected DynamicLabel calibrationLabel;
    protected MarkerListener markerModeListener;
    protected LimitStateListener limitsStateListener;

    protected abstract void setLimitsState();

    public AntennaTraceAnalyzer(LongActuator longActuator, LongActuator longActuator2, String string) {
        super(string);
        this.refLevel = longActuator;
        this.scaleDiv = longActuator2;
        this.listenToActuator(longActuator);
        this.listenToActuator(longActuator2);
        this.lineChart = this.getLineChart();
        this.lineChart.setyAxisStrategy(TraceAnalyzer.refLevelStrategy);
        this.lineChart.setDrawYAxisLabels(true);
        this.calibrationLabel = new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return AntennaTraceAnalyzer.this.isValidCalibration(measurement) ? AntennaTraceAnalyzer.this.getCalibratedText() : AntennaTraceAnalyzer.this.getUncalibratedText();
            }
        };
        this.markerLabel = new DynamicLabel("marker", 4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return AntennaTraceAnalyzer.this.getCurrentMarkerDescription();
            }
        };
        this.markerModeListener = new MarkerListener(){

            public void markerUpdated() {
                if (AntennaTraceAnalyzer.this.topPanel != null && AntennaTraceAnalyzer.this.markerLabel != null) {
                    AntennaTraceAnalyzer.this.topPanel.removeAll();
                    AntennaTraceAnalyzer.this.topPanel.add(AntennaTraceAnalyzer.this.calibrationLabel);
                    AntennaTraceAnalyzer.this.topPanel.add(AntennaTraceAnalyzer.this.markerLabel);
                    AntennaTraceAnalyzer.this.topPanel.validate();
                }
            }
        };
        this.limitsStateListener = new LimitStateListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.markerModeListener != null && this.getMarkerButtonFactory() != null) {
            Marker[] markerArray = this.getMarkerButtonFactory().getMarkers();
            for (int i = 0; i < markerArray.length; ++i) {
                markerArray[i].removeMarkerListener(this.markerModeListener);
            }
        }
        this.markerModeListener = null;
        this.limitsStateListener.dispose();
        this.limitsStateListener = null;
    }

    public void setMarkerButtonFactory(MarkerButtonFactory markerButtonFactory) {
        super.setMarkerButtonFactory(markerButtonFactory);
        if (this.markerModeListener != null) {
            Marker[] markerArray = this.getMarkerButtonFactory().getMarkers();
            for (int i = 0; i < markerArray.length; ++i) {
                markerArray[i].addMarkerListener(this.markerModeListener);
            }
            this.markerModeListener.markerUpdated();
        }
    }

    protected AntennaTraceChart getLineChart() {
        return new AntennaTraceChart(){

            protected void showLimits(Graphics graphics, int n, int n2) {
            }
        };
    }

    public void init() {
        this.setBackground(MenuPanel.BG_COLOR);
        this.chartPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.chartPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.placeComponent(this.chartPanel, gridBagLayout, gridBagConstraints, this.makeTopPanel());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        this.updateChartVerticalRange();
        this.placeComponent(this.chartPanel, gridBagLayout, gridBagConstraints, this.lineChart);
        this.addXAxisLabels(gridBagConstraints, gridBagLayout);
        gridBagConstraints.weightx = 0.0;
        this.addBottomPanel(this.chartPanel, this.createBottomPanel());
        this.lineChart.addDLabel(this.getAverageDynamicLabel(), -12, 25);
    }

    protected void addXAxisLabels(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout) {
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.placeComponent(this.chartPanel, gridBagLayout, gridBagConstraints, this.addLabel(this.makeStartFrequencyLabel()));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 10;
        this.placeComponent(this.chartPanel, gridBagLayout, gridBagConstraints, this.addLabel(this.makeCenterFrequencyLabel()));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.placeComponent(this.chartPanel, gridBagLayout, gridBagConstraints, this.addLabel(this.makeStopFrequencyLabel()));
    }

    protected JComponent makeTopPanel() {
        this.topPanel = new JPanel(new GridLayout(2, 1));
        this.topPanel.setBackground(null);
        this.topPanel.add(this.addLabel(this.calibrationLabel));
        this.topPanel.add(this.addLabel(this.markerLabel));
        return this.topPanel;
    }

    public TraceChart getChart() {
        return this.lineChart;
    }

    public TraceChart getOurChart() {
        return this.lineChart;
    }

    protected String getUncalibratedText() {
        return Text.Uncalibrated;
    }

    protected String getCalibratedText() {
        return Text.Calibrated;
    }

    protected abstract boolean isValidCalibration(Measurement var1);

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return TraceAnalyzer.refLevelStrategy;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return TraceAnalyzer.refLevelStrategy;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return TraceAnalyzer.freqStrategy;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public void updateChartVerticalRange() {
        this.getChart().setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() + this.getScaleDiv().intValue() * 10);
    }

    protected Component getPane() {
        return this.pane;
    }

    protected Color getDataBackgroundColor() {
        return MenuPanel.BG_COLOR;
    }

    protected TraceChart[] getCharts() {
        return new TraceChart[]{this.getChart()};
    }

    protected void addBottomPanel(JComponent jComponent, Component component) {
        this.pane = new JPanel();
        this.pane.setLayout(new BorderLayout(0, 4));
        this.pane.setBackground(null);
        this.pane.add((Component)new BorderWrapper(jComponent, TraceAnalyzer.getChartBorder(), true), "Center");
        this.pane.add(component, "South");
    }

    protected void panXaxis(long l, long l2) {
        if (GlobalKeyManager.isKeyPressInProcess()) {
            TraceChart traceChart = this.getChart();
            traceChart.setManualXRange(true);
            traceChart.setXStart(l);
            traceChart.setXStop(l2);
            this.updateLabels();
            this.repaint();
        }
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle = this.chartPanel.getBounds();
        rectangle.x += n;
        rectangle.y += n2;
        return super.filterPrintImage(image, rectangle);
    }

    protected abstract long getSettingsXstart();

    protected abstract long getSettingsXstop();

    protected abstract Component createBottomPanel();

    protected abstract TraceAnalyzer.AverageDynamicLabel getAverageDynamicLabel();

    public class XStopListener
    implements ValueListener {
        public String getListenerName() {
            return AntennaTraceAnalyzer.this.listenerBaseName + ".xStopListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            AntennaTraceAnalyzer.this.panXaxis(AntennaTraceAnalyzer.this.getSettingsXstart(), valueInterface.longValue());
        }
    }

    public class XStartListener
    implements ValueListener {
        public String getListenerName() {
            return AntennaTraceAnalyzer.this.listenerBaseName + ".xStartListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            AntennaTraceAnalyzer.this.panXaxis(valueInterface.longValue(), AntennaTraceAnalyzer.this.getSettingsXstop());
        }
    }

    protected static class LimitStateListener
    implements ValueListener {
        private String listenerName = ".limitsSummaryListener";
        private String baseName = null;
        private AntennaTraceAnalyzer analyzer;

        public LimitStateListener(AntennaTraceAnalyzer antennaTraceAnalyzer) {
            this.analyzer = antennaTraceAnalyzer;
        }

        public void dispose() {
            this.analyzer = null;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.analyzer.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.analyzer.setLimitsState();
        }
    }
}

