/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.util.Resources;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;

public abstract class BarChart
extends TraceChart {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$analyzer$BarChart == null ? (class$elgato$infrastructure$analyzer$BarChart = BarChart.class$("elgato.infrastructure.analyzer.BarChart")) : class$elgato$infrastructure$analyzer$BarChart).getName());
    private static final Color COLOR_GRID = res.getColor("gridColor");
    private static final Color WALSH_COLOR = Color.yellow;
    protected static final int WALSH_CODE_ROWS = 3;
    public static final Color NOISE_COLOR = Color.gray;
    public static final Color UNKNOWN_COLOR = new Color(230, 192, 140);
    private int alignmentLeftWeight = 1;
    static /* synthetic */ Class class$elgato$infrastructure$analyzer$BarChart;

    public BarChart() {
        this.setGridColor(COLOR_GRID);
        this.setDrawGridX(false);
        this.setDrawGridY(true);
    }

    public void setAlignment(int n) {
        this.alignmentLeftWeight = n;
    }

    protected void getChartInsets(Insets insets) {
        insets.bottom = this.getBottomSpace();
        int n = this.getUnitBarWidth() * this.getSlotCount() + this.getSlotSpacing() * (this.getSlotCount() - 1);
        int n2 = this.getTraceCanvasSize().width - n;
        insets.left = n2 * this.alignmentLeftWeight >> 1;
        insets.right = n2 - insets.left;
    }

    protected int getBottomSpace() {
        FontMetrics fontMetrics = BarChart.getFontMetricsForFont(this.getXAxisFont());
        return fontMetrics.getHeight() * this.getXAxisRows();
    }

    protected int getUnitBarWidth() {
        int n = this.getTraceCanvasSize().width;
        int n2 = this.getSlotCount();
        if (n2 == 0) {
            return n;
        }
        return (n - (this.getSlotSpacing() * n2 - 1)) / n2;
    }

    protected static FontMetrics getFontMetricsForFont(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected abstract Font getXAxisFont();

    protected abstract int getXAxisRows();

    protected abstract int getSlotCount();

    protected abstract int getSlotSpacing();

    protected boolean isChartDrawable() {
        return this.getSlotCount() != 0;
    }

    protected void drawWalshCode(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string) {
        graphics.setFont(this.getXAxisFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = n % 3 + 1;
        int n7 = n2 + (n5 - fontMetrics.stringWidth(string)) / 2;
        int n8 = n3 + n4 + fontMetrics.getAscent() * n6 + 2;
        int n9 = n2 + (n5 >> 1);
        graphics.drawLine(n9, n3 + n4 + 1, n9, n8 - fontMetrics.getAscent());
        graphics.setColor(WALSH_COLOR);
        graphics.drawString(string, n7, n8);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

