/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.analyzer.BasicBarChartLimitsMask;
import elgato.infrastructure.analyzer.BasicBarChartModel;
import elgato.infrastructure.analyzer.LabelPainter;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class BasicBarChart
extends BarChart {
    private static final int SPACE_BETWEEN_LABELS_AND_CHART = 1;
    private final Font barValueFont;
    private final Font labelRotatorFont;
    private BasicBarChartModel model;
    private LabelPainter xAxisLabelPainter;
    private Image limitsMaskLowTab;
    private Image limitsMaskHighTab;
    private boolean displayBarValues;
    private boolean displayDeltaValues;
    private Color constantXAxisLabelColor;
    private int slotSpacing;
    private Color maskColor;
    NumberFieldStrategy deltaValueStrategy;

    public BasicBarChart(BasicBarChartModel basicBarChartModel, LabelPainter labelPainter) {
        this.labelRotatorFont = this.barValueFont = new Font("SansSerif", 0, 9);
        this.displayDeltaValues = false;
        this.slotSpacing = 3;
        this.maskColor = Color.yellow;
        this.deltaValueStrategy = new FixedPointNumberFieldStrategy(1, "dB");
        this.model = basicBarChartModel;
        this.xAxisLabelPainter = labelPainter;
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        super.setMeasurement(traceMeasurement);
        this.model.setMeasurement(traceMeasurement);
        this.refresh();
    }

    private void initializeLabelPainter() {
        this.xAxisLabelPainter.clearLabels();
        for (int i = 0; i < this.model.getNumBars(); ++i) {
            Color color = this.constantXAxisLabelColor != null ? this.constantXAxisLabelColor : this.model.getColor(i);
            this.xAxisLabelPainter.addLabel(this.model.getLabel(i), color, this.labelRotatorFont);
        }
    }

    public void refresh() {
        this.initializeLabelPainter();
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        BasicBarChartLimitsMask basicBarChartLimitsMask;
        int n5 = this.getUnitBarWidth();
        int n6 = this.getSlotSpacing();
        int n7 = n6 / 2;
        int n8 = this.getYTop();
        int n9 = this.getYBottom();
        int n10 = n9 - n8;
        if (n4 == 0 || n10 == 0) {
            return;
        }
        graphics.translate(n, n2);
        int n11 = this.getBottomSpace();
        graphics.setFont(this.barValueFont);
        String[] stringArray = new String[2];
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, this.model.getValueUnits());
        if (this.model instanceof BasicBarChartLimitsMask) {
            basicBarChartLimitsMask = (BasicBarChartLimitsMask)((Object)this.model);
            this.limitsMaskLowTab = ImageIcon.loadImage("images/LimitsMaskTab-L.png", this);
            this.limitsMaskHighTab = ImageIcon.loadImage("images/LimitsMaskTab-H.png", this);
        } else {
            basicBarChartLimitsMask = null;
        }
        Point point = null;
        boolean bl = basicBarChartLimitsMask != null && basicBarChartLimitsMask.isMaskEnabled();
        int n12 = 0;
        int n13 = 0;
        for (int i = 0; i < this.model.getNumBars(); ++i) {
            if (this.model.isActive(i)) {
                Image image;
                int n14;
                int n15 = this.model.getValue(i);
                int n16 = n15;
                if (n16 > n8) {
                    n16 = n8;
                }
                if (n16 < n9) {
                    n16 = n9;
                }
                int n17 = (n16 - n8) * n4 / n10;
                int n18 = n4 - n17;
                if (i == 0) {
                    n12 = n15;
                }
                graphics.setColor(this.model.getColor(i));
                graphics.fillRect(n13, n17, n5, n4 - n17);
                if (this.displayDeltaValues && i != 0 & n18 > 20) {
                    int n19 = 255 - this.model.getColor(i).getRed();
                    int n20 = 255 - this.model.getColor(i).getBlue();
                    n14 = 255 - this.model.getColor(i).getGreen();
                    graphics.setColor(new Color(n19, n14, n20));
                    this.deltaValueStrategy.formatWithUnits(n15 - n12, stringArray);
                    stringArray[1] = Text.DeltaSymbol + stringArray[1];
                    TraceChart.drawCenteredStringsBottomJustified(graphics, n13, n17 + n18 / 2 + 10, n5, stringArray, 0, n4);
                }
                if ((image = this.model.getBottomOfBarImage(i)) != null) {
                    graphics.drawImage(image, n13 + (n5 - image.getWidth(null)) / 2, n4 - image.getHeight(null) - 5, null);
                }
                if (bl) {
                    int n21;
                    int n22;
                    Rectangle rectangle = graphics.getClipBounds();
                    graphics.setClip(0, 0, n3, n4);
                    graphics.setColor(this.maskColor);
                    if (point == null) {
                        point = new Point(n13 - n7, n4 - 1);
                    }
                    n14 = n13 + n5 + n7;
                    int n23 = basicBarChartLimitsMask.getHighLimit(i);
                    int n24 = basicBarChartLimitsMask.getLowLimit(i);
                    int n25 = (n23 - n8) * n4 / n10;
                    graphics.drawLine(point.x, point.y, point.x, n25);
                    graphics.drawLine(point.x, n25, n14, n25);
                    if (i < this.model.getNumBars() / 2) {
                        n22 = n14 - 3 - this.limitsMaskLowTab.getWidth(null);
                        n21 = n14 - 3 - this.limitsMaskHighTab.getWidth(null);
                    } else {
                        n22 = n21 = point.x + 3;
                    }
                    graphics.drawImage(this.limitsMaskHighTab, n21, n25 - this.limitsMaskHighTab.getHeight(null), null);
                    if (n24 != Integer.MIN_VALUE) {
                        int n26 = (n24 - n8) * n4 / n10;
                        graphics.drawLine(point.x, point.y, point.x, n26);
                        if (i < this.model.getNumBars() - 1) {
                            int n27 = basicBarChartLimitsMask.getHighLimit(i + 1);
                            int n28 = (n27 - n8) * n4 / n10;
                            graphics.drawLine(n14, n26, n14, n28);
                        }
                        graphics.drawLine(point.x, n26, n14, n26);
                        graphics.drawImage(this.limitsMaskLowTab, n22, n26 + 1, null);
                    }
                    point.x = n14;
                    point.y = n25;
                    if (i == this.model.getNumBars() - 1 || !this.model.isActive(i + 1)) {
                        graphics.setColor(this.maskColor);
                        graphics.drawLine(point.x, point.y, point.x, n4 - 1);
                    }
                    graphics.setClip(rectangle);
                }
                if (this.displayBarValues) {
                    graphics.setColor(Color.white);
                    fixedPointNumberFieldStrategy.formatWithUnits(n15, stringArray);
                    TraceChart.drawCenteredStringsBottomJustified(graphics, n13, n17 - 2, n5, stringArray, 0, n4);
                }
            }
            this.xAxisLabelPainter.paintLabel(i, this, graphics, n13, n4 + 1, n5, n11);
            n13 += n5 + n6;
        }
        graphics.translate(-n, -n2);
    }

    protected String getUnits() {
        return this.model.getValueUnits();
    }

    protected int getBottomSpace() {
        return this.xAxisLabelPainter.getMaximumHeight() + 1;
    }

    protected Font getXAxisFont() {
        throw new RuntimeException("Not used");
    }

    protected int getXAxisRows() {
        throw new RuntimeException("Not used");
    }

    protected int getSlotCount() {
        return this.model.getNumBars();
    }

    public int getSlotSpacing() {
        return this.slotSpacing;
    }

    public void setSlotSpacing(int n) {
        this.slotSpacing = n;
    }

    public boolean isDisplayBarValues() {
        return this.displayBarValues;
    }

    public void setDisplayBarValues(boolean bl) {
        this.displayBarValues = bl;
    }

    public void setDisplayDeltaValues(boolean bl) {
        this.displayDeltaValues = bl;
    }

    public Color getConstantXAxisLabelColor() {
        return this.constantXAxisLabelColor;
    }

    public void setConstantXAxisLabelColor(Color color) {
        this.constantXAxisLabelColor = color;
    }
}

