/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.util.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;

public final class DialPainter {
    private static final boolean disablePaint = "true".equals(System.getProperty("DialPainter.disablePaint"));
    private int[] arcPoints;
    private int[] arcColors;
    private int radMaj;
    private int radMin;
    private Point center = new Point();
    private Dimension size = new Dimension();
    private int[] pix;
    private Image renderedImage;
    private boolean dirty = true;
    private int startPointX;
    private int startPointY;
    private int stopPointX;
    private int stopPointY;
    private int angStart;
    private int angStop;
    private final Timer renderTimer = new Timer("DialPainter/render");

    public void setArcAngles(int[] nArray) {
        boolean bl = false;
        if (nArray == null || this.arcPoints == null || nArray.length != this.arcPoints.length) {
            bl = true;
        }
        if (!bl) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.arcPoints[i]) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.arcPoints = nArray;
            this.markDirty();
        }
    }

    public void setArcColors(Color[] colorArray) {
        this.arcColors = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this.arcColors[i] = colorArray[i].getRGB();
        }
        this.markDirty();
    }

    public void setMajorRadius(int n) {
        if (n != this.radMaj) {
            this.radMaj = n;
            this.markDirty();
        }
    }

    public void setMinorRadius(int n) {
        if (n != this.radMin) {
            this.radMin = n;
            this.markDirty();
        }
    }

    public void setCenter(int n, int n2) {
        if (n != this.center.x || n2 != this.center.y) {
            this.center.x = n;
            this.center.y = n2;
            this.markDirty();
        }
    }

    private void markDirty() {
        this.dirty = true;
    }

    public void paint(Graphics graphics, int n, int n2, Component component) {
        if (n != this.size.width || n2 != this.size.height) {
            this.size.width = n;
            this.size.height = n2;
            this.markDirty();
        }
        if (disablePaint) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, n, n2);
            graphics.drawLine(0, n2 - 1, n, 0);
        } else {
            if (this.dirty) {
                this.renderImage(component);
            }
            graphics.drawImage(this.renderedImage, 0, 0, null);
        }
    }

    private void renderImage(Component component) {
        this.dirty = false;
        int n = this.size.width * this.size.height;
        if (this.pix == null || this.pix.length != n) {
            this.pix = new int[n];
        } else {
            for (int i = 0; i < this.pix.length; ++i) {
                this.pix[i] = 0;
            }
        }
        this.renderTimer.start();
        this.renderArc();
        this.renderTimer.stop();
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.size.width, this.size.height, this.pix, 0, this.size.width);
        this.renderedImage = component.createImage(memoryImageSource);
        if (Timer.isEnabled()) {
            this.renderTimer.dump();
        }
    }

    private void renderArc() {
        int n;
        int n2 = this.center.x;
        int n3 = this.center.y;
        this.angStart = this.arcPoints[0];
        this.angStop = this.arcPoints[this.arcPoints.length - 1];
        this.startPointX = this.radMaj * FastMath.cos(this.angStart) >> 16;
        this.startPointY = this.radMaj * FastMath.sin(this.angStart) >> 16;
        this.stopPointX = this.radMaj * FastMath.cos(this.angStop) >> 16;
        this.stopPointY = this.radMaj * FastMath.sin(this.angStop) >> 16;
        int n4 = Math.max(this.startPointY + n3, this.stopPointY + n3);
        n4 += this.radMin + 1;
        int n5 = this.size.height - 1;
        n5 = n3 - this.radMaj;
        int n6 = this.radMaj - this.radMin;
        n6 *= n6;
        int n7 = this.radMaj + this.radMin;
        n7 *= n7;
        int n8 = this.size.width * n;
        for (n = n5 -= this.radMin + 1; n <= n4; ++n) {
            int n9 = n - n3;
            int n10 = n9 * n9;
            for (int i = 0; i < this.size.width; ++i) {
                int n11 = i - n2;
                int n12 = n11 * n11 + n10;
                if (n12 >= n6 && n12 <= n7) {
                    int n13;
                    int n14;
                    int n15;
                    if (n12 == 0) {
                        n15 = 0;
                    } else {
                        n15 = n12 + 1 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                        n15 = n15 + n12 / n15 >> 1;
                    }
                    n15 -= this.radMaj;
                    int n16 = Integer.MIN_VALUE;
                    int n17 = 0;
                    int n18 = FastMath.atan2(n9, n11);
                    if (n18 >= this.angStart && n18 <= this.angStop) {
                        n17 = -1;
                        for (n14 = 0; n14 < this.arcPoints.length - 1; ++n14) {
                            if (n18 < this.arcPoints[n14] || n18 > this.arcPoints[n14 + 1]) continue;
                            n17 = n14;
                            break;
                        }
                        n16 = n15 * (65536 / this.radMin);
                    } else {
                        n14 = DialPainter.distance(n11, n9, this.startPointX, this.startPointY);
                        if (n14 <= this.radMin) {
                            n16 = n14 * (65536 / this.radMin);
                            n17 = 0;
                        } else {
                            n13 = DialPainter.distance(n11, n9, this.stopPointX, this.stopPointY);
                            if (n13 <= this.radMin) {
                                n16 = n13 * (65536 / this.radMin);
                                n17 = this.arcColors.length - 1;
                            }
                        }
                    }
                    if (n16 != Integer.MIN_VALUE) {
                        n14 = FastMath.cos(n16 / 8);
                        n14 = 65536 - (n14 >> 2);
                        n13 = this.arcColors[n17];
                        this.pix[n8] = (n13 & 0xFF) * n14 >> 16 | (n13 >> 8 & 0xFF) * n14 >> 16 << 8 | (n13 >> 16 & 0xFF) * n14 >> 16 << 16 | 0xFF000000;
                    }
                }
                ++n8;
            }
        }
    }

    private static int distance(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        return FastMath.sqrt(n5 * n5 + n6 * n6);
    }
}

