/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.AbstractLabelPainter;
import elgato.infrastructure.analyzer.BarChart;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class LabelRotator
extends AbstractLabelPainter {
    protected AbstractLabelPainter.Label createLabel(String string, Color color, Font font) {
        return new RotatedLabel(string, color, font);
    }

    public int getMaximumHeight() {
        int n = 0;
        for (int i = 0; i < this.labels.size(); ++i) {
            AbstractLabelPainter.Label label = (AbstractLabelPainter.Label)this.labels.elementAt(i);
            int n2 = BarChart.getFontMetricsForFont(label.font).stringWidth(label.text);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void paintLabel(int n, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        RotatedLabel rotatedLabel = (RotatedLabel)this.labels.elementAt(n);
        if (rotatedLabel.image == null) {
            rotatedLabel.render(component);
        }
        graphics.drawImage(rotatedLabel.image, n2 + (n4 - rotatedLabel.image.getWidth(null)) / 2, n3, null);
    }

    static class RotatedLabel
    extends AbstractLabelPainter.Label {
        Image image;

        public RotatedLabel(String string, Color color, Font font) {
            super(string, color, font);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(Component component) {
            FontMetrics fontMetrics = BarChart.getFontMetricsForFont(this.font);
            int n = fontMetrics.stringWidth(this.text);
            int n2 = fontMetrics.getHeight();
            Image image = component.createImage(n, n2);
            Graphics graphics = image.getGraphics();
            try {
                graphics.setColor(AbstractLabelPainter.getBackgroundColor());
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(this.color);
                graphics.setFont(this.font);
                graphics.drawString(this.text, 0, fontMetrics.getAscent());
            }
            finally {
                graphics.dispose();
            }
            int[] nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
            try {
                if (!pixelGrabber.grabPixels()) {
                    throw new RuntimeException("Couldn't grab pixels for rotated label");
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while grabbing pixels for rotated label");
            }
            int[] nArray2 = new int[nArray.length];
            int n3 = n2;
            int n4 = n;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                int n6 = 0;
                while (n6 < n) {
                    int n7 = i;
                    int n8 = n - n6 - 1;
                    nArray2[n8 * n3 + n7] = nArray[n5];
                    ++n6;
                    ++n5;
                }
            }
            MemoryImageSource memoryImageSource = new MemoryImageSource(n3, n4, nArray2, 0, n3);
            Image image2 = component.createImage(memoryImageSource);
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image2, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.image = image2;
        }
    }
}

