/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.util.Resources;
import java.awt.Color;
import java.awt.Graphics;

public class LineChart
extends TraceChart {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$analyzer$LineChart == null ? (class$elgato$infrastructure$analyzer$LineChart = LineChart.class$("elgato.infrastructure.analyzer.LineChart")) : class$elgato$infrastructure$analyzer$LineChart).getName());
    private static final Color COLOR_GRID = res.getColor("grid.color");
    protected static final Color COLOR_TRACE = res.getColor("trace.color");
    protected boolean bLineChart;
    protected int[] traceXpts;
    protected int[] traceYpts;
    protected long lastStart = -99999999L;
    protected long lastStop = 999999999L;
    protected int lastTraceLength = -1;
    protected boolean refreshXValues = true;
    protected long yTop;
    protected long yBottom;
    protected long yRange;
    static /* synthetic */ Class class$elgato$infrastructure$analyzer$LineChart;

    public LineChart() {
        this.setGridColor(COLOR_GRID);
        this.setDrawGridX(true);
        this.setDrawGridY(true);
        this.bLineChart = true;
    }

    protected boolean isChartDrawable() {
        return this.getWidth() != 0 && this.getHeight() != 0 && this.getXStopTraceIndex() - this.getXStartTraceIndex() > 1;
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = this.getMeasurement().getTrace();
        Color color = COLOR_TRACE;
        this.drawTrace(graphics, n, n2, n3, n4, nArray, color);
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, Color color) {
        this.drawTrace(graphics, n, n2, n3, n4, nArray, color, 0);
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, Color color, int n5) {
        this.yTop = this.getYTop();
        this.yBottom = this.getYBottom();
        this.yRange = this.yBottom - this.yTop + 1L;
        graphics.setClip(n, n2, n3, n4);
        int n6 = this.getXStartTraceIndex();
        int n7 = this.getXStopTraceIndex();
        int n8 = n7 + 1;
        int n9 = n8 - n6;
        int n10 = n9 + 1;
        if (n6 > n7 || n10 > 8192) {
            return;
        }
        this.allocateArrays(n10);
        long l = this.measurement.getTraceStartValue();
        long l2 = this.measurement.getTraceStopValue();
        int n11 = this.measurement.getTraceLength();
        long l3 = this.getXStart();
        long l4 = this.getXStop();
        int n12 = n6;
        int n13 = 0;
        while (n12 <= n8) {
            long l5 = this.measurement.getXValueForIndex(n12, l, l2, n11);
            this.traceXpts[n13] = n + (int)((l5 - l3) * (long)n3 / (l4 - l3));
            int n14 = n12 >= nArray.length ? nArray[nArray.length - 1] : (n12 < 0 ? nArray[0] : nArray[n12]);
            int n15 = (int)(((long)n14 - this.yTop) * (long)n4 / this.yRange);
            this.traceYpts[n13] = n2 + n15;
            ++n12;
            ++n13;
        }
        graphics.setColor(color);
        graphics.drawPolyline(this.traceXpts, this.traceYpts, n10);
        this.drawMarkers(graphics, n, n2, n3, n4, n5);
    }

    protected void allocateArrays(int n) {
        if (this.traceXpts == null || this.traceXpts.length < n) {
            this.traceXpts = new int[n];
            this.traceYpts = new int[n];
        }
    }

    protected void drawMarkers(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Marker[] markerArray = this.getMarkers();
        if (markerArray == null) {
            return;
        }
        for (int i = 0; i < markerArray.length; ++i) {
            if (markerArray[i].getMarkerModel().getMarkerTraceIndex() != n5) continue;
            markerArray[i].setGraphicInfo(this.yTop, n4, n2, this.yRange, this.bLineChart);
            markerArray[i].paint(this, graphics, this.traceXpts, this.traceYpts);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

