/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.strategies.DistanceFeetStrategy;
import elgato.infrastructure.strategies.DistanceMetersStrategy;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurement;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LocationMonitor
implements MeasurementListener {
    private static final int HundredThousandScale = 100000;
    private static final int SecondsPerDegree = 3600;
    private static final int SecondsPerMinute = 60;
    private static LocationMonitor instance;
    private Exception creationTrace = new Exception("Backtrace");
    private TimeFreqRefMeasurement tfrMeas;
    private Vector listeners = new Vector(0);
    static /* synthetic */ Class class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement;

    protected LocationMonitor() {
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this, class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement == null ? (class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement = LocationMonitor.class$("elgato.measurement.timeFreqRef.TimeFreqRefMeasurement")) : class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurement);
    }

    public static LocationMonitor instance() {
        return instance;
    }

    public void measurementReceived(final Measurement measurement) {
        Runnable runnable = new Runnable(){

            public void run() {
                LocationMonitor.this.setMeasurement(measurement);
                LocationMonitor.this.fireChangeEvent();
            }
        };
        EventDispatchThread.invokeLater(runnable, "LocationMonitor.measurementReceived");
    }

    private void setMeasurement(Measurement measurement) {
        if (this.tfrMeas != null) {
            this.tfrMeas.recycle();
        }
        this.tfrMeas = (TimeFreqRefMeasurement)measurement;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.removeElement(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.elementAt(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean isDataAvailable() {
        return this.tfrMeas != null;
    }

    public boolean isGpsLocked() {
        return this.tfrMeas.getGpsDataValid() == 1;
    }

    public String getLatitude() {
        return LocationMonitor.formatLatitude(this.tfrMeas.getCurrentLatitude());
    }

    public String getLongitude() {
        return LocationMonitor.formatLongitude(this.tfrMeas.getCurrentLongitude());
    }

    public String getAltitude_feet() {
        return DistanceFeetStrategy.INSTANCE.format(this.tfrMeas.getCurrentAltitude());
    }

    public String getAltitude_meters() {
        return DistanceMetersStrategy.INSTANCE.format(this.tfrMeas.getCurrentAltitude());
    }

    public int getSatelliteCount() {
        return this.tfrMeas.getNumSatellite();
    }

    public String getTime() {
        return LocationMonitor.timeFormatter((long)this.tfrMeas.getCurrentTime() * 1000L);
    }

    public static String timeFormatter(long l) {
        Date date = new Date();
        date.setTime(l);
        return date.toString();
    }

    static String formatLatitude(long l) {
        if (l > 0L) {
            return LocationMonitor.formatLatLong(l, " N");
        }
        if (l < 0L) {
            return LocationMonitor.formatLatLong(-l, " S");
        }
        return LocationMonitor.formatLatLong(l, "");
    }

    static String formatLongitude(long l) {
        if (l > 0L) {
            return LocationMonitor.formatLatLong(l, " E");
        }
        if (l < 0L) {
            return LocationMonitor.formatLatLong(-l, " W");
        }
        return LocationMonitor.formatLatLong(l, "");
    }

    private static String formatLatLong(long l, String string) {
        long l2 = l / 100000L;
        long l3 = Math.abs(l % 100000L);
        long l4 = l3 * 3600L / 100000L;
        long l5 = l4 / 60L;
        long l6 = l4 % 60L;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(l2).append("\u00b0 ").append(l5).append("' ").append(l6).append("\"").append(string);
        return stringBuffer.toString();
    }

    public String getStringForSaveData() {
        if (this.isDataAvailable() && this.isGpsLocked()) {
            StringBuffer stringBuffer = new StringBuffer("Latitude: ");
            stringBuffer.append(this.getLatitude()).append("\n");
            stringBuffer.append("Longitude: ").append(this.getLongitude()).append("\n");
            stringBuffer.append("Altitude in Meters: ").append(this.getAltitude_meters()).append("\n");
            stringBuffer.append("Altitude in Feet: ").append(this.getAltitude_feet()).append("\n");
            stringBuffer.append("Satellites Tracked: ").append(this.getSatelliteCount()).append("\n");
            stringBuffer.append("Time: ").append(this.getTime()).append("\n");
            return stringBuffer.toString();
        }
        return "GPS Not Locked";
    }

    public static void initialize() {
        if (instance != null) {
            throw new AlreadyInitializedException(LocationMonitor.instance.creationTrace);
        }
        instance = new LocationMonitor();
    }

    public static void clearInstance() {
        if (!RuntimeConfiguration.isUnitTestMode()) {
            throw new RuntimeException("Hey! You can't call this in production code!");
        }
        instance = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AlreadyInitializedException
    extends RuntimeException {
        private final Exception firstInitializationBacktrace;

        public AlreadyInitializedException(Exception exception) {
            super("LocationMonitor already initialized");
            this.firstInitializationBacktrace = exception;
        }

        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            printStream.println("Location of first initialization:");
            this.firstInitializationBacktrace.printStackTrace(printStream);
        }

        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            printWriter.println("Location of first initialization:");
            this.firstInitializationBacktrace.printStackTrace(printWriter);
        }
    }
}

