/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.LocationMonitor;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.GrayScaleColorFlipFilter;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LocationMonitorWindow
extends JWindow {
    private static LocationMonitorWindow instance;
    private static final Color BG_COLOR;
    private static final String[] labels;
    private static final Font LABEL_FONT;
    private static final Font VALUE_FONT;
    private static final Color LABEL_COLOR;
    private static final Color VALUE_COLOR;
    private final LocationMonitor locationMonitor = LocationMonitor.instance();
    private final View view = new View();
    private final ChangeListener dataChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            LocationMonitorWindow.this.view.repaint();
        }
    };

    public static void showWindow() {
        if (instance == null) {
            Frame frame = (Frame)((Object)MeasurementFactory.instance().getScreenManager());
            instance = new LocationMonitorWindow(frame);
            Point point = frame.getLocation();
            point.translate(125, 96);
            UIHelper.fixWindowLocation(point);
            ((Component)instance).setLocation(point);
            instance.pack();
            instance.show();
        }
    }

    public static void hideWindow() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static LocationMonitorWindow instance() {
        return instance;
    }

    private LocationMonitorWindow(Frame frame) {
        super(frame);
        this.addKeyListener(GlobalKeyManager.instance());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                LocationMonitorWindow.this.locationMonitor.addChangeListener(LocationMonitorWindow.this.dataChangeListener);
            }

            public void windowClosed(WindowEvent windowEvent) {
                LocationMonitorWindow.this.locationMonitor.removeChangeListener(LocationMonitorWindow.this.dataChangeListener);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new CompoundBorder(new BevelBorder(0, Color.white, Color.gray), new MatteBorder(8, 8, 8, 8, BG_COLOR)));
        jPanel.add(this.view);
        this.getContentPane().add(jPanel);
    }

    String[] getMessageStrings() {
        return this.locationMonitor.isDataAvailable() && this.locationMonitor.isGpsLocked() ? labels : this.getAcquiringMessages();
    }

    String[] getAcquiringMessages() {
        if (!this.locationMonitor.isDataAvailable() || this.locationMonitor.getSatelliteCount() == 0) {
            return new String[]{Text.Acquiring_GPS_Signaldotdotdot, Text.zero_Satellites_Tracked, Text.LOCATION_MONITOR_GPS_NOT_LOCKED_REPOSITIONANTENNA_LINE1, Text.LOCATION_MONITOR_GPS_NOT_LOCKED_REPOSITIONANTENNA_LINE2, Text.LOCATION_MONITOR_GPS_NOT_LOCKED_REPOSITIONANTENNA_LINE3, Text.LOCATION_MONITOR_GPS_NOT_LOCKED_REPOSITIONANTENNA_LINE4};
        }
        if (this.locationMonitor.getSatelliteCount() == 1) {
            return new String[]{Text.Acquiring_GPS_Signaldotdotdot, Text.one_Satellite_Tracked};
        }
        return new String[]{Text.Acquiring_GPS_Signaldotdotdot, this.locationMonitor.getSatelliteCount() + " " + Text.satellites_Tracked};
    }

    String[] getValueStrings() {
        if (this.locationMonitor.isDataAvailable() && this.locationMonitor.isGpsLocked()) {
            return new String[]{this.locationMonitor.getLatitude(), this.locationMonitor.getLongitude(), this.locationMonitor.getAltitude_meters(), this.locationMonitor.getAltitude_feet(), String.valueOf(this.locationMonitor.getSatelliteCount()), this.locationMonitor.getTime()};
        }
        return null;
    }

    public Image renderToImage(boolean bl) {
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Image image = this.createImage(rectangle.width, rectangle.height);
        Graphics graphics = image.getGraphics();
        this.printComponents(graphics);
        if (bl) {
            GrayScaleColorFlipFilter grayScaleColorFlipFilter = new GrayScaleColorFlipFilter(rectangle, true, true);
            image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), grayScaleColorFlipFilter));
        }
        return image;
    }

    static {
        BG_COLOR = Color.black;
        labels = new String[]{Text.Latitude, Text.Longitude, Text.Altitude, "", Text.Satellites_Tracked, Text.Current_Time};
        LABEL_FONT = new Font("SansSerif", 1, 13);
        VALUE_FONT = new Font("SansSerif", 1, 13);
        LABEL_COLOR = Color.white;
        VALUE_COLOR = Color.white;
    }

    private class View
    extends JComponent {
        public View() {
            this.setBackground(BG_COLOR);
            this.setPreferredSize(new Dimension(380, 148));
        }

        protected void paintComponent(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics(LABEL_FONT);
            Dimension dimension = this.getSize();
            graphics.setColor(BG_COLOR);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = dimension.width * 3 / 8;
            String[] stringArray = LocationMonitorWindow.this.getMessageStrings();
            String[] stringArray2 = LocationMonitorWindow.this.getValueStrings();
            boolean bl = stringArray2 != null;
            int n2 = 7;
            int n3 = fontMetrics.getHeight() + 5;
            int n4 = (dimension.height - stringArray.length * n3) / 2 + fontMetrics.getAscent();
            for (int i = 0; i < stringArray.length; ++i) {
                graphics.setFont(LABEL_FONT);
                graphics.setColor(LABEL_COLOR);
                String string = stringArray[i];
                int n5 = n2;
                if (bl) {
                    n5 += n - 8 - fontMetrics.stringWidth(string);
                }
                graphics.drawString(string, n5, n4);
                if (stringArray2 != null) {
                    graphics.setFont(VALUE_FONT);
                    graphics.setColor(VALUE_COLOR);
                    graphics.drawString(stringArray2[i], n2 + n, n4);
                }
                n4 += n3;
            }
        }
    }
}

