/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.SpectralDataHistory;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

public class SpectralChart
extends JComponent {
    private static final int NO_DATA = Integer.MIN_VALUE;
    private static final int BG_COLOR = -16777216;
    public static final int VERTICAL_MARGIN = 11;
    private static final int BORDER_WIDTH = 1;
    private static final int LOCATION_LABELS_HEIGHT = 11;
    private MemoryImageSource memSrc;
    private Image memImg;
    private int memImgH;
    private int memImgW;
    private int[] pix;
    private boolean pixDirty;
    private int pixHead;
    private int dataStartSlot;
    private int dataEndSlot;
    private boolean drawLocationLabels;
    private boolean xAxisLinear = false;
    private SpectralDataHistory historyData;
    private int min;
    private int max;
    private Palette palette;
    private PaletteView paletteView = new PaletteView();
    private Marker[] markers;
    private static PaletteMaker[] paletteMakers = new PaletteMaker[]{new PaletteMaker("Full Color"){

        protected int[] getPaletteData() {
            return this.makeBlendedPalette(new int[]{0, 255, 59602, 56576, 0xFFFF00, 0xFF0000, 0xFFFFFF}, 1024);
        }
    }, new PaletteMaker("Grayscale"){

        protected int[] getPaletteData() {
            return this.makeBlendedPalette(new int[]{0, 0xFFFFFF}, 64);
        }
    }};

    public SpectralChart(int n) {
        this.dataStartSlot = 0;
        this.dataEndSlot = n - 1;
        this.configureBuffers(n);
        this.historyData.wipeData();
    }

    public SpectralChart(SpectralDataHistory spectralDataHistory) {
        this.historyData = spectralDataHistory;
    }

    private void configureBuffers(int n) {
        this.historyData = new SpectralDataHistory(n);
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
        this.paletteView.setPalette(palette);
        this.markPixDirty();
        this.paletteView.repaint();
        this.repaint();
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void setXAxisLinearity(boolean bl) {
        this.xAxisLinear = bl;
    }

    public void drawExtras(Graphics graphics) {
    }

    public boolean isDrawLocationLabels() {
        return this.drawLocationLabels;
    }

    public void setDrawLocationLabels(boolean bl) {
        this.drawLocationLabels = bl;
    }

    public int getLocationLabelsBarHeight() {
        if (this.isDrawLocationLabels()) {
            return 11;
        }
        return 0;
    }

    protected void paintComponent(Graphics graphics) {
        this.initPix();
        int n = this.memImgH;
        if (this.pixDirty) {
            this.render();
        }
        graphics.setColor(Color.white);
        graphics.drawRect(this.getImageLeft() - 1, this.getImageTop() - 1, this.getImageWidth(), this.getImageHeight() + 1);
        this.drawRows(graphics, this.pixHead, n - this.pixHead, this.getImageTop());
        if (this.pixHead != 0) {
            this.drawRows(graphics, 0, this.pixHead, this.getImageTop() + n - this.pixHead);
        }
        if (this.isDrawLocationLabels()) {
            this.paintLocationLabels(graphics, this.getImageLeft() - 2, this.getImageTop(), this.getImageWidth() + 1, this.getImageHeight(), this.dataStartSlot, this.dataEndSlot);
        }
        this.drawExtras(graphics);
        this.drawMarkers(graphics);
    }

    private void drawMarkers(Graphics graphics) {
        if (this.markers != null) {
            for (int i = 0; i < this.markers.length; ++i) {
                Marker marker = this.markers[i];
                marker.paintUsingVerticalLine(this, graphics, this.getImageLeft(), this.getImageTop(), this.getImageWidth(), this.getImageHeight() + this.getLocationLabelsBarHeight(), this.dataStartSlot, this.dataEndSlot, this.xAxisLinear);
            }
        }
    }

    private void drawRows(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(this.memImg, this.getImageLeft(), n3, this.memImgW, n3 + n2, 0, n, this.memImgW, n + n2, null);
    }

    private void render() {
        int n = 0;
        for (int i = -(this.memImgH - 1); i <= 0; ++i) {
            this.renderRow(i, n);
            n += this.memImgW;
        }
        this.pixHead = 0;
        this.pixDirty = false;
        this.memSrc.newPixels();
    }

    private void renderRow(int n, int n2) {
        int n3 = this.max - this.min + 1;
        int[] nArray = this.palette.getRGB();
        for (int i = 0; i < this.memImgW; ++i) {
            int n4;
            int n5 = this.historyData.getData(n, this.dataStartSlot + (this.dataEndSlot - this.dataStartSlot + 1) * i / this.memImgW);
            if (n5 == Integer.MIN_VALUE) {
                n4 = -16777216;
            } else {
                if (n5 < this.min) {
                    n5 = this.min;
                }
                if (n5 > this.max) {
                    n5 = this.max;
                }
                n5 -= this.min;
                n5 = n5 * nArray.length / n3;
                n4 = nArray[n5];
            }
            this.pix[n2++] = n4;
        }
    }

    public void clear() {
        this.historyData.wipeData();
        this.releaseImageBuffer();
    }

    public void addTrace(int[] nArray) {
        if (nArray.length != this.historyData.getDataWidth()) {
            this.configureBuffers(nArray.length);
            this.clear();
        }
        this.historyData.storeData(nArray);
        this.traceUpdated();
    }

    public void addTrace(int[] nArray, int[] nArray2, int n) {
        if (nArray.length != this.historyData.getDataWidth()) {
            this.configureBuffers(nArray.length);
            this.clear();
        }
        this.historyData.storeData(nArray, nArray2, n);
        this.traceUpdated();
    }

    public void traceUpdated() {
        if (this.pix != null) {
            this.renderRow(0, this.pixHead * this.memImgW);
            this.memSrc.newPixels(0, this.pixHead, this.memImgW, 1);
            this.pixHead = (this.pixHead + 1) % this.memImgH;
        }
    }

    public long getVisibleDuration() {
        return this.historyData.getDuration(this.memImgH);
    }

    public void setMax(int n) {
        this.max = n;
        this.markPixDirty();
    }

    public void setMin(int n) {
        this.min = n;
        this.markPixDirty();
    }

    private void markPixDirty() {
        this.pixDirty = true;
    }

    public void setSlotRange(int n, int n2) {
        this.dataStartSlot = n;
        this.dataEndSlot = n2;
        this.markPixDirty();
    }

    private boolean initPix() {
        int n = this.getImageWidth();
        int n2 = this.getImageHeight();
        if (this.memImg == null || this.memImgW != n || this.memImgH != n2) {
            this.memImgW = n;
            this.memImgH = n2;
            this.pix = new int[n * n2];
            for (int i = 0; i < this.pix.length; ++i) {
                this.pix[i] = -16777216;
            }
            this.memSrc = new MemoryImageSource(n, n2, this.pix, 0, n);
            this.memSrc.setAnimated(true);
            this.memImg = this.createImage(this.memSrc);
            this.pixHead = 0;
            this.render();
            return true;
        }
        return false;
    }

    protected int getImageWidth() {
        return this.getWidth() - 2;
    }

    protected int getImageHeight() {
        return this.getHeight() - 2 - 22 - 11;
    }

    protected int getImageTop() {
        return 12;
    }

    protected int getImageLeft() {
        return 1;
    }

    public void releaseImageBuffer() {
        this.memSrc = null;
        this.memImg = null;
        this.pix = null;
    }

    public void setMarkers(Marker[] markerArray) {
        this.markers = markerArray;
    }

    public JComponent getPaletteComponent() {
        return this.paletteView;
    }

    private void fillNice3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color.darker().darker());
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.setColor(color.brighter().brighter());
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    private void paintLocationLabels(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setFont(new Font("SansSerif", 0, 9));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = n2 + n4 + 11 - 2;
        this.fillNice3DRect(graphics, new Color(160, 160, 224), n, n2 + n4, n3, 11);
        int n8 = n6 - n5 + 1;
        graphics.setColor(Color.black);
        boolean bl = false;
        boolean bl2 = true;
        int n9 = (n6 - n5 + 1) / 8;
        int n10 = n5;
        while (!bl) {
            if (n10 >= n6) {
                bl = true;
                n10 = n6;
            }
            String string = Integer.toString(n10);
            int n11 = n + (n10 - n5 + 1) * n3 / n8;
            if (n11 <= 2) {
                n11 += 2;
            }
            if (n11 >= n3 - 2) {
                n11 -= 2;
            }
            graphics.drawLine(n11, n2 + n4, n11, n2 + n4 - 3);
            int n12 = fontMetrics.stringWidth(string);
            int n13 = n11 - n12 / 2;
            if (n13 < n) {
                n13 = n + 2;
            } else if (n13 + n12 > n + n3) {
                n13 = n + n3 - n12;
            }
            if (bl || bl2) {
                graphics.drawString(string, n13, n7);
            }
            if (n3 <= 128) {
                bl2 ^= true;
            }
            n10 += n9;
        }
    }

    public static PaletteMaker[] getAllPalettes() {
        return paletteMakers;
    }

    public static ValueInterface[] createPaletteValues() {
        PaletteMaker[] paletteMakerArray = SpectralChart.getAllPalettes();
        ValueInterface[] valueInterfaceArray = new ValueInterface[paletteMakerArray.length];
        for (int i = 0; i < paletteMakerArray.length; ++i) {
            valueInterfaceArray[i] = Value.createValue(paletteMakerArray[i].getDescription(), i);
        }
        return valueInterfaceArray;
    }

    private static int blend(int n, int n2, int n3) {
        return (n & 0xFF) + (((n2 & 0xFF) - (n & 0xFF)) * n3 >> 16) | (n >> 8 & 0xFF) + (((n2 >> 8 & 0xFF) - (n >> 8 & 0xFF)) * n3 >> 16) << 8 | (n >> 16 & 0xFF) + (((n2 >> 16 & 0xFF) - (n >> 16 & 0xFF)) * n3 >> 16) << 16 | 0xFF000000;
    }

    private static class PaletteView
    extends JComponent {
        private Palette palette;

        private PaletteView() {
        }

        public void setPalette(Palette palette) {
            this.palette = palette;
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color[] colorArray = this.palette.getColors();
            for (int i = 0; i < n2; ++i) {
                graphics.setColor(colorArray[colorArray.length - 1 - i * colorArray.length / n2]);
                graphics.drawLine(0, i, n, i);
            }
        }
    }

    public static abstract class PaletteMaker {
        private final String description;

        public PaletteMaker(String string) {
            this.description = string;
        }

        public Palette createPalette() {
            return new Palette(this.getPaletteData());
        }

        public String getDescription() {
            return this.description;
        }

        protected abstract int[] getPaletteData();

        protected int[] makeBlendedPalette(int[] nArray, int n) {
            int[] nArray2 = new int[n];
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = i * (nArray.length - 1);
                int n3 = n2 / nArray2.length;
                int n4 = n2 % nArray2.length;
                int n5 = nArray[n3];
                int n6 = nArray[n3 + 1];
                nArray2[i] = SpectralChart.blend(n5, n6, (n4 << 16) / nArray2.length);
            }
            return nArray2;
        }
    }

    public static class Palette {
        private int[] rgb;
        private Color[] colors;

        public Palette(int[] nArray) {
            this.rgb = nArray;
            this.colors = new Color[this.rgb.length];
            for (int i = 0; i < this.rgb.length; ++i) {
                this.colors[i] = new Color(this.rgb[i]);
            }
        }

        public int[] getRGB() {
            return this.rgb;
        }

        public Color[] getColors() {
            return this.colors;
        }
    }
}

