/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SpectralChartPanel
extends JPanel {
    private JPanel scPanel;
    private JPanel rightPanel;
    private JPanel spectrogramTraceChartPanel;
    private JPanel legendPanel;
    private GridLayout scGridLayout;
    private SpectralChart spectralChart;
    private SpectralChart spectralChartBottom;
    private TraceChart traceChart;
    private JComponent traceChartStartLabel;
    private JComponent traceChartStopLabel;
    private ELabel legendMaxLabel;
    private ELabel legendMidLabel;
    private ELabel legendMinLabel;
    private int verticalLegendOffset;
    private ELabel durationLabel;
    private NumberFieldStrategy decibelStrategy = new DecibelStrategy(1, false);

    public SpectralChartPanel(SpectralChart spectralChart, TraceChart traceChart, JComponent jComponent, JComponent jComponent2) {
        this(spectralChart, null, traceChart, jComponent, jComponent2);
    }

    public SpectralChartPanel(SpectralChart spectralChart, SpectralChart spectralChart2, TraceChart traceChart) {
        this(spectralChart, spectralChart2, traceChart, null, null);
    }

    public SpectralChartPanel(SpectralChart spectralChart, SpectralChart spectralChart2, TraceChart traceChart, JComponent jComponent, JComponent jComponent2) {
        super(new BorderLayout(3, 3));
        this.traceChart = traceChart;
        this.traceChartStartLabel = jComponent;
        this.traceChartStopLabel = jComponent2;
        this.verticalLegendOffset = 0;
        this.legendMaxLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 0);
        this.legendMidLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 2);
        this.legendMinLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 1);
        this.setBackground(null);
        this.spectralChart = spectralChart;
        this.spectralChartBottom = spectralChart2;
        this.scGridLayout = new GridLayout(0, 1);
        this.scPanel = new JPanel(this.scGridLayout);
        this.scPanel.setBackground(null);
        this.setViewMode(false);
        Color[] colorArray = TraceAnalyzer.getChartBorder().getBorderColors();
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = colorArray[i].brighter();
        }
        HydroBorderPainterConfig hydroBorderPainterConfig = new HydroBorderPainterConfig(Color.black, 2, colorArray);
        this.spectrogramTraceChartPanel = new JPanel(new BorderLayout());
        this.spectrogramTraceChartPanel.setBackground(null);
        this.legendPanel = this.makeSpectrogramRightPanel();
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.setBackground(null);
        this.rightPanel.add((Component)this.durationLabel, "North");
        this.rightPanel.add((Component)this.legendPanel, "Center");
        this.rightPanel.add((Component)new BorderWrapper(this.spectrogramTraceChartPanel, hydroBorderPainterConfig, false), "South");
        this.add((Component)this.scPanel, "Center");
        this.add((Component)this.rightPanel, "East");
    }

    public void dispose() {
        this.spectralChart.clear();
        this.spectralChart.removeAll();
        this.scPanel.removeAll();
        this.legendPanel.removeAll();
        this.spectrogramTraceChartPanel.removeAll();
        this.rightPanel.removeAll();
        this.removeAll();
        this.spectralChart = null;
        this.scPanel = null;
        this.scGridLayout = null;
        this.legendPanel = null;
        this.spectrogramTraceChartPanel = null;
        this.rightPanel = null;
    }

    private JPanel makeSpectrogramRightPanel() {
        JPanel jPanel;
        this.durationLabel = new ELabel("", Color.white, TraceAnalyzer.VALUE_FONT, 3, 0);
        this.durationLabel.setPreferredSize(new Dimension(40, 50));
        this.traceChart.setPreferredSize(new Dimension(130, 96));
        this.spectrogramTraceChartPanel.add((Component)this.traceChart, "Center");
        if (this.traceChartStartLabel != null && this.traceChartStopLabel != null) {
            jPanel = new JPanel(new GridLayout(1, 0));
            jPanel.setBackground(null);
            jPanel.add(this.traceChartStartLabel);
            jPanel.add(this.traceChartStopLabel);
            this.spectrogramTraceChartPanel.add((Component)jPanel, "South");
        }
        jPanel = new JPanel(new TableLayout(new float[][]{{8.0f, 24.0f, 15.0f, 85.0f, 1.0f}, {6.0f, 42.0f, 42.0f, 42.0f, 6.0f}}));
        jPanel.setBackground(null);
        jPanel.add((Component)this.spectralChart.getPaletteComponent(), "1,1,1,3");
        jPanel.add((Component)this.legendMaxLabel, "3,0,3,1");
        jPanel.add((Component)this.legendMidLabel, "3,2,4,2");
        jPanel.add((Component)this.legendMinLabel, "3,3,3,4");
        jPanel.add((Component)new Glue(8, 2, Color.gray), "2,1,c,t");
        jPanel.add((Component)new Glue(8, 2, Color.gray), "2,2,c,c");
        jPanel.add((Component)new Glue(8, 2, Color.gray), "2,3,c,b");
        return jPanel;
    }

    private void updateSpectrogramDurationLabel() {
        String string;
        long l = this.spectralChart.getVisibleDuration();
        if (l <= 0L) {
            string = "--:--:--";
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            string = simpleDateFormat.format(new Date(l));
        }
        this.durationLabel.setChunk(0, string);
    }

    public void setXStart(long l) {
        this.traceChart.setXStart(l);
    }

    public void setXStop(long l) {
        this.traceChart.setXStop(l);
    }

    public SpectralChart getSpectralChart() {
        return this.spectralChart;
    }

    public TraceChart getTraceChart() {
        return this.traceChart;
    }

    public int getSpectralChartWidth() {
        return this.spectralChart.getWidth();
    }

    public void setVerticalRange(int n, int n2) {
        this.traceChart.setVerticalRange(n, n2);
        this.spectralChart.setMin(n2);
        this.spectralChart.setMax(n);
        if (this.spectralChartBottom != null) {
            this.spectralChartBottom.setMin(n2);
            this.spectralChartBottom.setMax(n);
        }
        this.legendMaxLabel.setChunk(0, this.decibelStrategy.format(n + this.verticalLegendOffset));
        this.legendMidLabel.setChunk(0, this.decibelStrategy.format(n2 + this.verticalLegendOffset + (n - n2) / 2) + "   ");
        this.legendMinLabel.setChunk(0, this.decibelStrategy.format(n2 + this.verticalLegendOffset));
    }

    public void setVerticalLegendOffset(int n, NumberFieldStrategy numberFieldStrategy) {
        this.verticalLegendOffset = n;
        this.decibelStrategy = numberFieldStrategy;
    }

    public void clearSpectrogramHistory() {
        this.clearSpectral(this.spectralChart);
        if (this.spectralChartBottom != null) {
            this.clearSpectral(this.spectralChartBottom);
        }
    }

    private void clearSpectral(SpectralChart spectralChart) {
        spectralChart.clear();
        this.updateSpectrogramDurationLabel();
        spectralChart.repaint();
    }

    public void addTrace(int[] nArray) {
        this.spectralChart.addTrace(nArray);
        this.update();
    }

    public void addTrace(int[] nArray, int[] nArray2, int n) {
        this.spectralChart.addTrace(nArray, nArray2, n);
        this.update();
    }

    public void update() {
        this.updateSpectrogramDurationLabel();
        this.spectralChart.traceUpdated();
        if (this.spectralChartBottom != null) {
            this.spectralChartBottom.traceUpdated();
        }
    }

    public void setViewMode(boolean bl) {
        this.scPanel.removeAll();
        if (bl & this.spectralChartBottom != null) {
            ((GridLayout)this.scPanel.getLayout()).setRows(2);
            this.scPanel.add(this.spectralChart);
            this.scPanel.add(this.spectralChartBottom);
        } else {
            ((GridLayout)this.scPanel.getLayout()).setRows(1);
            this.scPanel.add(this.spectralChart);
        }
    }

    public void addCharts(boolean bl) {
        if (bl) {
            this.spectrogramTraceChartPanel.add((Component)this.traceChart, "Center");
        } else {
            this.spectrogramTraceChartPanel.remove(this.traceChart);
        }
    }
}

