/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

public class SpectralDataHistory {
    private static final int NO_DATA = Integer.MIN_VALUE;
    private int dataHead;
    private int dataCount;
    private int traceLength;
    private final int historySize = 784;
    private static int[] data;
    private static long[] dataTimes;
    private static int[] dataAbs;
    private int oldChannelPwr = 0;

    public SpectralDataHistory(int n) {
        this.traceLength = n;
        if (data == null || data.length < this.traceLength * 784) {
            data = new int[this.traceLength * 784];
            dataAbs = new int[this.traceLength * 784];
            dataTimes = new long[784];
            System.gc();
        }
        this.wipeData();
    }

    public void wipeData() {
        for (int i = 0; i < data.length; ++i) {
            SpectralDataHistory.data[i] = Integer.MIN_VALUE;
            SpectralDataHistory.dataAbs[i] = Integer.MIN_VALUE;
        }
        this.dataCount = 0;
        this.dataHead = 0;
    }

    public int getData(int n, int n2) {
        int n3;
        if (n2 > this.traceLength || this.dataCount == 0) {
            return Integer.MIN_VALUE;
        }
        for (n3 = this.dataHead + n - 1; n3 < 0; n3 += 784) {
        }
        return data[n3 * this.traceLength + n2];
    }

    public int getDataWidth() {
        return this.traceLength;
    }

    public void storeData(int[] nArray) {
        int n = this.dataHead * this.traceLength;
        System.arraycopy(nArray, 0, data, n, this.traceLength);
        SpectralDataHistory.dataTimes[this.dataHead] = System.currentTimeMillis();
        this.dataHead = (this.dataHead + 1) % 784;
        if (this.dataCount < 784) {
            ++this.dataCount;
        }
    }

    public void storeData(int[] nArray, int[] nArray2, int n) {
        int n2 = this.dataHead * this.traceLength;
        if (n == this.oldChannelPwr) {
            System.arraycopy(nArray, 0, data, n2, this.traceLength);
            System.arraycopy(nArray2, 0, dataAbs, n2, this.traceLength);
        } else {
            this.oldChannelPwr = n;
            System.arraycopy(nArray2, 0, dataAbs, n2, this.traceLength);
            int[] nArray3 = new int[this.traceLength * 784];
            for (int i = 0; i < this.dataHead + 1; ++i) {
                for (int j = 0; j < this.traceLength; ++j) {
                    nArray3[i * this.traceLength + j] = dataAbs[i * this.traceLength + j] - this.oldChannelPwr;
                }
            }
            System.arraycopy(nArray3, 0, data, 0, (this.dataHead + 1) * this.traceLength);
        }
        SpectralDataHistory.dataTimes[this.dataHead] = System.currentTimeMillis();
        this.dataHead = (this.dataHead + 1) % 784;
        if (this.dataCount < 784) {
            ++this.dataCount;
        }
    }

    public long getDuration(int n) {
        int n2;
        int n3 = Math.min(this.dataCount, n);
        if (n3 < 2) {
            return 0L;
        }
        int n4 = this.dataHead - 1;
        if (n4 < 0) {
            n4 += 784;
        }
        if ((n2 = n4 - n3 + 1) < 0) {
            n2 += 784;
        }
        return dataTimes[n4] - dataTimes[n2];
    }
}

