/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.BarChart;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public abstract class TopNChart
extends BarChart {
    private static final int TOP_OF_BAR_SPACE = 2;
    protected NumberFieldStrategy dbStrategy = new DecibelStrategy(0);
    private final Resources topNRes = Resources.getResources("elgato.gui.topn");
    private int bottomRangeForChart = -30000;
    private static final int topRangeForChart = 0;
    private boolean bValidReference = true;

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        super.setMeasurement(traceMeasurement);
        this.setDrawXAxisLabels(false);
        this.setDrawYAxisLabels(false);
        this.setVerticalRange(0, this.bottomRangeForChart);
    }

    protected Font getXAxisFont() {
        return new Font("SansSerif", 0, 12);
    }

    protected int getXAxisRows() {
        return 2;
    }

    protected int getSlotCount() {
        return 3;
    }

    protected int getSlotSpacing() {
        return 6;
    }

    protected int getUnitBarWidth() {
        return super.getUnitBarWidth();
    }

    protected void setBottomRangeForChart(int n) {
        this.bottomRangeForChart = n;
    }

    public void setVerticalRange(int n, int n2) {
        super.setVerticalRange(0, this.bottomRangeForChart);
    }

    public void setValidReference(boolean bl) {
        this.bValidReference = bl;
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.bValidReference) {
            int[] nArray = this.getTopNPilotsValues();
            int[] nArray2 = this.getTopPnOffsets();
            int n5 = nArray.length;
            int n6 = this.getYTop();
            int n7 = this.getYBottom() - n6;
            if (n4 == 0 || n7 == 0) {
                return;
            }
            graphics.setFont(this.topNRes.getFont("label.smallfont"));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n8 = this.getUnitBarWidth();
            int n9 = this.getBarTopLabelInset();
            int n10 = n;
            for (int i = 0; i < n5; ++i) {
                int n11 = (nArray[i] - n6) * n4 / n7;
                graphics.setColor(Color.red);
                graphics.fillRect(n10, n2 + n11, n8, n4 - n11);
                String[] stringArray = new String[2];
                this.dbStrategy.formatWithUnits(nArray[i], stringArray);
                int n12 = n2 + n11 - 2;
                graphics.setColor(Color.cyan);
                TraceChart.drawCenteredStringsBottomJustified(graphics, n10, n12, n8, stringArray, n2 - n9, n2 + n4);
                if (nArray2[i] != -1) {
                    String string = Integer.toString(nArray2[i]);
                    int n13 = i % this.getXAxisRows() + 1;
                    int n14 = n10 + (n8 - fontMetrics.stringWidth(string)) / 2;
                    int n15 = n2 + n4 + fontMetrics.getAscent() * n13 + 1;
                    int n16 = n10 + (n8 >> 1);
                    graphics.drawLine(n16, n2 + n4 + 1, n16, n15 - fontMetrics.getAscent());
                    graphics.setColor(Color.yellow);
                    graphics.drawString(string, n14, n15);
                }
                n10 += n8 + this.getSlotSpacing();
            }
        } else {
            graphics.setFont(this.topNRes.getFont("label.warningfont"));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n17 = n2 + n4 + fontMetrics.getAscent();
            graphics.setColor(Color.red);
            graphics.drawString(Text.Set_Fr_slash_Time_Ref_to_GPS_or_ESC_to_perform_measurement, n, n17);
        }
    }

    protected void getChartInsets(Insets insets) {
        super.getChartInsets(insets);
        insets.top = this.getBarTopLabelInset();
    }

    private int getBarTopLabelInset() {
        FontMetrics fontMetrics = BarChart.getFontMetricsForFont(this.getXAxisFont());
        return fontMetrics.getHeight() + fontMetrics.getAscent();
    }

    public abstract int[] getTopNPilotsValues();

    public abstract int[] getTopPnOffsets();
}

