/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.analyzer.TopNChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

public abstract class TopNPanel
extends JPanel {
    private static final DecibelStrategy dbStrategy0 = new DecibelStrategy(0, false);

    public TopNPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer, boolean bl) {
        if (bl) {
            this.createVerticalPanel(topNChart, traceAnalyzer);
        } else {
            this.createHorizontalPanel(topNChart, traceAnalyzer);
        }
    }

    public TopNPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer) {
        this.createVerticalPanel(topNChart, traceAnalyzer);
    }

    private void createVerticalPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer) {
        final Resources resources = Resources.getResources("elgato.gui.topn");
        TableLayout tableLayout = new TableLayout(new float[][]{{-1.0f, 16.0f}, new float[0]});
        this.setLayout(tableLayout);
        int n = -1;
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)new ELabel(Text.Pilot, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 0, n));
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)new ELabel(Text.Dominance, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)traceAnalyzer.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                if (TopNPanel.this.isPilotDominanceAboveLimit(measurement)) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                if (TopNPanel.this.getPilotDominance(measurement) == -1) {
                    return "< 0";
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(1, false);
                String[] stringArray = decibelStrategy.formatWithUnits(TopNPanel.this.getPilotDominance(measurement), new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(0, n));
        this.add((Component)traceAnalyzer.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + dbStrategy0.getUnitString();
            }
        }), TableLayoutConstraints.newCell(1, n));
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)new ELabel(Text.Multipath, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)new ELabel(Text.Power, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, -2.0f);
        this.add((Component)traceAnalyzer.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                boolean bl = TopNPanel.this.isMultipathPowerBelowLimit(measurement);
                if (bl) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(2, false);
                String[] stringArray = decibelStrategy.formatWithUnits(TopNPanel.this.getMultipathPower(measurement), new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(0, n));
        this.add((Component)traceAnalyzer.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + dbStrategy0.getUnitString();
            }
        }), TableLayoutConstraints.newCell(1, n));
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, -1.0f);
        this.add((Component)topNChart, TableLayoutConstraints.newSpan(0, n, 0, n));
    }

    private void createHorizontalPanel(TopNChart topNChart, TraceAnalyzer traceAnalyzer) {
        final Resources resources = Resources.getResources("elgato.gui.topn");
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        TableLayout tableLayout = new TableLayout(new float[][]{{-1.0f, 16.0f}, new float[0]});
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.setPreferredSize(new Dimension(120, 85));
        jPanel.setBackground(new Color(85, 85, 85));
        int n = -1;
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)new ELabel(Text.OTA_PN_Scanner, resources.getColor("label.color"), resources.getFont("value.font"), 3, 0), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)new ELabel(Text.Pilot_Dominance, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)traceAnalyzer.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                int n = TopNPanel.this.getPilotDominance(measurement);
                if (n == Integer.MAX_VALUE) {
                    this.setAttributes(resources.getColor("label.color"), resources.getFont("value.font"));
                    String[] stringArray = new String[]{"-----", ""};
                    return stringArray[0];
                }
                if (TopNPanel.this.isPilotDominanceAboveLimit(measurement)) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                if (TopNPanel.this.getPilotDominance(measurement) == -1) {
                    return "< 0";
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(1, false);
                String[] stringArray = decibelStrategy.formatWithUnits(n, new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(0, n));
        jPanel.add((Component)traceAnalyzer.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + dbStrategy0.getUnitString();
            }
        }), TableLayoutConstraints.newCell(1, n));
        tableLayout.insertRow(++n, 5.0f);
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)new ELabel(Text.Multipath_Power, resources.getColor("label.color"), resources.getFont("label.font"), 2, 2), TableLayoutConstraints.newSpan(0, n, 1, n));
        tableLayout.insertRow(++n, -2.0f);
        jPanel.add((Component)traceAnalyzer.addLabel(new DynamicLabel(4, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                int n = TopNPanel.this.getMultipathPower(measurement);
                if (n == Integer.MAX_VALUE) {
                    this.setAttributes(resources.getColor("label.color"), resources.getFont("value.font"));
                    String[] stringArray = new String[]{"-----", ""};
                    return stringArray[0];
                }
                boolean bl = TopNPanel.this.isMultipathPowerBelowLimit(measurement);
                if (bl) {
                    this.setAttributes(resources.getColor("value.color.pass"), resources.getFont("value.font"));
                } else {
                    this.setAttributes(resources.getColor("value.color.fail"), resources.getFont("value.font"));
                }
                DecibelStrategy decibelStrategy = new DecibelStrategy(2, false);
                String[] stringArray = decibelStrategy.formatWithUnits(n, new String[2]);
                return stringArray[0];
            }
        }), TableLayoutConstraints.newCell(0, n));
        jPanel.add((Component)traceAnalyzer.addLabel(new DynamicLabel(3, resources.getColor("label.color"), resources.getFont("value.font")){

            protected String formatValue(Measurement measurement) {
                return " " + dbStrategy0.getUnitString();
            }
        }), TableLayoutConstraints.newCell(1, n));
        tableLayout.insertColumn(2, 38.0f);
        this.add((Component)topNChart, "Center");
        this.add((Component)jPanel, "West");
    }

    public ELabel addAnalyzerLabel(TraceAnalyzer traceAnalyzer, ELabel eLabel) {
        return traceAnalyzer.addLabel(eLabel);
    }

    public abstract int getPilotDominance(Measurement var1);

    public abstract boolean isPilotDominanceAboveLimit(Measurement var1);

    public abstract int getMultipathPower(Measurement var1);

    public abstract boolean isMultipathPowerBelowLimit(Measurement var1);
}

