/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.SaveData;
import elgato.infrastructure.mainScreens.Saveable;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.marker.MarkerListener;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.GrayScaleColorFlipFilter;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class TraceAnalyzer
extends JPanel
implements Analyzer,
MeasurementListener,
ValueListener,
MarkerListener,
Saveable {
    protected static final Resources traceAnalyzerRes = Resources.getResources((class$elgato$infrastructure$analyzer$TraceAnalyzer == null ? (class$elgato$infrastructure$analyzer$TraceAnalyzer = TraceAnalyzer.class$("elgato.infrastructure.analyzer.TraceAnalyzer")) : class$elgato$infrastructure$analyzer$TraceAnalyzer).getName());
    public static final Font VALUE_FONT = traceAnalyzerRes.getFont("value.font");
    public static final Color VALUE_COLOR = traceAnalyzerRes.getColor("value.color");
    protected static final NumberFieldStrategy freqStrategy = new FrequencyStrategy();
    protected static final DecibelStrategy refLevelStrategy = new DecibelStrategy(1);
    private static final String PROGRESS = "progress";
    private static final String ANALYZER = "analyzer";
    protected String debugMessage = "";
    private Vector labels = new Vector();
    private CardLayout cardLayout;
    private boolean analyzerAddedToCardLayout = false;
    private DefaultProgressIndicator progressIndicator = new DefaultProgressIndicator(Text.MEASUREMENT_LOADING);
    private MarkerButtonFactory markerButtonFactory;
    private Vector actuatorsListenedTo = new Vector();
    protected final String listenerBaseName;
    static /* synthetic */ Class class$elgato$infrastructure$analyzer$TraceAnalyzer;

    protected TraceAnalyzer(String string) {
        this.listenerBaseName = string;
        this.debugMessage = this.getClass().getName() + ".measurementReceived";
        this.setBackground(null);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)this.progressIndicator, PROGRESS);
        this.progressIndicator.start();
        this.cardLayout.show(this, PROGRESS);
    }

    protected void listenToActuator(Actuator actuator) {
        this.actuatorsListenedTo.addElement(actuator);
        actuator.addValueListener(this);
    }

    public void saveData(PrintWriter printWriter) {
        SaveData.saveData(this.createReadingFields(), printWriter, this.getMeasurement().getMeasurementTitle() + " Data");
    }

    public void dispose() {
        this.ensureProgressTimerStopped();
        for (int i = 0; i < this.actuatorsListenedTo.size(); ++i) {
            Actuator actuator = (Actuator)this.actuatorsListenedTo.elementAt(i);
            actuator.removeValueListener(this);
        }
        this.actuatorsListenedTo.removeAllElements();
        if (this.markerButtonFactory != null) {
            Marker[] markerArray = this.markerButtonFactory.getMarkers();
            for (int i = 0; i < markerArray.length; ++i) {
                markerArray[i].removeMarkerListener(this);
            }
            this.markerButtonFactory.dispose();
            this.markerButtonFactory = null;
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            this.labels.removeAllElements();
        }
        this.progressIndicator.removeAllListeners();
        this.remove(this.progressIndicator);
        if (this.cardLayout != null) {
            this.cardLayout.removeLayoutComponent(this);
            this.cardLayout = null;
        }
    }

    private void ensureProgressTimerStopped() {
        this.progressIndicator.stop();
    }

    public String getListenerBaseName() {
        return this.listenerBaseName;
    }

    public String getMarkerListenerBaseName() {
        return this.getListenerBaseName();
    }

    public int[] getTraceMinMax() {
        if (this.getMeasurement() == null) {
            return null;
        }
        return this.getTraceMeasurement().getTraceMinMax();
    }

    public TraceMeasurement getTraceMeasurement() {
        return (TraceMeasurement)this.getMeasurement();
    }

    public String getListenerName() {
        return this.listenerBaseName + ".updateListener";
    }

    public void valueChanged(ValueInterface valueInterface) {
        EventDispatchThread.runOnEventThread("TraceAnalyzer.valueChange", new Runnable(){

            public void run() {
                TraceAnalyzer.this.updateChartVerticalRange();
                TraceAnalyzer.this.updateLabels();
                TraceAnalyzer.this.repaint();
            }
        });
    }

    private void maybeSwitchOffProgressIndicator() {
        if (!this.analyzerAddedToCardLayout && this.getMeasurement() != null) {
            this.ensureProgressTimerStopped();
            this.setBackground(this.getDataBackgroundColor());
            this.add(this.getPane(), ANALYZER);
            if (this.cardLayout != null) {
                this.cardLayout.show(this, ANALYZER);
            }
            this.analyzerAddedToCardLayout = true;
        }
    }

    protected Color getDataBackgroundColor() {
        return Color.black;
    }

    protected ELabel addLabel(ELabel eLabel) {
        this.labels.addElement(eLabel);
        return eLabel;
    }

    protected void updateLabels() {
        Measurement measurement = this.getMeasurement();
        if (measurement != null) {
            DynamicLabel.updateLabelsForMeasurement(this.labels, measurement);
            if (!this.shouldMeasurementReceivedAutomaticallyPaintEverything()) {
                for (int i = 0; i < this.labels.size(); ++i) {
                    ELabel eLabel = (ELabel)this.labels.elementAt(i);
                    eLabel.repaint();
                }
            }
        }
    }

    protected void placeComponent(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public void measurementReceived(Measurement measurement) {
        final TraceMeasurement traceMeasurement = (TraceMeasurement)measurement;
        Runnable runnable = new Runnable(){

            public void run() {
                TraceAnalyzer.this.setMeasurement(traceMeasurement);
                TraceAnalyzer.this.updateMarkerMeasurement(traceMeasurement);
                TraceAnalyzer.this.updateChartMarkers();
                TraceAnalyzer.this.updateChartMeasurements();
                TraceAnalyzer.this.updateLabels();
                TraceAnalyzer.this.maybeSwitchOffProgressIndicator();
                TraceAnalyzer.this.updateMetrics(traceMeasurement);
                if (TraceAnalyzer.this.shouldMeasurementReceivedAutomaticallyPaintEverything()) {
                    TraceAnalyzer.this.paintImmediately(0, 0, TraceAnalyzer.this.getWidth(), TraceAnalyzer.this.getHeight());
                }
            }
        };
        EventDispatchThread.invokeLater(runnable, this.debugMessage);
    }

    protected boolean shouldMeasurementReceivedAutomaticallyPaintEverything() {
        return true;
    }

    private void updateMarkerMeasurement(TraceMeasurement traceMeasurement) {
        if (this.markerButtonFactory != null) {
            this.markerButtonFactory.setMeasurement(traceMeasurement);
        }
    }

    protected void updateChartMarkers() {
        if (this.markerButtonFactory != null) {
            this.doUpdateChartMarkers();
        }
    }

    protected void doUpdateChartMarkers() {
        TraceChart[] traceChartArray = this.getCharts();
        for (int i = 0; i < traceChartArray.length; ++i) {
            this.setMarkersOnChart(traceChartArray[i]);
        }
    }

    private void setMarkersOnChart(TraceChart traceChart) {
        traceChart.setMarkers(this.markerButtonFactory.getMarkers());
    }

    protected void updateChartMeasurements() {
        TraceChart[] traceChartArray = this.getCharts();
        TraceMeasurement traceMeasurement = this.getTraceMeasurement();
        if (traceChartArray != null && traceMeasurement != null) {
            for (int i = 0; i < traceChartArray.length; ++i) {
                traceChartArray[i].setMeasurement(traceMeasurement);
            }
        }
    }

    public abstract MeasurementMetrics getMeasurementMetrics();

    private void updateMetrics(Measurement measurement) {
        MeasurementMetrics measurementMetrics = this.getMeasurementMetrics();
        if (measurementMetrics != null) {
            measurementMetrics.setMeasurement(measurement);
        }
    }

    public abstract void updateChartVerticalRange();

    public abstract Measurement getMeasurement();

    protected abstract void setMeasurement(Measurement var1);

    protected abstract Component getPane();

    protected abstract TraceChart getChart();

    protected abstract TraceChart[] getCharts();

    public long getViewStartValue() {
        return this.getTraceStartValue();
    }

    public long getViewStopValue() {
        return this.getTraceStopValue();
    }

    public long getViewStartValue(long l) {
        return this.getTraceStartValue(l);
    }

    public long getViewStopValue(long l) {
        return this.getTraceStopValue(l);
    }

    public long getTraceStartValue() {
        return this.getTraceMeasurement().getTraceStartValue();
    }

    public long getTraceStopValue() {
        return this.getTraceMeasurement().getTraceStopValue();
    }

    public long getTraceStartValue(long l) {
        return this.getTraceMeasurement().getTraceStartValue(l);
    }

    public long getTraceStopValue(long l) {
        return this.getTraceMeasurement().getTraceStopValue(l);
    }

    public long getPvtRiseStopValue() {
        return this.getTraceMeasurement().getPvtRiseStopValue();
    }

    public long getPvtFallStartValue() {
        return this.getTraceMeasurement().getPvtFallStartValue();
    }

    public String getCurrentMarkerDescription() {
        if (this.markerButtonFactory != null) {
            return this.markerButtonFactory.getCurrentMarker().getDescription();
        }
        return "";
    }

    public void markerUpdated() {
        this.updateLabels();
        this.repaint();
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }

    public void setMarkerButtonFactory(MarkerButtonFactory markerButtonFactory) {
        int n;
        Marker[] markerArray;
        if (this.markerButtonFactory != null) {
            markerArray = this.markerButtonFactory.getMarkers();
            for (n = 0; n < markerArray.length; ++n) {
                markerArray[n].removeMarkerListener(this);
            }
        }
        this.markerButtonFactory = null;
        if (markerButtonFactory != null) {
            markerArray = markerButtonFactory.getMarkers();
            for (n = 0; n < markerArray.length; ++n) {
                markerArray[n].addMarkerListener(this);
            }
            this.markerButtonFactory = markerButtonFactory;
        }
    }

    protected DynamicLabel makeStopFrequencyLabel() {
        return new DynamicLabel("stopFrequency", 4, VALUE_COLOR, VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                TraceChart traceChart = TraceAnalyzer.this.getChart();
                if (traceChart.getMeasurement() != measurement) {
                    traceChart.setMeasurement((TraceMeasurement)measurement);
                }
                return freqStrategy.format(traceChart.getXStop());
            }
        };
    }

    protected DynamicLabel makeStartFrequencyLabel() {
        return new DynamicLabel("startFrequency", 3, VALUE_COLOR, VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                TraceChart traceChart = TraceAnalyzer.this.getChart();
                if (traceChart.getMeasurement() != measurement) {
                    traceChart.setMeasurement((TraceMeasurement)measurement);
                }
                return freqStrategy.format(traceChart.getXStart());
            }
        };
    }

    protected DynamicLabel makeCenterFrequencyLabel() {
        return new DynamicLabel("centerFrequency", 2, VALUE_COLOR, VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                TraceChart traceChart = TraceAnalyzer.this.getChart();
                if (traceChart.getMeasurement() != measurement) {
                    traceChart.setMeasurement((TraceMeasurement)measurement);
                }
                return Text.Center + " " + freqStrategy.format((traceChart.getXStop() + traceChart.getXStart()) / 2L);
            }
        };
    }

    protected Dimension getWideWidthForYAxisLabel() {
        return new Dimension(52, 22);
    }

    public float convertPowerToFloat(int n) {
        int n2 = n >= 0 ? 50 : -50;
        int n3 = n + n2;
        float f = (float)(n3 /= 100) / 10.0f;
        return f;
    }

    public abstract TabDelimitable[] createReadingFields();

    public static HydroBorderPainterConfig getChartBorder() {
        return traceAnalyzerRes.getBorderConfig("chartBorder");
    }

    public abstract NumberFieldStrategy getYAxisNormalStrategy();

    public abstract NumberFieldStrategy getYAxisDeltaStrategy();

    public abstract NumberFieldStrategy getXAxisStrategy();

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        GrayScaleColorFlipFilter grayScaleColorFlipFilter = new GrayScaleColorFlipFilter(rectangle, true, true);
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), grayScaleColorFlipFilter));
    }

    public boolean isSplitTraceView() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class RangeControlDynamicLabel
    extends DynamicLabel {
        private final int rangeHoldReadingId;
        private final int rangeSettingReadingId;

        public RangeControlDynamicLabel(int n, int n2) {
            super("average", 3, VALUE_COLOR, VALUE_FONT);
            this.rangeHoldReadingId = n;
            this.rangeSettingReadingId = n2;
        }

        protected String formatValue(Measurement measurement) {
            switch (measurement.getIntegerReadingValue(this.rangeHoldReadingId)) {
                case 1: {
                    return Text.Range + "(" + Text.Hold + ") " + UIHelper.formatFixed(measurement.getIntegerReadingValue(this.rangeSettingReadingId), 1) + " dBm";
                }
                case 2: {
                    return Text.Range + "(" + Text.Max + ") " + UIHelper.formatFixed(measurement.getIntegerReadingValue(this.rangeSettingReadingId), 1) + " dBm";
                }
            }
            return "";
        }
    }

    protected static class AverageDynamicLabel
    extends DynamicLabel {
        private final int averageTypeReadingId;
        private final int numAveragesReadingId;
        private final int averageCountId;

        public AverageDynamicLabel(int n, int n2, int n3) {
            super("average", 4, VALUE_COLOR, VALUE_FONT);
            this.averageTypeReadingId = n;
            this.numAveragesReadingId = n2;
            this.averageCountId = n3;
        }

        protected String formatValue(Measurement measurement) {
            switch (measurement.getIntegerReadingValue(this.averageTypeReadingId)) {
                default: {
                    return "";
                }
                case 1: {
                    return Text.Running_Average + " (" + measurement.getIntegerReadingValue(this.averageCountId) + "/" + measurement.getIntegerReadingValue(this.numAveragesReadingId) + ")";
                }
                case 2: {
                    return Text.Max_Hold;
                }
                case 3: {
                    return Text.Group_Average + " (" + measurement.getIntegerReadingValue(this.averageCountId) + "/" + measurement.getIntegerReadingValue(this.numAveragesReadingId) + ")";
                }
                case 4: 
            }
            return Text.Group_Max_Average + " (" + measurement.getIntegerReadingValue(this.averageCountId) + "/" + measurement.getIntegerReadingValue(this.numAveragesReadingId) + ")";
        }
    }
}

