/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.analyzer;

import elgato.infrastructure.mainScreens.FrameRateMonitor;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Conversion;
import elgato.infrastructure.util.Conversions;
import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class TraceChart
extends JComponent {
    private static final boolean SHOWFPS = "true".equals(System.getProperty("showfps"));
    protected static final int GRID_BORDER_WIDTH = 1;
    public static final int DEFAULT_HORIZONTAL_GRID_DIVISIONS = 10;
    private static final int SPACE_ABOVE_XAXIS_LABELS = 2;
    protected final Font axisLabelFont = new Font("SansSerif", 0, 9);
    protected TraceMeasurement measurement;
    private FrameRateMonitor fpsMonitor;
    private Vector dynamicLabels = new Vector();
    private int yTop;
    private int yBottom;
    private boolean manualXRange;
    private long xStart;
    private long xStop;
    private boolean drawGridX;
    private boolean drawGridY;
    protected boolean drawXAxisLabels;
    protected boolean drawYAxisLabels;
    protected static boolean invert = false;
    private NumberFieldStrategy xAxisStrategy;
    private NumberFieldStrategy yAxisStrategy;
    private Conversion xAxisConversion = Conversions.identity();
    private String widestYAxisString = "-999.9";
    protected Color gridColor;
    protected Insets insets;
    private Marker[] markers;
    private static final int Y_AXIS_LABEL_PADDING = 2;
    public static final Image passImage = ImageIcon.loadImage("images/LimitsMaskGreen_P.png", new Canvas());
    protected static final Image failImage = ImageIcon.loadImage("images/LimitsMaskRed_F.png", new Canvas());
    private GridType xGridType = new EvenXDivisions(10);
    private GridType yGridType = new EvenYDivisions(10);

    protected TraceChart() {
        this.setBackground(Color.black);
        if (SHOWFPS) {
            this.fpsMonitor = new FrameRateMonitor();
        }
    }

    public void dispose() {
        if (this.dynamicLabels != null) {
            if (!this.dynamicLabels.isEmpty()) {
                this.dynamicLabels.removeAllElements();
            }
            this.dynamicLabels = null;
        }
        if (this.markers != null) {
            for (int i = 0; i < this.markers.length; ++i) {
                this.markers[i] = null;
            }
            this.markers = null;
        }
        this.xGridType = null;
        this.yGridType = null;
        this.measurement = null;
    }

    public void addDLabel(DynamicLabel dynamicLabel, int n, int n2) {
        ChartLabel chartLabel = new ChartLabel();
        chartLabel.setdLabel(dynamicLabel);
        chartLabel.setxPos(n);
        chartLabel.setyPos(n2);
        this.dynamicLabels.addElement(chartLabel);
    }

    public int dynamicLabelCount() {
        return this.dynamicLabels.size();
    }

    public void setVerticalRange(int n, int n2) {
        this.yTop = n;
        this.yBottom = n2;
    }

    protected int getYTop() {
        return this.yTop;
    }

    protected int getYBottom() {
        return this.yBottom;
    }

    public boolean isManualXRange() {
        return this.manualXRange;
    }

    public void setManualXRange(boolean bl) {
        this.manualXRange = bl;
    }

    public void setXStart(long l) {
        this.xStart = l;
    }

    public void setXStop(long l) {
        this.xStop = l;
    }

    public long getXStart() {
        return this.manualXRange ? this.xStart : this.measurement.getTraceStartValue();
    }

    public long getXStop() {
        return this.manualXRange ? this.xStop : this.measurement.getTraceStopValue();
    }

    public long getConvertedXStart() {
        return this.xAxisConversion.convert(this.getXStart());
    }

    public long getConvertedXStop() {
        return this.xAxisConversion.convert(this.getXStop());
    }

    protected int getXStartTraceIndex() {
        return this.indexOfValueInTrace(this.getXStart());
    }

    protected int getXStopTraceIndex() {
        return this.indexOfValueInTrace(this.getXStop());
    }

    private int indexOfValueInTrace(long l) {
        return (int)((l - this.measurement.getTraceStartValue()) * (long)(this.measurement.getTraceLength() - 1) / (this.measurement.getTraceStopValue() - this.measurement.getTraceStartValue()));
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        this.measurement = traceMeasurement;
        DynamicLabel.updateLabelsForMeasurement(this.extractDynamicLabelsFromChartLabels(), traceMeasurement);
    }

    private Vector extractDynamicLabelsFromChartLabels() {
        Vector<DynamicLabel> vector = new Vector<DynamicLabel>();
        for (int i = 0; i < this.dynamicLabels.size(); ++i) {
            ChartLabel chartLabel = (ChartLabel)this.dynamicLabels.elementAt(i);
            vector.addElement(chartLabel.getdLabel());
        }
        return vector;
    }

    protected TraceMeasurement getMeasurement() {
        return this.measurement;
    }

    public final void paintComponent(Graphics graphics) {
        this.draw(graphics, this.getWidth(), this.getHeight());
    }

    private void draw(Graphics graphics, int n, int n2) {
        this.drawChart(graphics, 0, 0, n, n2);
        if (SHOWFPS) {
            this.fpsMonitor.paint(graphics, 10, 32);
        }
        for (int i = 0; i < this.dynamicLabels.size(); ++i) {
            ChartLabel chartLabel = (ChartLabel)this.dynamicLabels.elementAt(i);
            int n3 = chartLabel.getxPos();
            int n4 = chartLabel.getyPos();
            n3 = n3 < 0 ? n + n3 - 1 : ++n3;
            n4 = n4 < 0 ? n2 + n4 - 1 : ++n4;
            graphics.translate(n3, n4);
            chartLabel.getdLabel().paintComponent(graphics);
            graphics.translate(-n3, -n4);
        }
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
    }

    protected void drawChart(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!this.isChartDrawable()) {
            return;
        }
        this.checkInsets();
        int n5 = this.getGridTopMargin();
        int n6 = this.getGridBottomMargin();
        int n7 = this.getGridLeftMargin();
        int n8 = this.getGridRightMargin();
        int n9 = n + n7 + this.insets.left;
        int n10 = n2 + n5 + this.insets.top;
        int n11 = n3 - this.insets.left - this.insets.right - n7 - n8;
        int n12 = n4 - this.insets.top - this.insets.bottom - n5 - n6;
        this.drawGrid(graphics, n9, n10, n11, n12);
        if (this.measurement != null) {
            int n13 = n9 + 1;
            int n14 = n10 + 1;
            int n15 = n11 - 2;
            int n16 = n12 - 2;
            this.drawTrace(graphics, n13, n14, n15, n16);
            this.showLimits(graphics, n3, n4);
        }
    }

    protected boolean isChartDrawable() {
        return true;
    }

    public Insets getInsets() {
        this.checkInsets();
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    public boolean isDrawGridY() {
        return this.drawGridY;
    }

    public void setDrawGridY(boolean bl) {
        this.drawGridY = bl;
    }

    public boolean isDrawGridX() {
        return this.drawGridX;
    }

    public void setDrawGridX(boolean bl) {
        this.drawGridX = bl;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public boolean isDrawXAxisLabels() {
        return this.drawXAxisLabels;
    }

    public void setDrawXAxisLabels(boolean bl) {
        this.drawXAxisLabels = bl;
    }

    public boolean isDrawYAxisLabels() {
        return this.drawYAxisLabels;
    }

    public void setDrawYAxisLabels(boolean bl) {
        this.drawYAxisLabels = bl;
    }

    public void setWidestYAxisString(String string) {
        this.widestYAxisString = string;
    }

    protected Dimension getTraceCanvasSize() {
        Dimension dimension = this.getSize();
        dimension.width -= this.getGridLeftMargin() + this.getGridRightMargin() + 2;
        dimension.height -= this.getGridTopMargin() + this.getGridBottomMargin() + 2;
        return dimension;
    }

    protected int getGridLeftMargin() {
        int n = 0;
        if (this.drawYAxisLabels) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.axisLabelFont);
            n += fontMetrics.stringWidth(this.widestYAxisString) + 2;
        }
        return n;
    }

    protected int getGridRightMargin() {
        if (this.drawXAxisLabels) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.axisLabelFont);
            String[] stringArray = new String[2];
            this.xAxisStrategy.formatWithUnits(this.xAxisConversion.convert(this.getXStop()), stringArray);
            return fontMetrics.stringWidth(stringArray[0]) / 2;
        }
        return 0;
    }

    protected int getGridTopMargin() {
        int n = 0;
        if (this.drawYAxisLabels) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.axisLabelFont);
            n += fontMetrics.getAscent() / 2 + fontMetrics.getAscent();
        }
        return n;
    }

    protected int getGridBottomMargin() {
        int n = 0;
        if (this.drawYAxisLabels || this.drawXAxisLabels) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.axisLabelFont);
            if (this.drawYAxisLabels) {
                n = fontMetrics.getAscent() / 2;
            }
            if (this.drawXAxisLabels) {
                n = Math.max(fontMetrics.getHeight() + 2, n);
            }
        }
        return n;
    }

    protected void drawGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        String string;
        int n6;
        GridLine gridLine;
        Enumeration enumeration;
        String string2;
        boolean bl;
        graphics.setColor(this.gridColor);
        graphics.drawRect(n, n2, --n3, --n4);
        int n7 = n + n3;
        int n8 = n2 + n4;
        graphics.setFont(this.axisLabelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String[] stringArray = new String[2];
        if (this.drawGridY) {
            bl = true;
            string2 = "";
            enumeration = this.yGridType.gridLines(new Dimension(n3, n4));
            while (enumeration.hasMoreElements()) {
                gridLine = (GridLine)enumeration.nextElement();
                n6 = n2 + gridLine.pixel;
                if (gridLine.pixel > 0 && gridLine.pixel < n4 - 1) {
                    graphics.setColor(this.gridColor);
                    graphics.drawLine(n, n6, n7, n6);
                }
                if (this.drawYAxisLabels) {
                    this.yAxisStrategy.formatWithUnits(gridLine.value, stringArray);
                    string = stringArray[0];
                    if (!string.equals(string2)) {
                        string2 = string;
                        graphics.setColor(Color.white);
                        n5 = n6 + fontMetrics.getAscent() / 2;
                        if (bl) {
                            String string3 = stringArray[1];
                            graphics.drawString(string3, n - fontMetrics.stringWidth(string3) - 2, n5 - fontMetrics.getAscent());
                        }
                        if (invert) {
                            graphics.drawString(String.valueOf(Double.valueOf(string) * -1.0), n - fontMetrics.stringWidth(string) - 2, n5);
                        } else {
                            graphics.drawString(string, n - fontMetrics.stringWidth(string) - 2, n5);
                        }
                    }
                }
                bl = false;
            }
        }
        if (this.drawGridX) {
            bl = true;
            string2 = "";
            enumeration = this.xGridType.gridLines(new Dimension(n3, n4));
            while (enumeration.hasMoreElements()) {
                gridLine = (GridLine)enumeration.nextElement();
                n6 = n + gridLine.pixel;
                if (gridLine.pixel > 0 && gridLine.pixel < n3 - 1) {
                    graphics.setColor(this.gridColor);
                    graphics.drawLine(n6, n2, n6, n8);
                }
                if (this.drawXAxisLabels) {
                    this.xAxisStrategy.formatWithUnits(gridLine.value, stringArray);
                    string = stringArray[0];
                    if (!string.equals(string2)) {
                        string2 = string;
                        graphics.setColor(Color.white);
                        n5 = fontMetrics.stringWidth(string);
                        if (bl) {
                            string = string + " " + stringArray[1];
                        }
                        int n9 = n5 / 2;
                        graphics.drawString(string, n6 - n9, n8 + fontMetrics.getHeight() + 2);
                    }
                }
                bl = false;
            }
        }
    }

    public void setXGridType(GridType gridType) {
        this.xGridType = gridType;
    }

    public void setYGridType(GridType gridType) {
        this.yGridType = gridType;
    }

    public GridLine newXGridLineByValue(long l, int n) {
        long l2 = this.getConvertedXStart();
        long l3 = this.getConvertedXStop();
        int n2 = (int)((l - l2) * (long)(n - 1) / (l3 - l2));
        return new GridLine(l, n2);
    }

    public void setyAxisStrategy(NumberFieldStrategy numberFieldStrategy) {
        this.yAxisStrategy = numberFieldStrategy;
    }

    public void setxAxisStrategy(NumberFieldStrategy numberFieldStrategy) {
        this.xAxisStrategy = numberFieldStrategy;
    }

    public void setxAxisConversion(Conversion conversion) {
        this.xAxisConversion = conversion;
    }

    protected abstract void drawTrace(Graphics var1, int var2, int var3, int var4, int var5);

    protected void getChartInsets(Insets insets) {
    }

    protected void checkInsets() {
        this.insets = new Insets(0, 0, 0, 0);
        this.getChartInsets(this.insets);
    }

    public Marker[] getMarkers() {
        return this.markers;
    }

    public void setMarkers(Marker[] markerArray) {
        this.markers = markerArray;
    }

    protected static void drawCenteredStringsBottomJustified(Graphics graphics, int n, int n2, int n3, String[] stringArray, int n4, int n5) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = fontMetrics.getHeight() * stringArray.length;
        int n7 = n2 - fontMetrics.getHeight() * stringArray.length;
        if (n7 < n4) {
            n7 = n4;
        } else if (n2 > n5) {
            n7 = n5 - n6;
        }
        TraceChart.drawCenteredStrings(graphics, n, n7, n3, stringArray);
    }

    protected static void drawCenteredStrings(Graphics graphics, int n, int n2, int n3, String[] stringArray) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n2 += fontMetrics.getAscent();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n4 = n + (n3 - fontMetrics.stringWidth(string)) / 2;
            graphics.drawString(string, n4, n2);
            n2 += fontMetrics.getHeight();
        }
    }

    public Vector getDynamicLabels() {
        return this.dynamicLabels;
    }

    protected void drawThresholdLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n < this.getYBottom()) {
            return;
        }
        int n6 = this.getYBottom() - this.getYTop();
        int n7 = n3 + (n - this.getYTop()) * n5 / n6;
        graphics.setColor(Color.red);
        graphics.drawLine(n2, n7, n2 + n4 - 1, n7);
    }

    public static int plotPointValue(long l, long l2, long l3, int n) {
        return (int)(TraceChart.spanFraction(l - l2, l3) * (double)n);
    }

    public static double spanFraction(long l, long l2) {
        return (double)l / (double)l2;
    }

    public static void setInvert(boolean bl) {
        invert = bl;
    }

    public static boolean getInvert() {
        return invert;
    }

    public static class ChartLabel {
        private DynamicLabel dLabel;
        private int xPos;
        private int yPos;

        public DynamicLabel getdLabel() {
            return this.dLabel;
        }

        public void setdLabel(DynamicLabel dynamicLabel) {
            this.dLabel = dynamicLabel;
        }

        public int getxPos() {
            return this.xPos;
        }

        public void setxPos(int n) {
            this.xPos = n;
        }

        public int getyPos() {
            return this.yPos;
        }

        public void setyPos(int n) {
            this.yPos = n;
        }
    }

    public class MajorXDivisions
    implements GridType {
        public Enumeration gridLines(Dimension dimension) {
            return new Enumeration(this, dimension){
                private int offset;
                private int resolution;
                private long value;
                private long startValue;
                private long stopValue;
                private final /* synthetic */ Dimension val$size;
                private final /* synthetic */ MajorXDivisions this$1;
                {
                    this.this$1 = majorXDivisions;
                    this.val$size = dimension;
                    this.startValue = MajorXDivisions.access$100(this.this$1).getConvertedXStart();
                    this.stopValue = MajorXDivisions.access$100(this.this$1).getConvertedXStop();
                    this.computeOffsetAndResolution();
                    this.value = FastMath.ceil(this.startValue, (long)this.resolution) + (long)this.offset;
                }

                public boolean hasMoreElements() {
                    return this.value <= this.stopValue;
                }

                public Object nextElement() {
                    GridLine gridLine = MajorXDivisions.access$100(this.this$1).newXGridLineByValue(this.value, this.val$size.width);
                    this.value += (long)this.resolution;
                    return gridLine;
                }

                private void computeOffsetAndResolution() {
                    int n;
                    int n2;
                    long l = this.stopValue - this.startValue + 1L;
                    int n3 = (int)FastMath.float_log10(l);
                    int n4 = (int)Math.pow(10.0, n3 - 1);
                    int[] nArray = new int[]{2, 5, 10, 25, 50, 100};
                    int n5 = 5;
                    int n6 = 15;
                    int n7 = n4;
                    for (n2 = 0; n2 < nArray.length && n7 > 0 && (n = (int)(l / (long)n7)) > n6; ++n2) {
                        n7 = n4 * nArray[n2];
                    }
                    for (n2 = 0; n2 < nArray.length && n7 > 0 && (n = (int)(l / (long)n7)) < n5; ++n2) {
                        n7 = n4 / nArray[n2];
                    }
                    n4 = n7;
                    if (n4 <= 0) {
                        n4 = 1;
                    }
                    this.offset = 0;
                    this.resolution = n4;
                }
            };
        }

        static /* synthetic */ TraceChart access$100(MajorXDivisions majorXDivisions) {
            return majorXDivisions.TraceChart.this;
        }
    }

    public class EvenYDivisions
    extends EvenDivisions {
        public EvenYDivisions(int n) {
            super(n);
        }

        protected int getScreenDimension(Dimension dimension) {
            return dimension.height;
        }

        protected long getX1() {
            return TraceChart.this.getYTop();
        }

        protected long getX2() {
            return TraceChart.this.getYBottom();
        }
    }

    public class EvenXDivisions
    extends EvenDivisions {
        public EvenXDivisions(int n) {
            super(n);
        }

        protected int getScreenDimension(Dimension dimension) {
            return dimension.width;
        }

        protected long getX1() {
            return TraceChart.this.getXStart();
        }

        protected long getX2() {
            return TraceChart.this.getXStop();
        }
    }

    public abstract class EvenDivisions
    implements GridType {
        private final int divisions;

        public EvenDivisions(int n) {
            this.divisions = n;
        }

        public Enumeration gridLines(Dimension dimension) {
            return new Enumeration(this, dimension){
                private int nextLine;
                private final /* synthetic */ Dimension val$size;
                private final /* synthetic */ EvenDivisions this$1;
                {
                    this.this$1 = evenDivisions;
                    this.val$size = dimension;
                    this.nextLine = 0;
                }

                public boolean hasMoreElements() {
                    return this.nextLine <= EvenDivisions.access$000(this.this$1);
                }

                public Object nextElement() {
                    int n = this.nextLine * (this.this$1.getScreenDimension(this.val$size) - 1) / EvenDivisions.access$000(this.this$1);
                    long l = this.this$1.getX1();
                    long l2 = this.this$1.getX2();
                    long l3 = l2 - l;
                    long l4 = l + (long)this.nextLine * l3 / (long)EvenDivisions.access$000(this.this$1);
                    ++this.nextLine;
                    return new GridLine(l4, n);
                }
            };
        }

        protected abstract int getScreenDimension(Dimension var1);

        protected abstract long getX1();

        protected abstract long getX2();

        static /* synthetic */ int access$000(EvenDivisions evenDivisions) {
            return evenDivisions.divisions;
        }
    }

    public static class GridLine {
        final long value;
        final int pixel;

        public GridLine(long l, int n) {
            this.value = l;
            this.pixel = n;
        }
    }

    public static interface GridType {
        public Enumeration gridLines(Dimension var1);
    }
}

