/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.NumericKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ProgressIndicator;
import java.awt.Component;
import java.awt.event.KeyEvent;

public abstract class AbstractCalibrateScreen
extends Screen {
    protected static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$calibration$AbstractCalibrateScreen == null ? (class$elgato$infrastructure$calibration$AbstractCalibrateScreen = AbstractCalibrateScreen.class$("elgato.infrastructure.calibration.AbstractCalibrateScreen")) : class$elgato$infrastructure$calibration$AbstractCalibrateScreen);
    private final String topic;
    protected final Class measurementClass;
    private int normalMeasurementMode;
    protected MeasurementListener savedMeasurementListener;
    ModalKeyManager keyManager;
    NumericKeyManager calFreqKeyManager;
    static /* synthetic */ Class class$elgato$infrastructure$calibration$AbstractCalibrateScreen;

    public AbstractCalibrateScreen(String string, Class clazz, int n, MeasurementListener measurementListener) {
        this.topic = string;
        this.measurementClass = clazz;
        this.normalMeasurementMode = n;
        this.savedMeasurementListener = measurementListener;
    }

    public void installScreen(ScreenManager screenManager, boolean bl) {
        super.installScreen(screenManager);
        this.savedMeasurementListener = MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this.savedMeasurementListener, this.measurementClass);
        this.keyManager = new ModalKeyManager(screenManager){

            protected void processKeyPress(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 76) {
                    AbstractCalibrateScreen.this.getCancelButton().press();
                } else {
                    this.processSoftkeyPress(keyEvent);
                }
            }
        };
        this.calFreqKeyManager = new NumericKeyManager(screenManager);
        if (bl) {
            GlobalKeyManager.registerInstance(this.keyManager);
        } else {
            GlobalKeyManager.registerInstance(this.calFreqKeyManager);
        }
        screenManager.repaintImmediately();
    }

    public void installScreen(ScreenManager screenManager) {
        this.installScreen(screenManager, true);
    }

    protected abstract MenuItem getCancelButton();

    public void uninstallScreen(ScreenManager screenManager) {
        this.registerGlobalKeyManagerAsKeyListener(screenManager);
        this.setMode(this.normalMeasurementMode);
        MeasurementFactory.instance().getCommandProcessor().sendResumeCommand();
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.savedMeasurementListener, this.measurementClass);
        super.uninstallScreen(screenManager);
    }

    public String getTopic() {
        return this.topic;
    }

    MenuItem createCancelButton(ScreenManager screenManager) {
        return PushButton.createPopScreenCancelButton(screenManager);
    }

    public void registerCalKeyManager() {
        GlobalKeyManager.registerInstance(this.keyManager);
    }

    public void registerGlobalKeyManagerAsKeyListener(ScreenManager screenManager) {
        GlobalKeyManager.makeInstance(screenManager);
    }

    protected void setMode(int n) {
        MeasurementFactory.instance().getCommandProcessor().set(this.getTopic(), "mode", n);
    }

    void pauseMeasurement() {
        MeasurementFactory.instance().getCommandProcessor().sendPauseCommand();
    }

    public static Component wrapWithCalibrateBorder(Component component) {
        return new BorderWrapper(component, ProgressIndicator.BORDER, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

