/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.calibration.AbstractCalibrateScreen;
import elgato.infrastructure.calibration.CalibrateCommand;
import elgato.infrastructure.calibration.FirstStep;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.menu.ActionListener;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.measurement.dtf.DtfMeasurementSettings;
import elgato.measurement.onePortInsertionLoss.OnePortLossMeasurementSettings;
import elgato.measurement.returnLoss.ReturnLossMeasurementSettings;
import java.awt.Component;

public class AntennaCalibrateScreen
extends AbstractCalibrateScreen {
    Logger logger = LogManager.getLogger(class$elgato$infrastructure$calibration$AntennaCalibrateScreen == null ? (class$elgato$infrastructure$calibration$AntennaCalibrateScreen = AntennaCalibrateScreen.class$("elgato.infrastructure.calibration.AntennaCalibrateScreen")) : class$elgato$infrastructure$calibration$AntennaCalibrateScreen);
    static final int MEASURE_RETURN_LOSS = 5;
    static final int MEASURE_ONE_PORT_LOSS = 5;
    static final int MEASURE_DTF = 6;
    private final String _measurementName;
    private MenuItem startCalButton;
    private static MenuItem calStartFreqButton;
    private static MenuItem calStopFreqButton;
    private MenuItem continueButton;
    private MenuItem cancelButton;
    private Menu firstRightMenu;
    private Menu nextRightMenu;
    private ActionListener restoreCalFreqValuesListener;
    private ActionListener continueListener;
    private ActionListener startCalListener;
    static /* synthetic */ Class class$elgato$infrastructure$calibration$AntennaCalibrateScreen;
    static /* synthetic */ Class class$elgato$measurement$returnLoss$ReturnLossMeasurement;
    static /* synthetic */ Class class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement;
    static /* synthetic */ Class class$elgato$measurement$dtf$DistanceToFaultMeasurement;
    static /* synthetic */ Class class$elgato$infrastructure$calibration$FirstStep;

    AntennaCalibrateScreen(String string, String string2, Class clazz, int n, MeasurementListener measurementListener) {
        super(string2, clazz, n, measurementListener);
        this._measurementName = string;
        this.restoreCalFreqValuesListener = null;
    }

    AntennaCalibrateScreen(String string, String string2, Class clazz, int n, MeasurementListener measurementListener, MenuItem menuItem, MenuItem menuItem2) {
        super(string2, clazz, n, measurementListener);
        calStartFreqButton = menuItem;
        calStopFreqButton = menuItem2;
        this._measurementName = string;
        this.restoreCalFreqValuesListener = new ActionListener(){

            public void actionPerformed() {
                if (AntennaCalibrateScreen.this.measurementClass == (class$elgato$measurement$returnLoss$ReturnLossMeasurement == null ? (class$elgato$measurement$returnLoss$ReturnLossMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.returnLoss.ReturnLossMeasurement")) : class$elgato$measurement$returnLoss$ReturnLossMeasurement)) {
                    ReturnLossMeasurementSettings.instance().restoreCalStartStopFreqValues();
                } else if (AntennaCalibrateScreen.this.measurementClass == (class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement == null ? (class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement")) : class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement)) {
                    OnePortLossMeasurementSettings.instance().restoreCalStartStopFreqValues();
                } else if (AntennaCalibrateScreen.this.measurementClass == (class$elgato$measurement$dtf$DistanceToFaultMeasurement == null ? (class$elgato$measurement$dtf$DistanceToFaultMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.dtf.DistanceToFaultMeasurement")) : class$elgato$measurement$dtf$DistanceToFaultMeasurement)) {
                    DtfMeasurementSettings.instance().restoreCalStartStopFreqValues();
                }
            }
        };
    }

    public static AbstractCalibrateScreen createDTF(MeasurementListener measurementListener, MenuItem menuItem, MenuItem menuItem2) {
        return new AntennaCalibrateScreen(Text.Dist_n_Fault, "antDtf", class$elgato$measurement$dtf$DistanceToFaultMeasurement == null ? (class$elgato$measurement$dtf$DistanceToFaultMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.dtf.DistanceToFaultMeasurement")) : class$elgato$measurement$dtf$DistanceToFaultMeasurement, 6, measurementListener, menuItem, menuItem2);
    }

    public static AbstractCalibrateScreen createReturnLoss(MeasurementListener measurementListener, MenuItem menuItem, MenuItem menuItem2) {
        return new AntennaCalibrateScreen(Text.Return_Loss, "antRetLoss", class$elgato$measurement$returnLoss$ReturnLossMeasurement == null ? (class$elgato$measurement$returnLoss$ReturnLossMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.returnLoss.ReturnLossMeasurement")) : class$elgato$measurement$returnLoss$ReturnLossMeasurement, 5, measurementListener, menuItem, menuItem2);
    }

    public static AbstractCalibrateScreen createOnePortLoss(MeasurementListener measurementListener, MenuItem menuItem, MenuItem menuItem2) {
        return new AntennaCalibrateScreen(Text.One_Port_Loss, "antSpInsLoss", class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement == null ? (class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement = AntennaCalibrateScreen.class$("elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement")) : class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement, 5, measurementListener, menuItem, menuItem2);
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager, false);
        this.continueButton = this.createContinueButton(screenManager);
        this.cancelButton = this.createCancelButton(screenManager, this.restoreCalFreqValuesListener);
        this.startCalButton = this.createStartCalButton(screenManager);
        screenManager.installLeftMenu(new Menu(this._measurementName, new MenuItem[0]));
        this.initializeFirstRightMenu(screenManager);
        this.initializeNextRightMenu(screenManager);
        this.pauseMeasurement();
        this.logger.debug("setting calibrate open mode");
        this.displayCurrentPanel(screenManager);
        CalibrateCommand.register(new FirstStep(this.getTopic()));
        if (this.restoreCalFreqValuesListener != null) {
            GlobalKeyManager.instance().registerModeButtonListener(this.restoreCalFreqValuesListener);
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
    }

    protected MenuItem createCancelButton(ScreenManager screenManager, ActionListener actionListener) {
        PushButton pushButton = (PushButton)super.createCancelButton(screenManager);
        if (actionListener != null) {
            pushButton.addActionListener(actionListener);
        }
        return pushButton;
    }

    protected MenuItem getCancelButton() {
        return this.firstRightMenu.getItems()[6];
    }

    private void initializeFirstRightMenu(ScreenManager screenManager) {
        this.firstRightMenu = new Menu(Text.Calibrate, new MenuItem[]{this.startCalButton, null, calStartFreqButton, calStopFreqButton, null, null, this.cancelButton});
    }

    private void initializeNextRightMenu(ScreenManager screenManager) {
        this.nextRightMenu = new Menu(Text.Calibrate, new MenuItem[]{this.continueButton, this.createBackButton(screenManager), null, null, null, null, this.cancelButton});
    }

    void installFirstInstructionScreen(ScreenManager screenManager) {
        screenManager.installDisplay(this.getInstructions());
        this.installFirstRightMenu(screenManager);
    }

    void installFirstRightMenu(ScreenManager screenManager) {
        ((PushButton)this.startCalButton).clearListeners();
        screenManager.installRightMenu(this.firstRightMenu);
        ((PushButton)this.startCalButton).addActionListener(this.startCalListener);
    }

    void installNextRightMenu(ScreenManager screenManager) {
        this.installNextRightMenu(screenManager, true);
    }

    private void installNextRightMenu(ScreenManager screenManager, boolean bl) {
        this.continueButton.setEnabled(false);
        ((PushButton)this.continueButton).clearListeners();
        screenManager.installRightMenu(this.nextRightMenu);
        if (bl) {
            this.continueButton.setEnabled(true);
            ((PushButton)this.continueButton).addActionListener(this.continueListener);
        }
    }

    void installSecondInstructionScreen(ScreenManager screenManager) {
        screenManager.installDisplay(this.createCalibrateOpenScreen());
    }

    void installThirdInstructionScreen(ScreenManager screenManager) {
        screenManager.installDisplay(FirstStep.createCalibrateShortScreen());
    }

    private void displayCurrentPanel(final ScreenManager screenManager) {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                AntennaCalibrateScreen.this.installFirstInstructionScreen(screenManager);
            }
        }, "AntennaCalibrateScreen.displayCurrentPanel");
    }

    private Component getInstructions() {
        FixedPanel fixedPanel = new FixedPanel("images/backgroundonly.png", false);
        fixedPanel.addCenteredLabel(30, Text.SCREEN_RETURN_LOSS_CALIBRATE_CONFIGURE);
        fixedPanel.addCenteredLabel(100, Text.SCREEN_RETURN_LOSS_CALIBRATE_IMPORTANT);
        fixedPanel.addCenteredLabel(140, Text.SCREEN_RETURN_LOSS_CALIBRATE_CONFIGURE_TEXT1);
        fixedPanel.addCenteredLabel(160, Text.SCREEN_RETURN_LOSS_CALIBRATE_CONFIGURE_TEXT2);
        fixedPanel.addCenteredLabel(180, Text.SCREEN_RETURN_LOSS_CALIBRATE_CONFIGURE_TEXT3);
        fixedPanel.addCenteredLabel(210, Text.SCREEN_RETURN_LOSS_CALIBRATE_CONFIGURE_TEXT4);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    private Component createCalibrateOpenScreen() {
        FixedPanel fixedPanel = new FixedPanel("images/returnloss_1d.png", false);
        fixedPanel.addCenteredLabel(30, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE1_CONNECT1);
        fixedPanel.addLabel(340, 120, Text.RF_OUT);
        fixedPanel.addLabel(340, 140, Text.slash_SWR);
        fixedPanel.addLabel(100, 210, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE1_LABEL3);
        fixedPanel.addLabel(20, 290, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE1_TEXT1);
        fixedPanel.addLabel(20, 310, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE1_TEXT2);
        fixedPanel.addLabel(20, 350, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE1_TEXT3);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    MenuItem createStartCalButton(final ScreenManager screenManager) {
        this.startCalListener = new ActionListener(){

            public void actionPerformed() {
                AntennaCalibrateScreen.this.registerCalKeyManager();
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new CalStartedCommandListener(screenManager));
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(new CalStartedErrorListener(screenManager));
                ((PushButton)AntennaCalibrateScreen.this.startCalButton).clearListeners();
                AntennaCalibrateScreen.this.setMode(1);
                screenManager.installDisplay(AntennaCalibrateScreen.this.createCalibrateOpenScreen());
                AntennaCalibrateScreen.this.installNextRightMenu(screenManager, false);
            }
        };
        return new PushButton(Text.Continue, this.getContextString("continue"));
    }

    MenuItem createContinueButton(final ScreenManager screenManager) {
        this.continueListener = new ActionListener(){

            public void actionPerformed() {
                CalibrateCommand.instance().execute(screenManager);
            }
        };
        return new PushButton(Text.Continue, this.getContextString("continue"));
    }

    private MenuItem createBackButton(final ScreenManager screenManager) {
        return new PushButton(Text.Back, this.getContextString("back"), new ActionListener(){

            public void actionPerformed() {
                if (!CalibrateCommand.instance().getClass().equals(class$elgato$infrastructure$calibration$FirstStep == null ? (class$elgato$infrastructure$calibration$FirstStep = AntennaCalibrateScreen.class$("elgato.infrastructure.calibration.FirstStep")) : class$elgato$infrastructure$calibration$FirstStep)) {
                    CalibrateCommand.instance().back(screenManager);
                } else {
                    screenManager.installDisplay(AntennaCalibrateScreen.this.getInstructions());
                    AntennaCalibrateScreen.this.installFirstRightMenu(screenManager);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ MenuItem access$500(AntennaCalibrateScreen antennaCalibrateScreen) {
        return antennaCalibrateScreen.continueButton;
    }

    static /* synthetic */ ActionListener access$600(AntennaCalibrateScreen antennaCalibrateScreen) {
        return antennaCalibrateScreen.continueListener;
    }

    private class CalStartedErrorListener
    implements CommandListener {
        private ScreenManager _screenManager;

        public CalStartedErrorListener(ScreenManager screenManager) {
            this._screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            if (AntennaCalibrateScreen.this.getTopic().equals(command.getProperty("errCmd"))) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                CalibrateCommand.popScreenAndShowCalibrateErrorMessage(this._screenManager);
                CalibrateCommand.instance().dispose();
            }
        }
    }

    private class CalStartedCommandListener
    implements CommandListener {
        private ScreenManager screenManager;

        public CalStartedCommandListener(ScreenManager screenManager) {
            this.screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            AntennaCalibrateScreen.this.logger.debug("Command received: " + command.getName() + ":" + command.getProperty("event"));
            if ("rlCalStarted".equals(command.getProperty("event"))) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                EventDispatchThread.invokeLater(new Runnable(this){
                    private final /* synthetic */ CalStartedCommandListener this$1;
                    {
                        this.this$1 = calStartedCommandListener;
                    }

                    public void run() {
                        AntennaCalibrateScreen.access$500(CalStartedCommandListener.access$400(this.this$1)).setEnabled(true);
                        ((PushButton)AntennaCalibrateScreen.access$500(CalStartedCommandListener.access$400(this.this$1))).addActionListener(AntennaCalibrateScreen.access$600(CalStartedCommandListener.access$400(this.this$1)));
                    }
                }, "AntennaCalibrateScreen.CalStartedCommandListener.commandReceived");
            } else {
                CalibrateCommand.instance().logUnexpectedCommand(AntennaCalibrateScreen.this.logger, command, "event", "rlCalStarted");
            }
        }

        static /* synthetic */ AntennaCalibrateScreen access$400(CalStartedCommandListener calStartedCommandListener) {
            return calStartedCommandListener.AntennaCalibrateScreen.this;
        }
    }
}

