/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderedProgressIndicator;

public abstract class CalibrateCommand {
    protected static final int CALIBRATE_OPEN = 1;
    protected static final int CALIBRATE_SHORT = 2;
    protected static final int CALIBRATE_LOAD = 3;
    protected static final int COMPUTE_CALIBRATION = 4;
    private static CalibrateCommand _instance;
    final String _topic;
    protected BorderedProgressIndicator progressIndicator;
    static /* synthetic */ Class class$elgato$measurement$returnLoss$ReturnLossMeasurement;
    static /* synthetic */ Class class$elgato$measurement$dtf$DistanceToFaultMeasurement;
    static /* synthetic */ Class class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement;

    CalibrateCommand(String string) {
        this._topic = string;
    }

    public abstract void execute(ScreenManager var1);

    public abstract void back(ScreenManager var1);

    public static Class getMeasurementClass(String string) {
        if (string.equals("antRetLoss")) {
            return class$elgato$measurement$returnLoss$ReturnLossMeasurement == null ? (class$elgato$measurement$returnLoss$ReturnLossMeasurement = CalibrateCommand.class$("elgato.measurement.returnLoss.ReturnLossMeasurement")) : class$elgato$measurement$returnLoss$ReturnLossMeasurement;
        }
        if (string.equals("antDtf")) {
            return class$elgato$measurement$dtf$DistanceToFaultMeasurement == null ? (class$elgato$measurement$dtf$DistanceToFaultMeasurement = CalibrateCommand.class$("elgato.measurement.dtf.DistanceToFaultMeasurement")) : class$elgato$measurement$dtf$DistanceToFaultMeasurement;
        }
        if (string.equals("antSpInsLoss")) {
            return class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement == null ? (class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement = CalibrateCommand.class$("elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement")) : class$elgato$measurement$onePortInsertionLoss$OnePortInsertionLossMeasurement;
        }
        throw new IllegalStateException("topic " + string + " is not valid");
    }

    public Class getMeasurementClass() {
        return CalibrateCommand.getMeasurementClass(this._topic);
    }

    static void register(CalibrateCommand calibrateCommand) {
        _instance = calibrateCommand;
    }

    static CalibrateCommand instance() {
        return _instance;
    }

    BorderedProgressIndicator createWaitPanel(String string) {
        String[] stringArray = new String[]{Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY_TITLE + " " + string, " ", Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY1 + " " + string, Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY2, Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY3, Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY4, Text.SCREEN_RETURN_LOSS_CALIBRATE_STANDBY5, " "};
        return this.createAndStartProgressIndicator(stringArray);
    }

    private BorderedProgressIndicator createAndStartProgressIndicator(String[] stringArray) {
        this.progressIndicator = new BorderedProgressIndicator(new DefaultProgressIndicator(stringArray));
        return this.progressIndicator;
    }

    public static void popScreenAndShowCalibrateErrorMessage(ScreenManager screenManager) {
        CalibrateCommand.popScreenAndShowErrorMessage(screenManager, Text.SCREEN_CALIBRATION_FAILURE);
    }

    public static void popScreenAndShowNormalizeErrorMessage(ScreenManager screenManager) {
        CalibrateCommand.popScreenAndShowErrorMessage(screenManager, Text.SCREEN_NORMALIZATION_FAILURE);
    }

    private static void popScreenAndShowErrorMessage(final ScreenManager screenManager, String string) {
        String string2 = "<html><body>" + string + "</body></html>";
        final MessageScreen messageScreen = new MessageScreen(string2, true, 0);
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                screenManager.popScreen();
                screenManager.pushScreen(messageScreen);
            }
        }, "CalibrateCommand.popScreenAndShowErrorMessage");
    }

    protected void logUnexpectedCommand(Logger logger, Command command, String string, String string2) {
        logger.error("wrong command, expected " + string + ": " + string2 + ", received: " + command);
    }

    public void dispose() {
        this.progressIndicator.stop();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

