/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.calibration.AbstractCalibrateScreen;
import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.calibration.CalibrateCommand;
import elgato.infrastructure.calibration.SecondStep;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import java.awt.Component;

class FirstStep
extends CalibrateCommand {
    private Logger logger = LogManager.getLogger(class$elgato$infrastructure$calibration$FirstStep == null ? (class$elgato$infrastructure$calibration$FirstStep = FirstStep.class$("elgato.infrastructure.calibration.FirstStep")) : class$elgato$infrastructure$calibration$FirstStep);
    public MeasurementListener _measurementListener;
    static /* synthetic */ Class class$elgato$infrastructure$calibration$FirstStep;

    public FirstStep(String string) {
        super(string);
    }

    static Component createCalibrateShortScreen() {
        FixedPanel fixedPanel = new FixedPanel("images/returnloss_1d.png", false);
        fixedPanel.addCenteredLabel(30, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE2_CONNECT1);
        fixedPanel.addLabel(340, 120, Text.RF_OUT);
        fixedPanel.addLabel(340, 140, Text.slash_SWR);
        fixedPanel.addLabel(100, 210, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE2_CONNECT2);
        fixedPanel.addLabel(20, 290, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE2_TEXT1);
        fixedPanel.addLabel(20, 310, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE2_TEXT2);
        fixedPanel.addLabel(20, 330, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE2_TEXT3);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    public void execute(ScreenManager screenManager) {
        this.logger.debug("registering measurement listener");
        this._measurementListener = this.createMeasurementListener(screenManager);
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this._measurementListener, this.getMeasurementClass());
        screenManager.clearRightMenu();
        screenManager.installDisplay(this.createWaitPanel(Text.Open));
        this.logger.debug("sending single command");
        MeasurementFactory.instance().getCommandProcessor().sendSingleCommand();
    }

    public void back(ScreenManager screenManager) {
        throw new IllegalStateException("back() not possible from first screen");
    }

    MeasurementListener createMeasurementListener(ScreenManager screenManager) {
        return new FirstStepMeasurementListener(screenManager);
    }

    CommandListener createCommandListener(ScreenManager screenManager) {
        return new FirstStepCommandListener(screenManager);
    }

    CommandListener createErrorListener(ScreenManager screenManager) {
        return new FirstStepErrorListener(screenManager);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FirstStepErrorListener
    implements CommandListener {
        private ScreenManager _screenManager;

        public FirstStepErrorListener(ScreenManager screenManager) {
            this._screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            if (FirstStep.this._topic.equals(command.getProperty("errCmd"))) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                CalibrateCommand.popScreenAndShowCalibrateErrorMessage(this._screenManager);
                FirstStep.this.dispose();
            }
        }
    }

    private class FirstStepCommandListener
    implements CommandListener {
        private ScreenManager screenManager;

        public FirstStepCommandListener(ScreenManager screenManager) {
            this.screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            FirstStep.this.logger.debug("Command received: " + command.getName() + ":" + command.getProperty("event"));
            if ("rlCalOpenComplete".equals(command.getProperty("event"))) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                EventDispatchThread.invokeLater(new Runnable(this){
                    private final /* synthetic */ FirstStepCommandListener this$1;
                    {
                        this.this$1 = firstStepCommandListener;
                    }

                    public void run() {
                        FirstStepCommandListener.access$100(this.this$1).installDisplay(FirstStep.createCalibrateShortScreen());
                        ((AntennaCalibrateScreen)FirstStepCommandListener.access$100(this.this$1).getCurrentScreen()).installNextRightMenu(FirstStepCommandListener.access$100(this.this$1));
                    }
                }, "FirstStep.FirstStepCommandListener.commandReceived");
                FirstStep.this.dispose();
                CalibrateCommand.register(new SecondStep(FirstStep.this._topic));
            } else {
                FirstStep.this.logUnexpectedCommand(FirstStep.this.logger, command, "event", "rlCalOpenComplete");
            }
        }

        static /* synthetic */ ScreenManager access$100(FirstStepCommandListener firstStepCommandListener) {
            return firstStepCommandListener.screenManager;
        }
    }

    private class FirstStepMeasurementListener
    implements MeasurementListener {
        private ScreenManager screenManager;

        public FirstStepMeasurementListener(ScreenManager screenManager) {
            this.screenManager = screenManager;
        }

        public void measurementReceived(Measurement measurement) {
            MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(FirstStep.this._measurementListener, FirstStep.this.getMeasurementClass());
            FirstStep.this.logger.debug("measurement receaved: " + measurement.getClass().getName());
            MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new FirstStepCommandListener(this.screenManager));
            MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(FirstStep.this.createErrorListener(this.screenManager));
            FirstStep.this.logger.debug("sending calibrate short");
            MeasurementFactory.instance().getCommandProcessor().set(FirstStep.this._topic, "mode", 2L);
        }
    }
}

