/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.calibration.AbstractCalibrateScreen;
import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.calibration.CalibrateCommand;
import elgato.infrastructure.calibration.FirstStep;
import elgato.infrastructure.calibration.ThirdStep;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import java.awt.Component;

class SecondStep
extends CalibrateCommand {
    private MeasurementListener measurementListener;
    private Logger logger = LogManager.getLogger(class$elgato$infrastructure$calibration$SecondStep == null ? (class$elgato$infrastructure$calibration$SecondStep = SecondStep.class$("elgato.infrastructure.calibration.SecondStep")) : class$elgato$infrastructure$calibration$SecondStep);
    static /* synthetic */ Class class$elgato$infrastructure$calibration$SecondStep;

    public SecondStep(String string) {
        super(string);
    }

    public void execute(ScreenManager screenManager) {
        screenManager.clearRightMenu();
        this.logger.debug("creating measurement listener");
        this.measurementListener = this.createMeasurementListener(screenManager);
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.measurementListener, this.getMeasurementClass());
        MeasurementFactory.instance().getCommandProcessor().sendSingleCommand();
        this.logger.debug("sending single command");
        screenManager.installDisplay(this.createWaitPanel(Text.Short));
    }

    public void back(ScreenManager screenManager) {
        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new CommandListener(){

            public void commandReceived(Command command) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
            }
        });
        MeasurementFactory.instance().getCommandProcessor().set(this._topic, "mode", 1L);
        AntennaCalibrateScreen antennaCalibrateScreen = (AntennaCalibrateScreen)screenManager.getCurrentScreen();
        antennaCalibrateScreen.installSecondInstructionScreen(screenManager);
        CalibrateCommand.register(new FirstStep(this._topic));
    }

    MeasurementListener createMeasurementListener(ScreenManager screenManager) {
        return new SecondStepMeasurementListener(screenManager);
    }

    CommandListener createCommandListener(ScreenManager screenManager) {
        return new SecondStepCommandListener(screenManager);
    }

    CommandListener createErrorListener(ScreenManager screenManager) {
        return new SecondStepErrorListener(screenManager);
    }

    static Component getThirdStepInstructions() {
        FixedPanel fixedPanel = new FixedPanel("images/returnloss_3d.png", false);
        fixedPanel.addCenteredLabel(30, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE3_CONNECT1);
        fixedPanel.addLabel(340, 120, Text.RF_OUT);
        fixedPanel.addLabel(340, 140, Text.slash_SWR);
        fixedPanel.addLabel(110, 210, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE3_CONNECT2);
        fixedPanel.addLabel(20, 290, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE3_TEXT1);
        fixedPanel.addLabel(20, 310, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE3_TEXT2);
        fixedPanel.addLabel(20, 330, Text.SCREEN_RETURN_LOSS_CALIBRATE_MODE3_TEXT3);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SecondStepErrorListener
    implements CommandListener {
        private final ScreenManager _screenManager;

        public SecondStepErrorListener(ScreenManager screenManager) {
            this._screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            if (SecondStep.this._topic.equals(command.getProperty("errCmd"))) {
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                CalibrateCommand.popScreenAndShowCalibrateErrorMessage(this._screenManager);
                SecondStep.this.dispose();
            }
        }
    }

    private class SecondStepCommandListener
    implements CommandListener {
        private final ScreenManager _screenManager;

        public SecondStepCommandListener(ScreenManager screenManager) {
            this._screenManager = screenManager;
        }

        public void commandReceived(Command command) {
            SecondStep.this.logger.debug("command received: " + command.getName() + ":" + command.getProperty("event"));
            if ("rlCalShortComplete".equals(command.getProperty("event"))) {
                SecondStep.this.logger.debug("installing third step screen");
                EventDispatchThread.invokeLater(new Runnable(this){
                    private final /* synthetic */ SecondStepCommandListener this$1;
                    {
                        this.this$1 = secondStepCommandListener;
                    }

                    public void run() {
                        SecondStepCommandListener.access$200(this.this$1).installDisplay(SecondStep.getThirdStepInstructions());
                        ((AntennaCalibrateScreen)SecondStepCommandListener.access$200(this.this$1).getCurrentScreen()).installNextRightMenu(SecondStepCommandListener.access$200(this.this$1));
                    }
                }, "SecondStep.SecondStepCommandListener.commandReceived");
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                CalibrateCommand.register(new ThirdStep(SecondStep.this._topic));
                SecondStep.this.dispose();
            } else {
                SecondStep.this.logUnexpectedCommand(SecondStep.this.logger, command, "event", "rlCalShortComplete");
            }
        }

        static /* synthetic */ ScreenManager access$200(SecondStepCommandListener secondStepCommandListener) {
            return secondStepCommandListener._screenManager;
        }
    }

    private class SecondStepMeasurementListener
    implements MeasurementListener {
        private final ScreenManager _screenManager;

        public SecondStepMeasurementListener(ScreenManager screenManager) {
            this._screenManager = screenManager;
        }

        public void measurementReceived(Measurement measurement) {
            MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(SecondStep.this.measurementListener, SecondStep.this.getMeasurementClass());
            MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new SecondStepCommandListener(this._screenManager));
            MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(new SecondStepErrorListener(this._screenManager));
            MeasurementFactory.instance().getCommandProcessor().set(SecondStep.this._topic, "mode", 3L);
        }
    }
}

