/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.calibration;

import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.calibration.CalibrateCommand;
import elgato.infrastructure.calibration.SecondStep;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;

class ThirdStep
extends CalibrateCommand {
    private MeasurementListener measurementListener;
    private Logger logger = LogManager.getLogger(class$elgato$infrastructure$calibration$ThirdStep == null ? (class$elgato$infrastructure$calibration$ThirdStep = ThirdStep.class$("elgato.infrastructure.calibration.ThirdStep")) : class$elgato$infrastructure$calibration$ThirdStep);
    static /* synthetic */ Class class$elgato$infrastructure$calibration$ThirdStep;

    public ThirdStep(String string) {
        super(string);
    }

    public void execute(ScreenManager screenManager) {
        this.logger.debug("registering measurement listener");
        this.measurementListener = this.createMeasurementListener(screenManager);
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.measurementListener, this.getMeasurementClass());
        screenManager.clearRightMenu();
        screenManager.installDisplay(this.createWaitPanel(Text.Load));
        this.logger.debug("sending single command");
        MeasurementFactory.instance().getCommandProcessor().sendSingleCommand();
    }

    MeasurementListener createMeasurementListener(final ScreenManager screenManager) {
        return new MeasurementListener(){

            public void measurementReceived(Measurement measurement) {
                ThirdStep.this.logger.debug("measurementReceived " + measurement.getClass().getName());
                MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(ThirdStep.this.measurementListener, ThirdStep.this.getMeasurementClass());
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(ThirdStep.this.createLoadCalibrationCompleteCommandListener(screenManager));
                MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(ThirdStep.this.createLoadCalibrationErrorCommandListener(screenManager));
                ThirdStep.this.logger.debug("sending compute calibration");
                MeasurementFactory.instance().getCommandProcessor().set(ThirdStep.this._topic, "mode", 4L);
            }
        };
    }

    CommandListener createLoadCalibrationCompleteCommandListener(final ScreenManager screenManager) {
        return new CommandListener(){

            public void commandReceived(Command command) {
                ThirdStep.this.logger.debug("command received: " + command.getName());
                if ("rlCalLoadComplete".equals(command.getProperty("event"))) {
                    MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(ThirdStep.this.createComputeCalibrationCompleteListener(screenManager));
                    MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(ThirdStep.this.createComputeCalibrationCompleteErrorListener(screenManager));
                    MeasurementFactory.instance().getCommandProcessor().sendSingleCommand();
                }
            }
        };
    }

    CommandListener createLoadCalibrationErrorCommandListener(final ScreenManager screenManager) {
        return new CommandListener(){

            public void commandReceived(Command command) {
                ThirdStep.this.logger.debug("command received: " + command.getName());
                if (ThirdStep.this._topic.equals(command.getProperty("errCmd"))) {
                    ThirdStep.this.dispose();
                    MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                    MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                    CalibrateCommand.popScreenAndShowCalibrateErrorMessage(screenManager);
                }
            }
        };
    }

    CommandListener createComputeCalibrationCompleteListener(final ScreenManager screenManager) {
        return new CommandListener(){

            public void commandReceived(Command command) {
                ThirdStep.this.logger.debug("command received: " + command.getClass().getName());
                if ("rlCalComputeComplete".equals(command.getProperty("event"))) {
                    ThirdStep.this.dispose();
                    MeasurementFactory.instance().getCommandProcessor().sendResumeCommand();
                    EventDispatchThread.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            4.access$200(this.this$1).popScreen();
                        }
                    }, "ThirdStep.createComputeCalibrationCompleteListener.commandReceived");
                } else {
                    ThirdStep.this.logUnexpectedCommand(ThirdStep.this.logger, command, "event", "rlCalComputeComplete");
                }
            }

            static /* synthetic */ ScreenManager access$200(4 var0) {
                return var0.screenManager;
            }
        };
    }

    CommandListener createComputeCalibrationCompleteErrorListener(final ScreenManager screenManager) {
        return new CommandListener(){

            public void commandReceived(Command command) {
                ThirdStep.this.logger.debug("command received: " + command.getName());
                if ("single".equals(command.getProperty("errCmd"))) {
                    MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
                    MeasurementFactory.instance().getCommandProcessor().setErrorEventListener(null);
                    MeasurementFactory.instance().getCommandProcessor().sendResumeCommand();
                    CalibrateCommand.popScreenAndShowCalibrateErrorMessage(screenManager);
                    ThirdStep.this.dispose();
                } else {
                    ThirdStep.this.logUnexpectedCommand(ThirdStep.this.logger, command, "errCmd", "single");
                }
            }
        };
    }

    public void back(ScreenManager screenManager) {
        MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(new CommandListener(){

            public void commandReceived(Command command) {
                ThirdStep.this.logger.debug("command received: " + command.getName());
                MeasurementFactory.instance().getCommandProcessor().setNotifyEventListener(null);
            }
        });
        MeasurementFactory.instance().getCommandProcessor().set(this._topic, "mode", 2L);
        AntennaCalibrateScreen antennaCalibrateScreen = (AntennaCalibrateScreen)screenManager.getCurrentScreen();
        antennaCalibrateScreen.installNextRightMenu(screenManager);
        antennaCalibrateScreen.installThirdInstructionScreen(screenManager);
        CalibrateCommand.register(new SecondStep(this._topic));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

