/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.VectorMap;
import java.util.Enumeration;
import java.util.Vector;

public class Command {
    public static final String SET = "set";
    public static final String GET = "get";
    public static final String SET_ACTIVE = "setActive";
    public static final String REMOTE = "remote";
    public static final String LOCAL = "local";
    public static final String SHOW_MSG = "showMsg";
    public static final String CLOSE_GUI = "closeGui";
    public static final String RECALL = "recall";
    public static final String SAVE = "save";
    public static final String STATE_CONFIG = "config";
    public static final String TOPIC = "topic";
    public static final String NOTIFY_EVENT = "notifyEvent";
    public static final String COMMAND_ERROR_EVENT = "cmdError";
    public static final String RESUME = "resume";
    public static final String SINGLE = "single";
    public static final String SET_LICENSES = "setLicensesAndWorkingHardware";
    public static final String GET_LICENSES = "getLicenses";
    public static final String GET_HARDWARE = "getHwFeatures";
    public static final String SET_HARDWARE = "setHwFeatures";
    public static final String GET_STATE_LIST = "getStateList";
    public static final String SET_STATE_LIST = "setStateList";
    public static final String GET_SYSTEM_ID = "getSystemId";
    public static final String SET_SYSTEM_ID = "setSystemId";
    public static final String SYS_MODEL = "model";
    public static final String SYS_SERIAL = "serialNum";
    public static final String SYS_HOST = "hostId";
    public static final String SYS_ETHERNETNUMBER = "ethernetNumber";
    public static final String GET_VERSION_INFO = "getVersionInfo";
    public static final String SET_VERSION_INFO = "setVersionInfo";
    public static final String GET_OPTION_LIST = "getOptionList";
    public static final String SET_OPTION_LIST = "setOptionList";
    public static final String ADD_OPTION = "addOption";
    public static final String GET_RX_DAC_SETTING = "getRxDacSetting";
    public static final String SET_RX_DAC_SETTING = "setRxDacSetting";
    public static final String GLOBAL_TOPIC = "global";
    public static final String APM_Topic = "APM";
    public static final String Power_Mode = "pwrMode";
    public static final String Power_Mode_Auto = "auto";
    public static final String Power_Mode_DC_Only = "dc";
    public static final String Power_Mode_AC_Only = "ac";
    public static final String Power_Mode_Recondition = "recondition";
    public static final String KEY_EVENT = "event";
    public static final String KEY_EVENT_AWAKE_FROM_SLEEP_START = "awakeFromSleepStart";
    public static final String KEY_EVENT_CDMAOA_ZERO_COMPLETE = "pmZeroComplete";
    public static final String KEY_EVENT_CDMAOA_CAL_COMPLETE = "pmCalComplete";
    public static final String MEAS = "meas";
    public static final String KEY_COMMAND_THAT_ERRORED = "errCmd";
    private final String name;
    private final VectorMap properties = new VectorMap();
    private final Vector orderedKeys = new Vector();

    public Command(String string) {
        this.name = string;
    }

    public Command(String string, String string2, String string3) {
        this(string);
        this.addProperty(string2, string3);
    }

    public static Command makeSetCommand(String string) {
        Command command = new Command(SET);
        if (!string.equals(GLOBAL_TOPIC)) {
            command.addProperty(TOPIC, string);
        }
        return command;
    }

    public static Command makeGlobalSetCommand() {
        return Command.makeSetCommand(GLOBAL_TOPIC);
    }

    public static Command makeGetCommand(String string) {
        if (string.equals(GLOBAL_TOPIC)) {
            throw new RuntimeException("Doesn't make sense to make a get command with no topic!");
        }
        Command command = new Command(GET);
        command.addProperty(TOPIC, string);
        return command;
    }

    public static Command makeNotifyEventCommand(String string) {
        Command command = new Command(NOTIFY_EVENT);
        command.addProperty(KEY_EVENT, string);
        return command;
    }

    public static Command makeErrorEventCommand(String string) {
        Command command = new Command(COMMAND_ERROR_EVENT);
        command.addProperty(KEY_COMMAND_THAT_ERRORED, string);
        return command;
    }

    public static Command makeSetActiveCommand(String string) {
        Command command = new Command(SET_ACTIVE);
        command.addProperty(MEAS, string);
        return command;
    }

    public void addProperty(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("no colon in command '" + string + "'");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.addProperty(string2, string3);
    }

    public void addProperty(String string, String string2) {
        if (string.equals(TOPIC) && this.getProperty(TOPIC) != null) {
            throw new IllegalStateException("Cannot redefine the topic on a command.");
        }
        this.properties.addItem(string, string2);
        if (this.orderedKeys.indexOf(string) < 0) {
            this.orderedKeys.addElement(string);
        }
    }

    public void clearProperty(String string) {
        Vector vector = this.properties.getItems(string);
        if (vector != null && vector.size() > 0) {
            vector.setSize(0);
        }
    }

    public void addProperty(String string, long l) {
        this.addProperty(string, String.valueOf(l));
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String string) {
        Vector vector = this.properties.getItems(string);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return String.valueOf(vector.elementAt(0));
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = String.valueOf(vector.elementAt(i));
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String[] getPropertiesArray(String string) {
        Vector vector = this.properties.getItems(string);
        if (vector.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public boolean propertyExists(String string) {
        Vector vector = this.properties.getItems(string);
        return vector != null && vector.size() > 0;
    }

    public long getLong(String string) {
        long l = 0L;
        String string2 = this.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            l = Long.parseLong(string2);
        }
        return l;
    }

    public boolean isSetCommand() {
        return SET.equals(this.name);
    }

    public boolean isSetActiveCommand() {
        return SET_ACTIVE.equals(this.name);
    }

    public KeyValuePair[] getProperties() {
        Vector<KeyValuePair> vector = new Vector<KeyValuePair>(this.orderedKeys.size() * 2);
        for (int i = 0; i < this.orderedKeys.size(); ++i) {
            String string = (String)this.orderedKeys.elementAt(i);
            Vector vector2 = this.properties.getItems(string);
            for (int j = 0; j < vector2.size(); ++j) {
                String string2 = (String)vector2.elementAt(j);
                vector.addElement(new KeyValuePair(string, string2));
            }
        }
        Object[] objectArray = new KeyValuePair[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration keys() {
        return this.orderedKeys.elements();
    }

    public String toString() {
        return "Command: " + this.name + this.getPropertiesAsString();
    }

    public static Command makeCenterFrequencyAndSpanCommand(SettingsModel settingsModel) {
        Command command = Command.makeCenterFrequencyCommand(settingsModel);
        command.addProperty("span", String.valueOf(settingsModel.getLong("span") / 1000L));
        return command;
    }

    public static Command makeCenterFrequencyCommand(SettingsModel settingsModel) {
        Command command = Command.makeGlobalSetCommand();
        long l = Command.getCenterFrequency(settingsModel);
        command.addProperty("cf", String.valueOf(l / 1000L));
        command.addProperty("cfOffset", String.valueOf(l % 1000L));
        return command;
    }

    public static long getCenterFrequency(SettingsModel settingsModel) {
        long l = settingsModel.getLong("cf");
        return l;
    }

    private String getPropertiesAsString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("[");
        int n = this.orderedKeys.size();
        for (int i = 0; i < n; ++i) {
            String string;
            if (i != 0) {
                stringBuffer.append(", ");
            }
            if ((string = (String)this.orderedKeys.elementAt(i)) == null) {
                stringBuffer.append("null");
                continue;
            }
            String string2 = this.getProperty(string);
            stringBuffer.append(string).append("=").append(string2);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Command)) {
            return false;
        }
        Command command = (Command)object;
        if (command.name.equals(this.name)) {
            return command.properties.equals(this.properties);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Command getResultCommand(Command command, String string) {
        try {
            return MeasurementFactory.instance().getCommandProcessor().call(command, string);
        }
        catch (CommandTimeoutException commandTimeoutException) {
            throw new RuntimeException("timeout while retrieving the " + string + " command.");
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("interruption while retrieving the " + string + " command.");
        }
    }
}

