/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Semaphore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class CommandChannelEmulator {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$commChannel$CommandChannelEmulator == null ? (class$elgato$infrastructure$commChannel$CommandChannelEmulator = CommandChannelEmulator.class$("elgato.infrastructure.commChannel.CommandChannelEmulator")) : class$elgato$infrastructure$commChannel$CommandChannelEmulator);
    private static final String COMMAND_PREFIX = "cmd: ";
    private static final int LONG_TIME = 20000;
    private final int port;
    private PrintWriter out;
    private String name;
    private Acceptor acceptor;
    private volatile String activeMeasurement;
    private volatile boolean bindProblem = false;
    private volatile boolean sendMessages = false;
    private Vector commandInProgress = new Vector();
    private Hashtable listeners = new Hashtable();
    private volatile boolean pause = false;
    private volatile boolean single = false;
    static /* synthetic */ Class class$elgato$infrastructure$commChannel$CommandChannelEmulator;

    public CommandChannelEmulator(int n) {
        this.port = n;
        this.init("CommandChannelEmulator");
    }

    public CommandChannelEmulator(int n, String string) {
        this.port = n;
        this.init("CommandChannelEmulator: " + string);
    }

    private void init(String string) {
        this.name = string;
        this.addListener("pause", (EmulatorCommandListener)new PauseListener());
        this.addListener("resume", (EmulatorCommandListener)new ResumeListener());
        this.addListener("single", (EmulatorCommandListener)new SingleListener());
        this.addListener("setActive", (EmulatorCommandListener)new SetActiveListener());
        this.addListener("getLicenses", (EmulatorCommandListener)new GetLicenseInfoListener());
        this.addListener("getStateList", (EmulatorCommandListener)new GetStateListListener());
        this.addListener("getSystemId", (EmulatorCommandListener)new GetSystemIdListener());
        this.addListener("getOptionList", (EmulatorCommandListener)new InstalledOptionsListener());
        this.addListener("addOption", (EmulatorCommandListener)new AddOptionListener());
        this.addListener("getBatteryStatus", (EmulatorCommandListener)new BatteryStatusListener());
        this.addListener("getVersionInfo", (EmulatorCommandListener)new VersionInfoListener());
        this.addListener("getHwFeatures", (EmulatorCommandListener)new HardwareFeaturesListener());
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() throws BindException {
        if (logger.isDebugEnabled()) {
            logger.debug("start() name=" + this.name);
        }
        if (this.acceptor != null) {
            throw new IllegalStateException("Already started");
        }
        Semaphore semaphore = new Semaphore();
        this.acceptor = new Acceptor(semaphore, this.port);
        this.acceptor.start();
        semaphore.pass(3000L);
        if (this.bindProblem) {
            throw new BindException("Something else may be serving on the command channel socket");
        }
        this.sleep(10);
    }

    private void processCommand() {
        Object object;
        String string = (String)this.commandInProgress.elementAt(0);
        if (!string.startsWith(COMMAND_PREFIX)) {
            throw new RuntimeException("Bad command, didn't start with cmd: ");
        }
        String string2 = string.substring(COMMAND_PREFIX.length());
        Command command = new Command(string2);
        for (int i = 1; i < this.commandInProgress.size(); ++i) {
            object = (String)this.commandInProgress.elementAt(i);
            command.addProperty((String)object);
        }
        EmulatorCommandListener emulatorCommandListener = (EmulatorCommandListener)this.listeners.get(command);
        if (emulatorCommandListener == null) {
            emulatorCommandListener = (EmulatorCommandListener)this.listeners.get(string2);
        }
        object = null;
        if (emulatorCommandListener != null) {
            object = emulatorCommandListener.processCommand(command);
        }
        if (object == null) {
            object = command;
        }
        this.echo((Command)object);
        this.commandInProgress.setSize(0);
    }

    public void addListener(String string, EmulatorCommandListener emulatorCommandListener) {
        this.listeners.put(string, emulatorCommandListener);
    }

    public void addListener(Command command, EmulatorCommandListener emulatorCommandListener) {
        this.listeners.put(command, emulatorCommandListener);
    }

    public boolean isPaused() {
        return this.pause;
    }

    public String getActiveMeasurement() {
        return this.activeMeasurement;
    }

    public boolean inSingleMode() {
        return this.single;
    }

    public void sendSampleMessages() {
        this.sendMessages = true;
    }

    public void dieDieDie() throws InterruptedException {
        this.acceptor.die();
    }

    public synchronized void echo(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.print(stringArray[i] + "\n");
            this.out.flush();
        }
    }

    public void echo(Command command) {
        if (!command.propertyExists("topic") && command.getName().equals("set")) {
            command.addProperty("topic", "display.global");
        }
        KeyValuePair[] keyValuePairArray = command.getProperties();
        String[] stringArray = new String[keyValuePairArray.length + 2];
        stringArray[0] = COMMAND_PREFIX + command.getName();
        for (int i = 0; i < keyValuePairArray.length; ++i) {
            KeyValuePair keyValuePair = keyValuePairArray[i];
            stringArray[i + 1] = keyValuePair.getKey() + ": " + keyValuePair.getValue();
        }
        stringArray[stringArray.length - 1] = "";
        this.echo(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface EmulatorCommandListener {
        public Command processCommand(Command var1);
    }

    private class Acceptor
    extends Thread {
        private final int serverPort;
        private ServerSocket serverSocket;
        private Socket socket;
        private Semaphore serverSocketReadySemaphore;
        private boolean connected = true;

        public Acceptor(Semaphore semaphore, int n) {
            super(CommandChannelEmulator.this.name);
            this.serverSocketReadySemaphore = semaphore;
            this.serverPort = n;
        }

        private void maybeSendAMessage() {
            int n;
            if (CommandChannelEmulator.this.sendMessages && (n = (int)(System.currentTimeMillis() % 10000L)) < 10) {
                String[] stringArray = new String[]{"spectrumLoading", "spectrumMeasuring"};
                CommandChannelEmulator.this.echo(new String[]{"cmd: showMsg", "key: " + stringArray[n %= stringArray.length], ""});
                if (logger.isInfoEnabled()) {
                    logger.info("sending message: " + stringArray[n]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block25: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Acceptor.run() binding to port");
                    }
                    this.serverSocket = new ServerSocket(this.serverPort);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Acceptor.run() bound to port");
                    }
                    try {
                        try {
                            BufferedReader bufferedReader;
                            Object object = CommandChannelEmulator.this;
                            synchronized (object) {
                                this.serverSocketReadySemaphore.release();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Acceptor.run() accepting connection...");
                                }
                                this.socket = this.serverSocket.accept();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Acceptor.run() connected");
                                }
                                bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "US-ASCII"));
                                CommandChannelEmulator.this.out = new PrintWriter(this.socket.getOutputStream());
                            }
                            while (this.connected) {
                                if (bufferedReader.ready()) {
                                    object = bufferedReader.readLine();
                                    if (((String)object).equals("cmd: get")) {
                                        if (logger.isDebugEnabled()) {
                                            logger.debug("[cmd: get] ----| converted to |----> [cmd: set]");
                                        }
                                        object = "cmd: set";
                                    }
                                    if (((String)object).length() == 0) {
                                        CommandChannelEmulator.this.processCommand();
                                        continue;
                                    }
                                    CommandChannelEmulator.this.commandInProgress.addElement(object);
                                    continue;
                                }
                                this.maybeSendAMessage();
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    this.connected = false;
                                }
                            }
                            Object var5_7 = null;
                            if (this.socket == null) break block25;
                        }
                        catch (BindException bindException) {
                            System.err.println("BindException in CommandChannelEmulator - do you already have a CommandChannelEmulator running?");
                            CommandChannelEmulator.this.bindProblem = true;
                            Object var5_8 = null;
                            if (this.socket != null) {
                                this.socket.close();
                            }
                            this.serverSocket.close();
                            return;
                        }
                        catch (IOException iOException) {
                            if (iOException.getMessage().indexOf("Socket closed") < 0) {
                                System.err.println("CommandChannelEmulator stumbled on some IO stuff: " + iOException);
                            }
                            Object var5_9 = null;
                            if (this.socket != null) {
                                this.socket.close();
                            }
                            this.serverSocket.close();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        if (this.socket != null) {
                            this.socket.close();
                        }
                        this.serverSocket.close();
                        throw throwable;
                    }
                    this.socket.close();
                }
                this.serverSocket.close();
                return;
            }
            catch (IOException iOException) {
                System.err.println("trouble opening/closing ServerSocket in CommandChannelEmulator for port: " + this.serverPort);
                iOException.printStackTrace(System.err);
            }
        }

        void die() {
            this.connected = false;
            try {
                if (this.isAlive()) {
                    this.join(20000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isAlive()) {
                throw new RuntimeException("Acceptor thread didn't die");
            }
        }
    }

    private class GetStateListListener
    implements EmulatorCommandListener {
        private GetStateListListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setStateList");
            String string = "Liberty Lake CDMA analyzer";
            command2.addProperty("current", string);
            command2.addProperty("config", "Coeur d'Alene spectrum analyzer");
            command2.addProperty("config", string);
            command2.addProperty("config", "Downtown Spokane at I-90 chan scan");
            return command2;
        }
    }

    private class InstalledOptionsListener
    implements EmulatorCommandListener {
        private InstalledOptionsListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setOptionList");
            command2.addProperty("option1", "200");
            command2.addProperty("key1", "xxxSTUBxxx");
            command2.addProperty("option2", "210");
            command2.addProperty("key2", "xxxSTUBxxx");
            command2.addProperty("option22", "220");
            command2.addProperty("key22", "xxxSTUBxxx");
            command2.addProperty("option23", "230");
            command2.addProperty("key23", "xxxSTUBxxx");
            command2.addProperty("option24", "240");
            command2.addProperty("key24", "xxxSTUBxxx");
            command2.addProperty("option25", "300");
            command2.addProperty("key25", "xxxSTUBxxx");
            command2.addProperty("option3", "500");
            command2.addProperty("key3", "xxxSTUBxxx");
            command2.addProperty("option4", "510");
            command2.addProperty("key4", "xxxSTUBxxx");
            command2.addProperty("option5", "600");
            command2.addProperty("key5", "xxxSTUBxxx");
            command2.addProperty("option56", "700");
            command2.addProperty("key56", "xxxSTUBxxx");
            command2.addProperty("option57", "710");
            command2.addProperty("key57", "xxxSTUBxxx");
            return command2;
        }
    }

    private class AddOptionListener
    implements EmulatorCommandListener {
        private AddOptionListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("addOption");
            command2.addProperty("option", command.getProperty("option"));
            command2.addProperty("key", command.getProperty("key"));
            command2.addProperty("status", "ok");
            return command2;
        }
    }

    private class BatteryStatusListener
    implements EmulatorCommandListener {
        private BatteryStatusListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setBatteryStatus");
            return command2;
        }
    }

    private class VersionInfoListener
    implements EmulatorCommandListener {
        private VersionInfoListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setVersionInfo");
            command2.addProperty("cmp1", "Pm_DSP");
            command2.addProperty("ver1", "A23432-55 Beta");
            command2.addProperty("cmp2", "Pm_BoardRev");
            command2.addProperty("ver2", "0.90358");
            command2.addProperty("cmp3", "RcvrFwRev");
            command2.addProperty("ver3", "1111111111");
            command2.addProperty("cmp5", "T1_FwVer");
            command2.addProperty("ver5", "1.1.8");
            command2.addProperty("cmp6", "RcvrBootRev");
            command2.addProperty("ver6", "1.6.2.3.4.5.8.7.1");
            command2.addProperty("cmp7", "GPS_DSPRev");
            command2.addProperty("ver7", "1.0");
            Properties properties = System.getProperties();
            String string = "revision.";
            int n = 1024;
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                String string3 = string2.substring(string.length());
                String string4 = properties.getProperty(string2);
                command2.addProperty("cmp" + n, string3);
                command2.addProperty("ver" + n, string4);
            }
            return command2;
        }
    }

    private class HardwareFeaturesListener
    implements EmulatorCommandListener {
        private HardwareFeaturesListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setHwFeatures");
            command2.addProperty("extRefFreqMask", 0L);
            command2.addProperty("dcBiasTeeHw", 1L);
            command2.addProperty("dtfFloor", -80000L);
            command2.addProperty("rlFloor", -80000L);
            return command2;
        }
    }

    private class GetSystemIdListener
    implements EmulatorCommandListener {
        private GetSystemIdListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setSystemId");
            command2.addProperty("model", "Unknown");
            command2.addProperty("serialNum", "123stub456");
            command2.addProperty("hostId", "800-555-STUB");
            return command2;
        }
    }

    private class GetLicenseInfoListener
    implements EmulatorCommandListener {
        private GetLicenseInfoListener() {
        }

        public Command processCommand(Command command) {
            Command command2 = new Command("setLicenseInfo");
            return command2;
        }
    }

    private class SetActiveListener
    implements EmulatorCommandListener {
        private SetActiveListener() {
        }

        public Command processCommand(Command command) {
            String string = command.getProperty("meas");
            if (logger.isInfoEnabled()) {
                logger.info("Setting active measurement: " + string);
            }
            CommandChannelEmulator.this.activeMeasurement = string;
            return null;
        }
    }

    private class SingleListener
    implements EmulatorCommandListener {
        private SingleListener() {
        }

        public Command processCommand(Command command) {
            new DelaySendingSingle().start();
            return null;
        }

        private class DelaySendingSingle
        extends Thread {
            private DelaySendingSingle() {
            }

            public void run() {
                try {
                    Thread.sleep(1200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CommandChannelEmulator.this.single = true;
            }
        }
    }

    private class ResumeListener
    implements EmulatorCommandListener {
        private ResumeListener() {
        }

        public Command processCommand(Command command) {
            CommandChannelEmulator.this.pause = false;
            CommandChannelEmulator.this.single = false;
            return null;
        }
    }

    private class PauseListener
    implements EmulatorCommandListener {
        private PauseListener() {
        }

        public Command processCommand(Command command) {
            CommandChannelEmulator.this.pause = true;
            return null;
        }
    }
}

