/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.commChannel.HardwareEventListener;
import elgato.infrastructure.commChannel.SetCommandDispatcher;
import elgato.infrastructure.commChannel.UDPMeasurementReader;
import elgato.infrastructure.mainScreens.CautionErrorMessageScreen;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.ModeScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.StatusHandler;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.LocaleManager;
import elgato.infrastructure.util.LogClient;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkUtils;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Semaphore;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.util.VectorMap;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class DefaultCommandProcessor
implements CommandProcessor {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("elgato.showMsg", LocaleManager.getCurrentLocale());
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$commChannel$DefaultCommandProcessor == null ? (class$elgato$infrastructure$commChannel$DefaultCommandProcessor = DefaultCommandProcessor.class$("elgato.infrastructure.commChannel.DefaultCommandProcessor")) : class$elgato$infrastructure$commChannel$DefaultCommandProcessor);
    private static final String COMMAND_PREFIX = "cmd: ";
    private static final String SET_DATA_CHAN = "setDataChan";
    private static final char EOL = '\n';
    private static final int DEFAULT_RESPONSE_TIMEOUT = 60000;
    public static final int DEFAULT_PORT = 5028;
    private int port;
    private Socket socket;
    private Writer out;
    BufferedReader reader;
    volatile boolean commandListenerRunning;
    VectorMap commandListeners = new VectorMap();
    CommandListener notifyEventListener;
    CommandListener errorEventListener;
    private Vector hardwareFailureListeners = new Vector();
    private CommandListenerThread commandListenerThread;
    private StatusHandler statusHandler;
    private SetCommandDispatcher setCommandDispatcher;
    boolean startupInProcess;
    boolean wakingUp;
    String measurementToLoadAfterStartup;
    private InputStream socketInputStream;
    private Runnable runPushScreen;
    final Vector commandQueue = new Vector();
    static /* synthetic */ Class class$elgato$infrastructure$commChannel$DefaultCommandProcessor;
    static /* synthetic */ Class class$java$lang$Thread;

    public DefaultCommandProcessor() {
        this(Integer.valueOf(System.getProperty("serverPort", String.valueOf(5028))));
    }

    DefaultCommandProcessor(int n) {
        this.port = n;
        this.setCommandDispatcher = new SetCommandDispatcher();
        this.addCommandListener("set", this.setCommandDispatcher);
        this.addCommandListener("setActive", new SetActiveCommandDispatcher());
        this.addCommandListener("notifyEvent", new NotifyEventCommandDispatcher());
        this.addCommandListener("cmdError", new ErrorEventCommandDispatcher());
        this.addCommandListener("showMsg", new ShowMsgCommandListener());
        this.addCommandListener("remote", new RemoteCommandListener());
        this.addCommandListener("local", new LocalCommandListener());
    }

    public void addHardwareFailureListener(HardwareEventListener hardwareEventListener) {
        this.hardwareFailureListeners.addElement(hardwareEventListener);
    }

    public void removeHardwareFailureListener(HardwareEventListener hardwareEventListener) {
        this.hardwareFailureListeners.removeElement(hardwareEventListener);
    }

    void notifyHardwareFailListeners() {
        for (int i = 0; i < this.hardwareFailureListeners.size(); ++i) {
            ((HardwareEventListener)this.hardwareFailureListeners.elementAt(i)).hardwareFailed();
        }
    }

    protected Screen createErrorMessageScreen(String string) {
        return new CautionErrorMessageScreen(string);
    }

    protected void showMessageScreen(final Screen screen) {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                MeasurementFactory.instance().getScreenManager().pushScreen(screen);
            }
        }, this.getClass().getName() + ".commandReceived");
    }

    boolean handledAsActionableMessage(Command command) {
        String string = command.getProperty("key");
        if (string == null) {
            return false;
        }
        if (string.equals("warningSuspectedGuiHang") && UDPMeasurementReader.isReceiveInProcess()) {
            logger.warn("Suspected GUI hang received while waiting for a packet, re-sending readyToReceive");
            this.readyToReceive();
            return true;
        }
        return false;
    }

    void processCommand(Command command) {
        Vector vector = (Vector)this.commandListeners.getItems(command.getName()).clone();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CommandListener commandListener = (CommandListener)vector.elementAt(i);
                try {
                    commandListener.commandReceived(command);
                    continue;
                }
                catch (Exception exception) {
                    logger.error("Command listener threw exception; proceeding to notify other listeners", exception);
                }
            }
        }
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean isStartupComplete() {
        return !this.startupInProcess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        try {
            while (true) {
                try {
                    this.socket = new Socket(NetworkUtils.getServerAddress(), this.port);
                }
                catch (ConnectException connectException) {
                    logger.warn("Couldn't connect to server, trying again...");
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                break;
            }
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.socketInputStream = this.socket.getInputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.socketInputStream));
            this.startupCommandListener();
            this.getSetStartupInfo();
            this.sendQueuedCommands();
            return;
        }
        catch (IOException iOException) {
            logger.error("Unxpected IOException while connecting in DefaultCommandProcessor", iOException);
            throw new RuntimeException("Unxpected IOException while connecting in DefaultCommandProcessor");
        }
    }

    private synchronized void startupCommandListener() {
        try {
            this.startupInProcess();
            this.startCommandListenerThread();
        }
        catch (IOException iOException) {
            logger.error("Unxpected IOException when startCommandListenerThread in DefaultCommandProcessor", iOException);
            throw new RuntimeException("Unxpected IOException when startCommandListenerThread in DefaultCommandProcessor");
        }
    }

    public void setActive(String string) {
        if (string == null) {
            throw new IllegalArgumentException("measurementName is null");
        }
        this.send(Command.makeSetActiveCommand(string));
    }

    public void setInactive() {
        this.send("setActive");
    }

    public void set(String string, String string2, long l) {
        Command command = Command.makeSetCommand(string);
        command.addProperty(string2, l);
        this.send(command);
    }

    public void set(String string, String string2, String string3) {
        Command command = Command.makeSetCommand(string);
        command.addProperty(string2, string3);
        this.send(command);
    }

    public void sendPauseCommand() {
        this.send("pause");
    }

    public void sendResumeCommand() {
        this.send("resume");
    }

    public void sendSingleCommand() {
        this.send("single");
    }

    public void readyToReceive() {
        if (logger.isDebugEnabled()) {
            logger.debug("DefaultCommandProcessor.readyToReceive");
        }
        this.send("readytoReceive");
    }

    public void setDataChannel(String string, int n) {
        Command command = new Command(SET_DATA_CHAN);
        command.addProperty("address", string);
        command.addProperty("port", n);
        command.addProperty("type", "udp");
        this.send(command);
    }

    public void addSetCommandListener(String string, CommandListener commandListener) {
        this.setCommandDispatcher.addSetCommandListener(string, commandListener);
    }

    public void removeSetCommandListener(String string, CommandListener commandListener) {
        this.setCommandDispatcher.removeSetCommandListener(string, commandListener);
    }

    public void setNotifyEventListener(CommandListener commandListener) {
        this.notifyEventListener = commandListener;
    }

    public void setErrorEventListener(CommandListener commandListener) {
        this.errorEventListener = commandListener;
    }

    public void send(String string) {
        this.send(new Command(string));
    }

    public synchronized void send(Command command) {
        if (this.dontSendSetActive() && command.getName().equals("setActive")) {
            if (logger.isDebugEnabled()) {
                logger.debug("send(" + command.getName() + ") IGNORED BECAUSE WE'RE IN STARTUP MODE");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            String string = command.getProperty("topic");
            if (string == null) {
                logger.debug("send(" + command.getName() + ")");
            } else {
                logger.debug("send(" + command.getName() + ", " + string + ")");
            }
        }
        LogClient.log(command.toString());
        this.sendNowOrQueue(command);
        if (command.getName().equals("recall")) {
            if (logger.isDebugEnabled()) {
                logger.debug("send() sending recall command: entering startupInProgress state");
            }
            this.startupInProcess();
        }
    }

    public Command call(Command command, String string) throws CommandTimeoutException, InterruptedException {
        return this.call(command, string, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command call(Command command, String string, long l) throws CommandTimeoutException, InterruptedException {
        ResponseGrabber responseGrabber = new ResponseGrabber(l);
        this.addCommandListener(string, responseGrabber);
        try {
            this.send(command);
            Command command2 = responseGrabber.get();
            return command2;
        }
        finally {
            this.removeCommandListener(string, responseGrabber);
        }
    }

    protected void startCommandListenerThread() throws IOException {
        if (this.commandListenerThread == null) {
            this.commandListenerThread = new CommandListenerThread();
            this.commandListenerRunning = true;
            this.commandListenerThread.start();
            this.commandListenerThread.startupSemaphore.pass(5000L);
        }
    }

    private void sendNowOrQueue(Command command) {
        if (this.isCommandSendableNow(command)) {
            this.sendNow(command);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("not connected so queueing command = " + command.getName());
            }
            this.commandQueue.addElement(command);
        }
    }

    private boolean isCommandSendableNow(Command command) {
        if (!this.isConnected()) {
            return false;
        }
        if (!this.isStartupComplete()) {
            if (command.getName().equals(SET_DATA_CHAN)) {
                return true;
            }
            if (command.getName().equals("getLicenses")) {
                return true;
            }
            if (command.getName().equals("getHwFeatures")) {
                return true;
            }
            return command.getName().equals("getSystemId");
        }
        return true;
    }

    public void addCommandListener(String string, CommandListener commandListener) {
        this.commandListeners.addItem(string, commandListener);
    }

    public void removeCommandListener(String string, CommandListener commandListener) {
        this.commandListeners.removeItem(string, commandListener);
    }

    void shutDown() {
        this.stopCommandListener();
        this.close();
    }

    public void stopCommandListener() {
        this.commandListenerRunning = false;
    }

    static void stopThread(Thread thread) {
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = DefaultCommandProcessor.class$("java.lang.Thread")) : class$java$lang$Thread).getDeclaredMethod("stop", new Class[0]);
            method.invoke((Object)thread, null);
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't stop thread: " + exception);
        }
    }

    void startupInProcess() {
        logger.info("STATUS: Startup in process...");
        if (!this.startupInProcess) {
            this.startupInProcess = true;
            this.loadStartupSplashScreen(false);
        }
    }

    synchronized void startupComplete() {
        logger.info("STATUS: Startup complete.");
        this.startupInProcess = false;
        this.sendQueuedCommands();
        MeasurementSettings.makeAllMeasurementSettingsInvalid();
        TimeFreqRefMeasurementSettings.instance().refresh();
        this.showProperScreen();
    }

    void loadStartupSplashScreen(final boolean bl) {
        final ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
        final StartupSplashScreen startupSplashScreen = new StartupSplashScreen();
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    screenManager.pushScreen(startupSplashScreen);
                } else {
                    screenManager.loadScreen(startupSplashScreen);
                }
            }
        };
        EventDispatchThread.invokeLater(runnable, this.getClass().getName() + ".commandReceived");
    }

    void showProperScreen() {
        Screen screen;
        if (this.measurementToLoadAfterStartup == null || this.startupInProcess) {
            return;
        }
        final ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
        if (this.measurementToLoadAfterStartup.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("showProperScreen() loading mode screen");
            }
            screen = new ModeScreen();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("showProperScreen() loading screen for: " + this.measurementToLoadAfterStartup);
            }
            screen = MeasurementFactory.instance().getScreenForMeasurementType(this.measurementToLoadAfterStartup);
        }
        this.measurementToLoadAfterStartup = null;
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultCommandProcessor.this.assertSplashScreenIsCurrentScreen(screenManager);
                screenManager.loadScreen(screen);
            }
        };
        EventDispatchThread.invokeLater(runnable, this.getClass().getName() + ".showProperScreen");
    }

    void assertSplashScreenIsCurrentScreen(ScreenManager screenManager) {
        if (!(screenManager.getCurrentScreen() instanceof StartupSplashScreen)) {
            logger.error("some other screen [" + screenManager.getCurrentScreen().getClass().getName() + "] pushed on top of startup message screen!!!");
        }
    }

    private void getSetStartupInfo() {
        MeasurementFactory measurementFactory = MeasurementFactory.instance();
        measurementFactory.retrieveSystemId();
        measurementFactory.setLicensesAndWorkingHardware();
        measurementFactory.retrieveRevisionInfo();
        measurementFactory.retrieveHardwareFeatures();
        TimeFreqRefMeasurementSettings.instance().setValidHardwareFeatures();
        if (measurementFactory.measurementAvailable("source")) {
            SigGenMeasurementSettings.instance().setValidModulationFormats();
        }
    }

    public static String formatResponseCommandAsMessage(Command command, String string) {
        String string2 = command.getProperty(string);
        String string3 = "";
        if (string2 == null) {
            logger.error("showMsg command is missing key");
        } else {
            String string4 = null;
            try {
                string4 = bundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                logger.error("showMsg command - could not find resource: " + string2);
            }
            if (string4 != null) {
                Object object;
                Vector<Object[]> vector = new Vector<Object[]>();
                boolean bl = false;
                int n = 1;
                while (!bl) {
                    object = command.getProperty("value" + n);
                    if (object == null) {
                        bl = true;
                        continue;
                    }
                    vector.addElement((Object[])object);
                    ++n;
                }
                object = new String[vector.size()];
                vector.copyInto((Object[])object);
                string3 = UIHelper.formatMessage(string4, (String[])object);
            }
        }
        return string3;
    }

    void setStatus(String string) {
        if (this.statusHandler == null) {
            logger.error("received showMsg but statusBar is null");
        } else {
            this.statusHandler.setStatus(string);
        }
    }

    String getValue(String string) {
        int n = string.indexOf(58);
        return string.substring(n + 1).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            logger.error("tried to shutDown closed print writer", iOException);
        }
        finally {
            this.out = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            logger.error("tried to shutDown closed socket", iOException);
        }
        finally {
            this.socket = null;
        }
        try {
            Thread.sleep(150L);
            if (this.commandListenerThread.isAlive()) {
                DefaultCommandProcessor.stopThread(this.commandListenerThread);
                this.commandListenerThread.join(5000L);
                if (this.commandListenerThread.isAlive()) {
                    logger.error("Warning: command listener thread didn't die", new RuntimeException());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean dontSendSetActive() {
        return this.startupInProcess || this.measurementToLoadAfterStartup != null;
    }

    protected boolean isConnected() {
        return this.socket != null;
    }

    private void sendQueuedCommands() {
        int n = 0;
        while (n < this.commandQueue.size()) {
            Command command = (Command)this.commandQueue.elementAt(n);
            if (this.isCommandSendableNow(command)) {
                this.sendNow(command);
                this.commandQueue.removeElementAt(n);
                continue;
            }
            ++n;
        }
    }

    protected void sendNow(Command command) {
        KeyValuePair[] keyValuePairArray = command.getProperties();
        String[] stringArray = new String[keyValuePairArray.length];
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 0; i < keyValuePairArray.length; ++i) {
            stringBuffer.setLength(0);
            stringBuffer.append(keyValuePairArray[i].getKey());
            stringBuffer.append(": ");
            stringBuffer.append(keyValuePairArray[i].getValue());
            stringArray[i] = stringBuffer.toString();
        }
        this.doSend(command.getName(), stringArray);
    }

    private void doSend(String string, String[] stringArray) {
        try {
            this.out.write(COMMAND_PREFIX);
            this.out.write(string);
            this.out.write(10);
            if (logger.isDebugEnabled()) {
                logger.debug("doSend(" + string + ") {");
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.out.write(stringArray[i]);
                    this.out.write(10);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("    " + stringArray[i]);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("}");
            }
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException iOException) {
            logger.error("Error detected while sending command: " + string, iOException);
        }
    }

    public void sendSystemIdCommand(CommandListener commandListener) {
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        commandProcessor.addCommandListener("setSystemId", commandListener);
        commandProcessor.send(new Command("getSystemId"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ResponseGrabber
    implements CommandListener {
        private final long timeout;
        private Command grabbedCommand;

        public ResponseGrabber(long l) {
            this.timeout = l;
        }

        public synchronized void commandReceived(Command command) {
            this.grabbedCommand = command;
            this.notifyAll();
        }

        public synchronized Command get() throws CommandTimeoutException, InterruptedException {
            long l = this.timeout;
            long l2 = System.currentTimeMillis() + this.timeout;
            while (this.grabbedCommand == null && l > 0L) {
                this.wait(l);
                l = l2 - System.currentTimeMillis();
            }
            if (this.grabbedCommand == null) {
                throw new CommandTimeoutException("Response not received");
            }
            return this.grabbedCommand;
        }
    }

    private static class SocketLostException
    extends IOException {
        private SocketLostException() {
        }
    }

    private class CommandListenerThread
    extends Thread {
        Semaphore startupSemaphore = new Semaphore();

        public CommandListenerThread() {
            super("CommandListenerThread");
        }

        public void run() {
            this.startupSemaphore.release();
            while (DefaultCommandProcessor.this.commandListenerRunning) {
                try {
                    try {
                        String string = this.readLine();
                        if (string.length() <= 0) continue;
                        if (!string.startsWith(DefaultCommandProcessor.COMMAND_PREFIX)) {
                            logger.error("CommandListener: Received unexpected command string: " + string, new RuntimeException());
                            continue;
                        }
                        Command command = new Command(DefaultCommandProcessor.this.getValue(string));
                        while ((string = this.readLine()).length() > 0) {
                            command.addProperty(string);
                        }
                        if (!DefaultCommandProcessor.this.commandListenerRunning) break;
                        if (logger.isDebugEnabled()) {
                            logger.debug("CommandListener: Received command " + command);
                        }
                        DefaultCommandProcessor.this.processCommand(command);
                    }
                    catch (SocketLostException socketLostException) {
                        if (!DefaultCommandProcessor.this.commandListenerRunning) break;
                        this.connectionLost();
                        break;
                    }
                }
                catch (Exception exception) {
                    logger.error("CommandListener: Unexpected Exception caught when reading command", exception);
                }
            }
            logger.info("CommandListener: stopped.");
        }

        private String readLine() throws SocketLostException {
            String string;
            try {
                string = DefaultCommandProcessor.this.reader.readLine();
            }
            catch (IOException iOException) {
                logger.error("Unexpected IO Exception caught and transformed to SocketLostException", iOException);
                throw new SocketLostException();
            }
            if (string == null) {
                return "";
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CommandListener: read line: '" + string + "'");
            }
            return string;
        }

        private void connectionLost() {
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            if (screenManager != null) {
                String string = RuntimeConfiguration.isEmbedded() ? Text.SERVER_DEATH_HTML_MESSAGE_CONSOLE : Text.SERVER_DEATH_HTML_MESSAGE_NETWORK;
                MessageScreen messageScreen = new MessageScreen(string, true, 4);
                messageScreen.setEscapePopsScreen(false);
                DefaultCommandProcessor.this.runPushScreen = new Runnable(this, screenManager, messageScreen){
                    private final /* synthetic */ ScreenManager val$screenManager;
                    private final /* synthetic */ MessageScreen val$messageScreen;
                    private final /* synthetic */ CommandListenerThread this$1;
                    {
                        this.this$1 = commandListenerThread;
                        this.val$screenManager = screenManager;
                        this.val$messageScreen = messageScreen;
                    }

                    public void run() {
                        this.val$screenManager.pushScreen(this.val$messageScreen);
                    }
                };
                EventDispatchThread.invokeLater(DefaultCommandProcessor.this.runPushScreen, this.getClass().getName() + ".connectionLost");
            } else {
                logger.warn("Connection to server lost (no ScreenManager registered)");
            }
            DefaultCommandProcessor.this.close();
        }
    }

    private class SetActiveCommandDispatcher
    implements CommandListener {
        private SetActiveCommandDispatcher() {
        }

        public void commandReceived(Command command) {
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            boolean bl = screenManager.isLocal();
            String string = command.getProperty("meas");
            if (logger.isDebugEnabled()) {
                logger.debug("SetActiveCommandDispatcher.commandReceived() local=" + bl + " startupInProcess=" + DefaultCommandProcessor.this.startupInProcess + " meas=" + string);
            }
            if (!bl || DefaultCommandProcessor.this.startupInProcess) {
                if (string == null) {
                    string = "";
                }
                DefaultCommandProcessor.this.measurementToLoadAfterStartup = string;
                DefaultCommandProcessor.this.showProperScreen();
            }
        }
    }

    private class LocalCommandListener
    implements CommandListener {
        private LocalCommandListener() {
        }

        public void commandReceived(Command command) {
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            screenManager.setLocalEnabled(true);
        }
    }

    private class RemoteCommandListener
    implements CommandListener {
        private RemoteCommandListener() {
        }

        public void commandReceived(Command command) {
            ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
            screenManager.setLocalEnabled(false);
        }
    }

    private class ShowMsgCommandListener
    implements CommandListener {
        private ShowMsgCommandListener() {
        }

        public void commandReceived(Command command) {
            if (DefaultCommandProcessor.this.handledAsActionableMessage(command)) {
                return;
            }
            DefaultCommandProcessor.this.setStatus(DefaultCommandProcessor.formatResponseCommandAsMessage(command, "key"));
        }
    }

    private class ErrorEventCommandDispatcher
    implements CommandListener {
        private final String deviceNotAvailableString = "errorDevNotAvailable";

        private ErrorEventCommandDispatcher() {
        }

        public void commandReceived(Command command) {
            if (DefaultCommandProcessor.this.errorEventListener != null) {
                DefaultCommandProcessor.this.errorEventListener.commandReceived(command);
            } else if (this.checkForHardwareFailure(command, "errKey")) {
                logger.error("hardware not available");
                DefaultCommandProcessor.this.notifyHardwareFailListeners();
            } else if (RuntimeConfiguration.showMessagesOnError()) {
                MessageScreen messageScreen = MessageScreen.createRebootMessageScreen(command, DefaultCommandProcessor.formatResponseCommandAsMessage(command, "errKey"));
                DefaultCommandProcessor.this.showMessageScreen(messageScreen);
            }
        }

        private boolean checkForHardwareFailure(Command command, String string) {
            String string2 = command.getProperty(string);
            if ("errorDevNotAvailable".equals(string2)) {
                MeasurementFactory.instance().removeHardwareFromList(command.getProperty("errTopic"));
                return true;
            }
            return false;
        }
    }

    class StartupSplashScreen
    extends Screen {
        StartupSplashScreen() {
        }

        public void installScreen(ScreenManager screenManager) {
            screenManager.getRightMenuPanel().clear();
            screenManager.getLeftMenuPanel().clear();
            ModalKeyManager modalKeyManager = new ModalKeyManager(screenManager);
            modalKeyManager.setEscapePopsScreen(false);
            GlobalKeyManager.registerInstance(modalKeyManager);
            screenManager.installDisplay(ModeScreen.getSplashScreen());
        }

        public void uninstallScreen(ScreenManager screenManager) {
            GlobalKeyManager.makeInstance(screenManager);
        }
    }

    private class NotifyEventCommandDispatcher
    implements CommandListener {
        private NotifyEventCommandDispatcher() {
        }

        public void commandReceived(Command command) {
            String string = command.getProperty("event");
            if ("startupInProcess".equals(string) && !DefaultCommandProcessor.this.wakingUp) {
                DefaultCommandProcessor.this.startupInProcess();
            } else if ("startupComplete".equals(string) && !DefaultCommandProcessor.this.wakingUp) {
                DefaultCommandProcessor.this.startupComplete();
            } else if ("awakeFromSleepStart".equals(string)) {
                DefaultCommandProcessor.this.wakingUp = true;
                Platform.setDisplayBrightness(0);
                DefaultCommandProcessor.this.loadStartupSplashScreen(true);
            } else if ("awakeFromSleepComplete".equals(string)) {
                DefaultCommandProcessor.this.wakingUp = false;
                EventDispatchThread.invokeLater(new Runnable(this){
                    private final /* synthetic */ NotifyEventCommandDispatcher this$1;
                    {
                        this.this$1 = notifyEventCommandDispatcher;
                    }

                    public void run() {
                        ScreenManager screenManager = MeasurementFactory.instance().getScreenManager();
                        NotifyEventCommandDispatcher.access$600(this.this$1).assertSplashScreenIsCurrentScreen(screenManager);
                        screenManager.popScreen();
                    }
                }, string);
            } else if ("pwrMeterFailure".equals(string)) {
                logger.error("Command Processor received pwrMeterFailure");
                MeasurementFactory.instance().removeHardwareFromList("pwrMeter");
                DefaultCommandProcessor.this.notifyHardwareFailListeners();
            } else if ("e1Failure".equals(string)) {
                logger.error("Command Processor received e1Failure");
                MeasurementFactory.instance().removeHardwareFromList("e1Analyzer");
                DefaultCommandProcessor.this.notifyHardwareFailListeners();
            } else if ("t1Failure".equals(string)) {
                logger.error("Command Processor received t1Failure");
                MeasurementFactory.instance().removeHardwareFromList("t1Analyzer");
                DefaultCommandProcessor.this.notifyHardwareFailListeners();
            } else if ("rcvrFailure".equals(string)) {
                logger.error("Command Processor received rcvrFailure");
                MeasurementFactory.instance().removeHardwareFromList("cdmaAn");
                MeasurementFactory.instance().removeHardwareFromList("cdmaOa");
                MeasurementFactory.instance().removeHardwareFromList("cdma1xEvdoAn");
                MeasurementFactory.instance().removeHardwareFromList("chScan");
                MeasurementFactory.instance().removeHardwareFromList("antDtf");
                MeasurementFactory.instance().removeHardwareFromList("antGated");
                MeasurementFactory.instance().removeHardwareFromList("antSpInsLoss");
                MeasurementFactory.instance().removeHardwareFromList("antRetLoss");
                MeasurementFactory.instance().removeHardwareFromList("source");
                MeasurementFactory.instance().removeHardwareFromList("spectrum");
                MeasurementFactory.instance().removeHardwareFromList("antInsLoss");
                MeasurementFactory.instance().removeHardwareFromList("umtsAn");
                MeasurementFactory.instance().removeHardwareFromList("adjChan");
                MeasurementFactory.instance().removeHardwareFromList("gsmAn");
                DefaultCommandProcessor.this.notifyHardwareFailListeners();
            } else if ("rppTripped".equals(string)) {
                logger.error("Command Processor received rppTripped");
                if (RuntimeConfiguration.showMessagesOnError()) {
                    Screen screen = DefaultCommandProcessor.this.createErrorMessageScreen(Text.RPP_TRIPPED_TEXT);
                    DefaultCommandProcessor.this.showMessageScreen(screen);
                }
            } else if ("dcOutRppTripped".equals(string)) {
                logger.error("Command Processor received dcOutRppTripped");
                if (RuntimeConfiguration.showMessagesOnError()) {
                    Screen screen = DefaultCommandProcessor.this.createErrorMessageScreen(Text.DC_OUT_RPP_TRIPPED_TEXT);
                    DefaultCommandProcessor.this.showMessageScreen(screen);
                }
            }
            if (DefaultCommandProcessor.this.notifyEventListener != null) {
                DefaultCommandProcessor.this.notifyEventListener.commandReceived(command);
            }
        }

        static /* synthetic */ DefaultCommandProcessor access$600(NotifyEventCommandDispatcher notifyEventCommandDispatcher) {
            return notifyEventCommandDispatcher.DefaultCommandProcessor.this;
        }
    }
}

