/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.FieldListener;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.widgets.WrappedTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FieldSubmitListener
extends FieldListener {
    private final String commandChannelTopic;
    private WrappedTimer timer;

    public FieldSubmitListener(SettingsModel settingsModel, String string, String string2) {
        this(settingsModel, string, string2, 1);
    }

    public FieldSubmitListener(SettingsModel settingsModel, String string, String string2, int n) {
        super(settingsModel, string, n);
        this.commandChannelTopic = string2;
    }

    public static FieldSubmitListener makeGlobalTopicListener(SettingsModel settingsModel, String string, int n) {
        return new FieldSubmitListener(settingsModel, string, "global", n);
    }

    public static FieldSubmitListener makeGlobalTopicListener(SettingsModel settingsModel, String string) {
        return FieldSubmitListener.makeGlobalTopicListener(settingsModel, string, 1);
    }

    public void submit(long l) {
        this.updateModelValue(l);
        this.sendSetCommand(l);
    }

    public void submit(long l, int n) {
        this.updateModelValue(l);
        if (this.timer == null) {
            this.timer = new WrappedTimer(n, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FieldSubmitListener.this.sendSetCommand(FieldSubmitListener.this.getModelValue());
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.setInitialDelay(n);
        this.timer.start();
    }

    private long getModelValue() {
        return this.getModel().getLong(this.getProperty());
    }

    protected void sendSetCommand(long l) {
        Command command = this.makeSetCommand();
        command.addProperty(this.property, l / (long)this.divisor);
        MeasurementFactory.instance().getCommandProcessor().send(command);
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected Command makeSetCommand() {
        return Command.makeSetCommand(this.commandChannelTopic);
    }

    public String getCommandChannelTopic() {
        return this.commandChannelTopic;
    }

    public void sendGetCommand() {
        MeasurementFactory.instance().getCommandProcessor().send(this.makeGetCommand());
    }

    private Command makeGetCommand() {
        String string = this.commandChannelTopic;
        if ("global".equals(this.commandChannelTopic)) {
            string = this.model.getTopic();
        }
        Command command = Command.makeGetCommand(string);
        String string2 = this.model.getString(this.property);
        if (string2 == null) {
            command.addProperty(this.property, 0L);
        } else {
            command.addProperty(this.property, string2);
        }
        return command;
    }
}

