/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.SettingsModel;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.VectorMap;
import java.util.Vector;

class SetCommandDispatcher
implements CommandListener {
    private VectorMap _setCommandListeners = new VectorMap();

    public SetCommandDispatcher() {
        SettingsModel[] settingsModelArray = MeasurementFactory.instance().getAllSettingsModels();
        for (int i = 0; i < settingsModelArray.length; ++i) {
            SettingsModel settingsModel = settingsModelArray[i];
            this.addSetCommandListener(settingsModel.getTopic(), settingsModel);
        }
        this.addSetCommandListener("display.global", new GlobalSetListener(settingsModelArray));
    }

    public void addSetCommandListener(String string, CommandListener commandListener) {
        this._setCommandListeners.addItem(string, commandListener);
    }

    public void removeSetCommandListener(String string, CommandListener commandListener) {
        this._setCommandListeners.removeItem(string, commandListener);
    }

    public void commandReceived(final Command command) {
        final String string = command.getProperty("topic");
        if (string == null) {
            throw new IllegalStateException("don't know how to receive command when topic is null");
        }
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                SetCommandDispatcher.this.notifyAllListenersForTopic(string, command);
            }
        }, "SetCommandDispatcher.commandReceived");
    }

    private void notifyAllListenersForTopic(String string, Command command) {
        Vector vector = this.getAllSetListenersForTopic(string);
        for (int i = 0; i < vector.size(); ++i) {
            CommandListener commandListener = (CommandListener)vector.elementAt(i);
            commandListener.commandReceived(command);
        }
    }

    private void appendAllDisplayListenersForTopic(String string, Vector vector) {
        if (string.startsWith("display.")) {
            String string2 = string.substring("display.".length());
            this.addAll(string2, vector);
        }
    }

    private Vector getAllSetListenersForTopic(String string) {
        Vector vector = new Vector();
        this.addAll(string, vector);
        this.appendAllDisplayListenersForTopic(string, vector);
        return vector;
    }

    private void addAll(String string, Vector vector) {
        Vector vector2 = this.getCommandListeners(string);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(vector2.elementAt(i));
        }
    }

    Vector getCommandListeners(String string) {
        return this._setCommandListeners.getItems(string);
    }

    private class GlobalSetListener
    implements CommandListener {
        public SettingsModel[] _allSettingsModels;

        public GlobalSetListener(SettingsModel[] settingsModelArray) {
            this._allSettingsModels = settingsModelArray;
        }

        public void commandReceived(Command command) {
            for (int i = 0; i < this._allSettingsModels.length; ++i) {
                this._allSettingsModels[i].commandReceived(command);
            }
        }
    }
}

