/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementReader;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.NetworkUtils;
import elgato.infrastructure.util.Semaphore;
import elgato.infrastructure.util.Timer;
import elgato.infrastructure.util.UIHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UDPMeasurementReader
extends MeasurementReader {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$commChannel$UDPMeasurementReader == null ? (class$elgato$infrastructure$commChannel$UDPMeasurementReader = UDPMeasurementReader.class$("elgato.infrastructure.commChannel.UDPMeasurementReader")) : class$elgato$infrastructure$commChannel$UDPMeasurementReader);
    private static final String packetLogBase = System.getProperty("packetLog");
    private static final String serializedMeasurementLogBase = System.getProperty("serializedMeasurementLog");
    public static final int MAX_PACKET_AGING = 500;
    public static final int BEGIN_DATA_MESSAGE_CODE = 0x7FFE7FFE;
    public static final int END_DATA_MESSAGE_CODE = 0x7FFD7FFD;
    private long now;
    private DatagramSocket socket;
    private int port;
    private Semaphore startupSemaphore = new Semaphore();
    private UDPThread udpThread;
    private static int receiveInProcessCount = 0;
    private Runnable runReadyToReceive = new Runnable(){

        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("EventDispatchThread.invokeLater.run: before sending ready to receive");
            }
            UDPMeasurementReader.this.readyToReceive();
            if (logger.isDebugEnabled()) {
                logger.debug("EventDispatchThread.invokeLater.run: after sending ready to receive");
            }
        }
    };
    static /* synthetic */ Class class$elgato$infrastructure$commChannel$UDPMeasurementReader;

    private synchronized void startReceive() {
        ++receiveInProcessCount;
    }

    private synchronized void completeReceive() {
        if (--receiveInProcessCount < 0) {
            receiveInProcessCount = 0;
        }
    }

    public static boolean isReceiveInProcess() {
        return receiveInProcessCount > 0;
    }

    protected void doStart() {
        if (logger.isDebugEnabled()) {
            logger.debug("start()");
        }
        if (this.udpThread != null) {
            logger.warn("MeasurementReader already started");
        }
        this.udpThread = new UDPThread();
        this.udpThread.start();
    }

    void waitForStart() {
        this.startupSemaphore.pass(16000L);
    }

    protected void doStop() {
        if (logger.isDebugEnabled()) {
            logger.debug("stop()");
        }
        if (this.udpThread == null) {
            throw new IllegalStateException("MeasurementReader not started");
        }
        this.udpThread.shutdown();
        this.udpThread = null;
    }

    int getPort() {
        return this.port;
    }

    public void resetDataChannel() {
        this.port = this.socket.getLocalPort();
        if (logger.isInfoEnabled()) {
            logger.info("Bound to UDP port " + this.port);
        }
        CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
        commandProcessor.setDataChannel(NetworkUtils.getLocalAddress().getHostAddress(), this.port);
        commandProcessor.readyToReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPacket(byte[] byArray, DatagramPacket datagramPacket) throws IOException {
        if (packetLogBase != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(packetLogBase + this.now);
            try {
                fileOutputStream.write(byArray, 0, datagramPacket.getLength());
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMeasurement(Measurement measurement) throws IOException {
        if (serializedMeasurementLogBase != null) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializedMeasurementLogBase + this.now)));
            try {
                objectOutputStream.writeObject(measurement);
            }
            finally {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void fireMeasurementReceived(Measurement measurement) {
        super.fireMeasurementReceived(measurement);
    }

    Measurement unpackMeasurement(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3 = dataInputStream.readInt();
        if (n3 != 0x7FFE7FFE) {
            throw new IOException("Invalid Begin Data Message Code " + n3);
        }
        dataInputStream.readShort();
        short s = dataInputStream.readShort();
        String string = this.readString(dataInputStream, 23);
        short s2 = dataInputStream.readShort();
        int n4 = dataInputStream.available() - s2;
        Measurement measurement = null;
        try {
            measurement = MeasurementFactory.instance().createMeasurement(string, dataInputStream);
            this.logMeasurement(measurement);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            logger.error("Error unpacking measurement packet, ignoring: " + throwable);
            throwable.printStackTrace();
        }
        int n5 = dataInputStream.available();
        if (n5 > n4) {
            n2 = n5 - n4;
            for (n = 0; n < n2; ++n) {
                dataInputStream.readByte();
            }
            logger.warn("Extra bytes in data packet, extra data ignored.  Measurement: " + string + ", # extra bytes: " + n2);
        }
        if (s != (n2 = dataInputStream.readShort())) {
            logger.warn("Message Number Check Failed " + s + " != " + n2);
        }
        if ((n = dataInputStream.readInt()) != 0x7FFD7FFD) {
            throw new IOException("Invalid End Data Message Code " + n);
        }
        return measurement;
    }

    private String readString(DataInput dataInput, int n) throws IOException {
        byte by = dataInput.readByte();
        byte[] byArray = new byte[by];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = dataInput.readByte();
        }
        dataInput.skipBytes(n - by);
        return new String(byArray);
    }

    public String toString() {
        return "MeasurementReader(port=" + this.port + ")@" + System.identityHashCode(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UDPThread
    extends Thread {
        private volatile boolean running;
        private Semaphore shutdownSemaphore;
        private Timer unpackTimer = new Timer("UDPMeasurementReader/unpack");
        private Timer fireMeasurementTimer = new Timer("UDPMeasurementReader/fireMeasurement");

        public UDPThread() {
            super("UDPMeasurementReader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            this.shutdownSemaphore = new Semaphore();
            try {
                UDPMeasurementReader.this.socket = null;
                try {
                    UDPMeasurementReader.this.socket = new DatagramSocket();
                    if (logger.isInfoEnabled()) {
                        logger.info("Binding to DatagramSocket");
                    }
                }
                catch (SocketException socketException) {
                    logger.error("Couldn't bind to DatagramSocket.");
                    throw new RuntimeException("Couldn't bind to DatagramSocket.");
                }
                UDPMeasurementReader.this.resetDataChannel();
                byte[] byArray = new byte[8192];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                UDPMeasurementReader.this.startupSemaphore.release();
                while (this.running) {
                    block30: {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("waiting for packet");
                            }
                            UDPMeasurementReader.this.startReceive();
                            UDPMeasurementReader.this.socket.receive(datagramPacket);
                            UDPMeasurementReader.this.completeReceive();
                            if (logger.isDebugEnabled()) {
                                logger.debug("received packet: " + datagramPacket.getLength() + " bytes");
                            }
                            UDPMeasurementReader.this.now = System.currentTimeMillis();
                            UDPMeasurementReader.this.logPacket(byArray, datagramPacket);
                            if (!MeasurementFactory.instance().getCommandProcessor().isStartupComplete()) {
                                logger.warn("Startup not complete, yielding: " + Thread.currentThread().toString());
                                while (!MeasurementFactory.instance().getCommandProcessor().isStartupComplete() && System.currentTimeMillis() - UDPMeasurementReader.this.now < 500L) {
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            if (GlobalKeyManager.isKeyPressInProcess()) {
                                if (logger.isKeyPressEnabled()) {
                                    logger.keyPress("Yield: " + Thread.currentThread().toString());
                                }
                                while (GlobalKeyManager.isKeyPressInProcess()) {
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            if (System.currentTimeMillis() - UDPMeasurementReader.this.now < 500L) {
                                this.unpackTimer.start();
                                byteArrayInputStream.reset();
                                Measurement measurement = null;
                                measurement = UDPMeasurementReader.this.unpackMeasurement(dataInputStream);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("measurement type: " + measurement.getMeasurementTitle());
                                }
                                this.unpackTimer.stop();
                                this.fireMeasurementIfStartupComplete(measurement);
                            } else if (logger.isInfoEnabled()) {
                                logger.info("packet discarded due to processing delay");
                            }
                        }
                        catch (Throwable throwable) {
                            logger.warn("Error reading measurement packet, ignoring: " + throwable);
                            int n = byArray.length - byteArrayInputStream.available();
                            int n2 = datagramPacket.getLength() - n;
                            if (n2 == 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Read entire packet");
                                }
                            } else {
                                logger.warn(n2 + " bytes remaining after reading packet");
                                if (logger.isDebugEnabled()) {
                                    logger.debug("packet length=" + datagramPacket.getLength() + ", position=" + n + "");
                                    logger.debug("packet data: \n" + UIHelper.hexDump(byArray, 0, datagramPacket.getLength()));
                                }
                            }
                            if (receiveInProcessCount <= 0) break block30;
                            UDPMeasurementReader.this.completeReceive();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("before sending ready to receive later");
                    }
                    EventDispatchThread.invokeLater(UDPMeasurementReader.this.runReadyToReceive, "UdpMeasurementReader.readyToReceive");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("after sending ready to receive later");
                }
                logger.debug("UDPThread no longer running");
                Object var9_12 = null;
                this.shutdownSemaphore.release();
                if (logger.isInfoEnabled()) {
                    logger.info("Thread shut down, port " + UDPMeasurementReader.this.port);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.shutdownSemaphore.release();
                if (logger.isInfoEnabled()) {
                    logger.info("Thread shut down, port " + UDPMeasurementReader.this.port);
                }
                throw throwable;
            }
        }

        private void fireMeasurementIfStartupComplete(Measurement measurement) {
            if (MeasurementFactory.instance().getCommandProcessor().isStartupComplete() && measurement.hasCurrentSettings()) {
                this.fireMeasurementTimer.start();
                UDPMeasurementReader.this.fireMeasurementReceived(measurement);
                this.fireMeasurementTimer.stop();
            }
        }

        void shutdown() {
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown()");
            }
            this.running = false;
            UDPMeasurementReader.this.socket.close();
            this.shutdownSemaphore.pass(2000L);
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown() complete");
            }
        }
    }
}

