/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.commChannel;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandProcessor;
import elgato.infrastructure.commChannel.WebplugConversion;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.widgets.WrappedTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WebplugConversions {
    private static final int KILOHERTZ_MULTIPLIER = 1000;
    private static CommandBuffer commandBuffer = new CommandBuffer();

    public static WebplugConversion createGlobal(LongActuator longActuator, String string, String string2) {
        return new GlobalLongConversion(longActuator, string, string2);
    }

    public static WebplugConversion createIdentity(LongActuator longActuator, String string, String string2) {
        return new LongConversion(longActuator, string, string2);
    }

    public static WebplugConversion create(ListActuator listActuator, String string, String string2) {
        return new ListConversion(listActuator, string, string2);
    }

    public static WebplugConversion createKilohertz(LongActuator longActuator, String string, String string2) {
        return new LongConversion(longActuator, string, string2, 1000);
    }

    public static WebplugConversion createGlobalKilohertz(LongActuator longActuator, String string, String string2) {
        return new GlobalLongConversion(longActuator, string, string2, 1000);
    }

    public static WebplugConversion createHectohertz(LongActuator longActuator, String string, String string2) {
        return new LongConversion(longActuator, string, string2, 100);
    }

    public static WebplugConversion createCenterFrequency(LongActuator longActuator, String string, String string2) {
        return new CenterFrequencyConversion(longActuator, string, string2);
    }

    public static WebplugConversion createInject(ListActuator listActuator) {
        return new InjectConversion(listActuator, listActuator.getTopic(), listActuator.getPropertyName());
    }

    public static WebplugConversion createAlarmError(ListActuator listActuator) {
        return new AlarmErrorConversion(listActuator, listActuator.getTopic(), listActuator.getPropertyName());
    }

    public static WebplugConversion create(StringActuator stringActuator, String string, String string2) {
        return new StringConversion(stringActuator, string, string2);
    }

    public static WebplugConversion createNull() {
        return new NullWebplugConversion();
    }

    private static abstract class AbstractWebplugConversion
    implements WebplugConversion {
        private final String topic;
        private final String propertyName;
        private WrappedTimer sendTimer = new WrappedTimer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.doSend();
            }
        });

        protected AbstractWebplugConversion(String string, String string2) {
            this.topic = string;
            this.propertyName = string2;
            this.sendTimer.setRepeats(false);
        }

        public String getTopic() {
            return this.topic;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public final void send() {
            if (this.getTopic() == null) {
                return;
            }
            commandBuffer.addToSendQueue(this);
            if (this.shouldDelaySending() && !RuntimeConfiguration.isUnitTestMode()) {
                this.sendTimer.start();
            } else {
                this.doSend();
            }
        }

        protected void doSend() {
            commandBuffer.flush();
        }

        protected boolean shouldDelaySending() {
            return false;
        }

        protected final Command createSetCommand() {
            return Command.makeSetCommand(this.getTopicForSets());
        }

        public Command buildInitialGet(Command command) {
            this.addCurrentValueToCommand(command);
            return command;
        }

        protected String getTopicForSets() {
            return this.getTopic();
        }

        protected abstract void prepareSetCommand(Command var1);

        protected abstract void addCurrentValueToCommand(Command var1);

        protected static CommandProcessor getCommandProcessor() {
            return MeasurementFactory.instance().getCommandProcessor();
        }

        public abstract /* synthetic */ void receive(Command var1);
    }

    private static class CommandBuffer {
        private final Object NULL = new Object();
        private Hashtable queues = new Hashtable();

        private CommandBuffer() {
        }

        public synchronized void addToSendQueue(AbstractWebplugConversion abstractWebplugConversion) {
            Vector<AbstractWebplugConversion> vector;
            Object object = abstractWebplugConversion.getTopicForSets();
            if (object == null) {
                object = this.NULL;
            }
            if ((vector = (Vector<AbstractWebplugConversion>)this.queues.get(object)) == null) {
                vector = new Vector<AbstractWebplugConversion>();
                this.queues.put(object, vector);
            }
            if (!vector.contains(abstractWebplugConversion)) {
                vector.addElement(abstractWebplugConversion);
            }
        }

        private synchronized Hashtable dumpBuffer() {
            Hashtable hashtable = this.queues;
            this.queues = new Hashtable();
            return hashtable;
        }

        public void flush() {
            Hashtable hashtable = this.dumpBuffer();
            CommandProcessor commandProcessor = MeasurementFactory.instance().getCommandProcessor();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Command command = Command.makeSetCommand(string);
                Vector vector = (Vector)hashtable.get(string);
                for (int i = 0; i < vector.size(); ++i) {
                    AbstractWebplugConversion abstractWebplugConversion = (AbstractWebplugConversion)vector.elementAt(i);
                    abstractWebplugConversion.prepareSetCommand(command);
                }
                commandProcessor.send(command);
            }
        }
    }

    private static class CommandTracker {
        private final Vector sent = new Vector();

        private CommandTracker() {
        }

        public void sending(Object object) {
            this.sent.addElement(object);
        }

        public boolean receiving(Object object) {
            if (this.sent.size() > 0) {
                Object e = this.sent.elementAt(0);
                this.sent.removeElementAt(0);
                if (e.equals(object)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class CenterFrequencyConversion
    extends AbstractWebplugConversion {
        private final LongActuator actuator;
        private final String propertyOffset;
        private final int factor = 1000;
        private final CommandTracker tracker = new CommandTracker();

        public CenterFrequencyConversion(LongActuator longActuator, String string, String string2) {
            super(string, string2);
            this.actuator = longActuator;
            this.propertyOffset = string2 + "Offset";
        }

        protected void prepareSetCommand(Command command) {
            this.addCurrentValueToCommand(command);
            Long l = new Long(this.actuator.longValue());
            this.tracker.sending(l);
        }

        protected void addCurrentValueToCommand(Command command) {
            command.addProperty(this.propertyOffset, this.actuator.longValue() % 1000L);
            command.addProperty(this.getPropertyName(), this.actuator.longValue() / 1000L);
        }

        protected String getTopicForSets() {
            return "global";
        }

        public void receive(Command command) {
            long l;
            long l2;
            long l3;
            if (command.propertyExists(this.getPropertyName()) && this.tracker.receiving(new Long(l3 = (l2 = command.getLong(this.getPropertyName())) * 1000L + (l = command.getLong(this.propertyOffset))))) {
                this.actuator.setValue(l3);
            }
        }

        public String getPropertyOffsetName() {
            return this.propertyOffset;
        }
    }

    private static class AlarmErrorConversion
    extends ListConversion {
        public AlarmErrorConversion(ListActuator listActuator, String string, String string2) {
            super(listActuator, string, string2);
        }

        protected void prepareSetCommand(Command command) {
            command.addProperty("injectState", 0L);
            super.prepareSetCommand(command);
        }
    }

    private static class InjectConversion
    extends ListConversion {
        public InjectConversion(ListActuator listActuator, String string, String string2) {
            super(listActuator, string, string2);
        }

        protected void prepareSetCommand(Command command) {
            command.addProperty("alarmMode", 1L);
            super.prepareSetCommand(command);
        }
    }

    private static class StringConversion
    extends AbstractWebplugConversion {
        private final StringActuator actuator;

        public StringConversion(StringActuator stringActuator, String string, String string2) {
            super(string, string2);
            this.actuator = stringActuator;
        }

        protected void prepareSetCommand(Command command) {
            this.addCurrentValueToCommand(command);
        }

        protected void addCurrentValueToCommand(Command command) {
            command.addProperty(this.getPropertyName(), this.actuator.toString());
        }

        public void receive(Command command) {
            if (command.propertyExists(this.getPropertyName())) {
                this.actuator.setValue(command.getProperty(this.getPropertyName()));
            }
        }
    }

    private static class ListConversion
    extends AbstractWebplugConversion {
        private final ListActuator actuator;
        private final CommandTracker tracker = new CommandTracker();

        public ListConversion(ListActuator listActuator, String string, String string2) {
            super(string, string2);
            this.actuator = listActuator;
        }

        protected boolean shouldDelaySending() {
            return false;
        }

        protected void prepareSetCommand(Command command) {
            this.addCurrentValueToCommand(command);
            this.tracker.sending(command.getProperty(this.getPropertyName()));
        }

        protected void addCurrentValueToCommand(Command command) {
            command.addProperty(this.getPropertyName(), this.actuator.intValue());
        }

        public void receive(Command command) {
            if (command.propertyExists(this.getPropertyName()) && this.tracker.receiving(command.getProperty(this.getPropertyName()))) {
                this.actuator.setValueObject(this.actuator.getValue((int)command.getLong(this.getPropertyName())));
            }
        }
    }

    private static class GlobalLongConversion
    extends LongConversion {
        public GlobalLongConversion(LongActuator longActuator, String string, String string2) {
            this(longActuator, string, string2, 1);
        }

        public GlobalLongConversion(LongActuator longActuator, String string, String string2, int n) {
            super(longActuator, string, string2, n);
        }

        protected String getTopicForSets() {
            return "global";
        }
    }

    public static class LongConversion
    extends AbstractWebplugConversion {
        private final LongActuator actuator;
        private final int factor;
        private final CommandTracker tracker = new CommandTracker();

        protected LongConversion(LongActuator longActuator, String string, String string2) {
            this(longActuator, string, string2, 1);
        }

        protected LongConversion(LongActuator longActuator, String string, String string2, int n) {
            super(string, string2);
            this.actuator = longActuator;
            this.factor = n;
        }

        protected LongActuator getActuator() {
            return this.actuator;
        }

        protected int getFactor() {
            return this.factor;
        }

        protected long sendValue(long l) {
            return l / (long)this.factor;
        }

        protected long receiveValue(long l) {
            return l * (long)this.factor;
        }

        protected void prepareSetCommand(Command command) {
            this.addCurrentValueToCommand(command);
            this.tracker.sending(command.getProperty(this.getPropertyName()));
        }

        protected void addCurrentValueToCommand(Command command) {
            command.addProperty(this.getPropertyName(), this.sendValue(this.actuator.longValue()));
        }

        public void receive(Command command) {
            String string = this.getPropertyName();
            if (command.propertyExists(string) && this.tracker.receiving(command.getProperty(this.getPropertyName()))) {
                this.actuator.setValue(this.receiveValue(command.getLong(string)));
            }
        }
    }

    private static class NullWebplugConversion
    extends AbstractWebplugConversion {
        public NullWebplugConversion() {
            super(null, null);
        }

        protected void doSend() {
        }

        public void receive(Command command) {
        }

        protected void prepareSetCommand(Command command) {
        }

        protected void addCurrentValueToCommand(Command command) {
        }
    }
}

