/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.html;

import elgato.infrastructure.html.HTMLScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class HTMLHelpScreen
extends HTMLScreen {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$html$HTMLHelpScreen == null ? (class$elgato$infrastructure$html$HTMLHelpScreen = HTMLHelpScreen.class$("elgato.infrastructure.html.HTMLHelpScreen")) : class$elgato$infrastructure$html$HTMLHelpScreen);
    private static final Resources helpCodes = Resources.getResources("help.help");
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$html$HTMLHelpScreen == null ? (class$elgato$infrastructure$html$HTMLHelpScreen = HTMLHelpScreen.class$("elgato.infrastructure.html.HTMLHelpScreen")) : class$elgato$infrastructure$html$HTMLHelpScreen).getName());
    private static boolean helpActive = false;
    protected String initialContext;
    private static boolean helpEnabled = true;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLHelpScreen;

    public HTMLHelpScreen(ScreenManager screenManager) {
        super(screenManager);
        this.initialContext = screenManager.getHelpContext();
        this.sessionCacheable = true;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        helpActive = true;
        this.htmlManager.setHTMLFileDir("help/");
        String string = this.mapContext();
        if (this.htmlManager.isCacheRestore()) {
            if (!this.htmlManager.restoreCachedSession()) {
                this.htmlManager.navigateLink(string, this.initialContext);
            }
        } else {
            this.htmlManager.navigateLink(string, this.initialContext);
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        helpActive = false;
        super.uninstallScreen(screenManager);
    }

    protected Menu buildLeftMenu() {
        Menu menu = super.buildLeftMenu();
        menu.setMenuItem(this.makeContentsButton(), 0);
        return menu;
    }

    private String mapContext() {
        try {
            if (this.initialContext == null) {
                return res.getString("topicNotFound");
            }
            String string = new String(this.initialContext);
            String string2 = null;
            int n = 0;
            while (n > -1) {
                try {
                    string2 = helpCodes.getString(string.toString(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2 != null) {
                    return string2;
                }
                n = string.lastIndexOf(".");
                if (n < 0) continue;
                string = string.substring(0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        logger.warn("Could not find help from initial context: " + this.initialContext);
        return res.getString("topicNotFound");
    }

    public static boolean isHelpActive() {
        return helpActive;
    }

    public static boolean isHelpEnabled() {
        return helpEnabled;
    }

    public static void setHelpEnabled(boolean bl) {
        helpEnabled = bl;
    }

    public String getInitialContext() {
        return this.initialContext;
    }

    private MenuItem makeContentsButton() {
        return new PushButton(Text.Help_n_Contents, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLHelpScreen.this.htmlManager.navigateLink(res.getString("contentsPage"));
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

