/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.html;

import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.util.FileHelper;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.TextMessage;
import java.awt.Color;
import java.awt.Graphics;
import java.io.InputStream;
import java.util.Vector;

public class HTMLManager {
    private static final int HISTORY_MAX = 10;
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$html$HTMLManager == null ? (class$elgato$infrastructure$html$HTMLManager = HTMLManager.class$("elgato.infrastructure.html.HTMLManager")) : class$elgato$infrastructure$html$HTMLManager).getName());
    private static final Resources htmlHelpScreenRes = Resources.getResources((class$elgato$infrastructure$html$HTMLHelpScreen == null ? (class$elgato$infrastructure$html$HTMLHelpScreen = HTMLManager.class$("elgato.infrastructure.html.HTMLHelpScreen")) : class$elgato$infrastructure$html$HTMLHelpScreen).getName());
    private static Vector cachedLinkHistory = null;
    private static int cachedHistoryPointer = 0;
    private static HTMLPageHistory cachedStartPage = null;
    private String htmlFileDir = "";
    Vector linkHistory = new Vector(10);
    HTMLPageHistory startPage = null;
    private int historyPointer = 0;
    private boolean historyNavigation = false;
    private String header;
    private String footer;
    private boolean headerIncluded = false;
    private boolean footerIncluded = false;
    private static String topicNotFoundPageCode = null;
    private static String pageNotFoundPageCode = null;
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$html$HTMLManager == null ? (class$elgato$infrastructure$html$HTMLManager = HTMLManager.class$("elgato.infrastructure.html.HTMLManager")) : class$elgato$infrastructure$html$HTMLManager);
    private HTMLRenderer htmlRenderer = new HTMLRenderer();
    private boolean cacheRestore = false;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLManager;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLHelpScreen;

    public HTMLManager() {
        this.htmlRenderer.setHTMLManager(this);
        if (topicNotFoundPageCode == null) {
            try {
                topicNotFoundPageCode = htmlHelpScreenRes.getString("topicNotFound");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pageNotFoundPageCode == null) {
            try {
                pageNotFoundPageCode = htmlHelpScreenRes.getString("pageNotFound");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cachedLinkHistory != null) {
            this.cacheRestore = true;
            this.linkHistory = cachedLinkHistory;
            this.historyPointer = cachedHistoryPointer;
            this.startPage = cachedStartPage;
        }
    }

    public static void cacheSession(HTMLManager hTMLManager) {
        cachedLinkHistory = hTMLManager.linkHistory;
        cachedHistoryPointer = hTMLManager.historyPointer;
        cachedStartPage = hTMLManager.startPage;
    }

    public static void resetCacheSession() {
        cachedLinkHistory = null;
        cachedHistoryPointer = -1;
        cachedStartPage = null;
    }

    public boolean isCacheRestore() {
        return this.cacheRestore;
    }

    public HTMLRenderer getHTMLRenderer() {
        return this.htmlRenderer;
    }

    public String getHTMLFileDir() {
        return this.htmlFileDir;
    }

    public boolean isHistoryNavigation() {
        return this.historyNavigation;
    }

    public boolean isHistoryForward() {
        return this.historyPointer > 0;
    }

    public boolean isHistoryBack() {
        return this.historyPointer + 1 < this.linkHistory.size();
    }

    public void setHTMLRenderer(HTMLRenderer hTMLRenderer) {
        this.htmlRenderer = hTMLRenderer;
    }

    public void setHeaderIncluded(boolean bl) {
        this.headerIncluded = bl;
    }

    public void setFooterIncluded(boolean bl) {
        this.footerIncluded = bl;
    }

    public void setHTMLFileDir(String string) {
        this.htmlFileDir = string;
    }

    private void setHistoryNavigation(boolean bl) {
        this.historyNavigation = bl;
    }

    private void updateHTMLPage(String string, String string2) {
        this.updateHTMLPage(string, string2, 0);
    }

    private void updateHTMLPage(String string, String string2, int n) {
        String string3 = this.getHTMLPage(string, string2);
        if (string3 != null) {
            this.addPageToHistory(string, 0, 0);
            this.updateHistoryStartLine(n, -1, this.htmlRenderer.getSelectedHeadIndex());
            this.htmlRenderer.setText(string3);
            this.htmlRenderer.render();
        }
    }

    private void retrieveHTMLHistoryPage(String string, int n, int n2, int n3) {
        try {
            String string2 = this.getHTMLPage(string, null);
            if (string2 != null) {
                this.updateHistoryStartLine(this.htmlRenderer.getStartLine(), n2, this.htmlRenderer.getSelectedHeadIndex());
                this.htmlRenderer.setText(string2);
                this.htmlRenderer.setStartLineFromHistory(n);
                this.htmlRenderer.setHistorySelectedLinkIndex(n3);
                this.htmlRenderer.render();
            }
        }
        catch (Exception exception) {
            logger.warn("retrieveHTMLHistory(pageCode='" + string + "', startLine=" + n + ", direction=" + n2 + ", selectedLinkIndex=" + n3 + "): " + exception);
            exception.printStackTrace();
        }
    }

    public void setCurrentStartLine() {
        HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer);
        if (hTMLPageHistory == null) {
            return;
        }
        hTMLPageHistory.setStartLine(this.htmlRenderer.getStartLine());
        this.linkHistory.setElementAt(hTMLPageHistory, this.historyPointer);
    }

    public boolean restoreCachedSession() {
        HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer);
        if (hTMLPageHistory == null) {
            logger.warn("HTMLManager.restoreCachedSession: Back restore cache.");
            HTMLManager.resetCacheSession();
            return false;
        }
        String string = this.getHTMLPage(hTMLPageHistory.getPageCode(), null);
        if (string != null) {
            this.htmlRenderer.setText(string);
            this.htmlRenderer.setStartLine(hTMLPageHistory.getStartLine());
            this.htmlRenderer.setHistorySelectedLinkIndex(hTMLPageHistory.getSelectedLinkIndex());
            this.htmlRenderer.render();
            return true;
        }
        return false;
    }

    public String getLastPage() {
        if (this.linkHistory.size() == 0) {
            return null;
        }
        HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.linkHistory.size() - 1);
        return hTMLPageHistory.getPageCode();
    }

    public void navigateToStartPage() {
        try {
            if (this.startPage == null) {
                return;
            }
            this.historyPointer = 0;
            this.linkHistory.setSize(0);
            this.navigateLink(this.startPage.getPageCode(), this.startPage.getStartLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void navigateLink() {
        String string = this.htmlRenderer.getSelectedLinkPageCode();
        if (string == null) {
            return;
        }
        if (string.startsWith("#")) {
            this.htmlRenderer.gotoRelativeLink(string);
            return;
        }
        this.navigateLink(string, this.htmlRenderer.getStartLine());
    }

    public void navigateLink(String string) {
        this.updateHTMLPage(string, null);
    }

    public void navigateLink(String string, int n) {
        this.updateHTMLPage(string, null, n);
    }

    public void navigateLink(String string, String string2) {
        this.navigateLink(string, string2, 0);
    }

    public void navigateLink(String string, String string2, int n) {
        this.updateHTMLPage(string, string2, n);
    }

    private String getBody(String string) {
        int n = string.toUpperCase().indexOf("<BODY>");
        int n2 = string.toUpperCase().indexOf("</BODY>");
        if (n2 < 0) {
            if (n < 0) {
                return string;
            }
            return string.substring(n + 6);
        }
        return string.substring(n + 6, n2);
    }

    private String getHeader() {
        if (this.header == null) {
            InputStream inputStream;
            String string = this.getHTMLFileDir() + res.getString("headerFile");
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((inputStream = this.getClass().getResourceAsStream(string)) == null) {
                logger.warn("No header file (" + string + ") found.");
                return "";
            }
            this.header = this.getBody(FileHelper.getTextFromInputStream(inputStream, null));
        }
        return this.header;
    }

    private String insertHeaderAndFooter(String string) {
        try {
            int n;
            if (string == null) {
                return null;
            }
            if (!this.headerIncluded && !this.footerIncluded) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            if (this.headerIncluded) {
                n = stringBuffer.toString().toUpperCase().indexOf("<BODY>");
                if (n < 0) {
                    return string;
                }
                if (this.header == null) {
                    this.header = this.getHeader();
                }
                if (this.header != null) {
                    stringBuffer.insert(n + 6, this.header);
                }
            }
            if (this.footerIncluded) {
                n = stringBuffer.toString().toUpperCase().indexOf("</BODY>");
                if (n < 0) {
                    return stringBuffer.toString();
                }
                if (this.footer == null) {
                    this.footer = this.getFooter();
                }
                if (this.footer != null) {
                    stringBuffer.insert(n, this.footer);
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.warn("Header and/or footer were not inserted into page: e> " + exception);
            return string;
        }
    }

    private String getFooter() {
        if (this.footer == null) {
            InputStream inputStream;
            String string = this.getHTMLFileDir() + res.getString("footerFile");
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((inputStream = this.getClass().getResourceAsStream(string)) == null) {
                logger.warn("No footer file (" + string + ") found.");
                return "";
            }
            this.footer = this.getBody(FileHelper.getTextFromInputStream(inputStream, null));
        }
        return this.footer;
    }

    public String getHTMLPage(String string, String string2) {
        if (string == null) {
            return TextMessage.HELP_NO_TOPIC_HELP;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(this.convertPageCodeToFilename(string));
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(this.convertPageCodeToFilename(pageNotFoundPageCode));
        }
        if (inputStream == null) {
            return TextMessage.HELP_NO_PAGE_FOUND;
        }
        String string3 = FileHelper.getTextFromInputStream(inputStream, string);
        return this.insertHeaderAndFooter(string3);
    }

    private String convertPageCodeToFilename(String string) {
        String string2 = string;
        int n = string.indexOf("#");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        String string3 = this.getHTMLFileDir() + string2;
        if (!string2.endsWith(".html") && !string2.endsWith(".htm")) {
            string3 = string3 + ".htm";
        }
        if (!string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        return string3;
    }

    public void addPageToHistory(String string) {
        this.addPageToHistory(string, 0, 0);
    }

    public void updateHistoryStartLine(int n, int n2, int n3) {
        if (n2 < 0) {
            if (this.historyPointer < this.linkHistory.size() - 1) {
                HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer + 1);
                hTMLPageHistory.setStartLine(n);
                hTMLPageHistory.setSelectedLinkIndex(n3);
                this.linkHistory.setElementAt(hTMLPageHistory, this.historyPointer + 1);
            }
        } else if (this.historyPointer > 0) {
            HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer - 1);
            hTMLPageHistory.setStartLine(n);
            hTMLPageHistory.setSelectedLinkIndex(n3);
            this.linkHistory.setElementAt(hTMLPageHistory, this.historyPointer - 1);
        }
    }

    public void setTitle(String string) {
        try {
            if (this.linkHistory.size() <= 0) {
                return;
            }
            HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer);
            if (hTMLPageHistory == null) {
                return;
            }
            if (this.linkHistory.size() == 1 && this.historyPointer == 0 && !this.cacheRestore) {
                this.startPage.setTitle(string);
            }
            if (!this.cacheRestore) {
                hTMLPageHistory.setTitle(string);
            }
            this.linkHistory.setElementAt(hTMLPageHistory, this.historyPointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        try {
            if (this.linkHistory.size() <= 0) {
                return "";
            }
            HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.linkHistory.size() - 1);
            if (hTMLPageHistory == null) {
                return "";
            }
            return hTMLPageHistory.getTitle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "...";
        }
    }

    public String getStartPageTitle() {
        try {
            if (this.startPage == null) {
                return "";
            }
            if (this.cacheRestore) {
                return cachedStartPage.getTitle();
            }
            return this.startPage.getTitle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public String getStartPageCode() {
        try {
            if (this.startPage == null) {
                return "";
            }
            return this.startPage.getPageCode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public void addPageToHistory(String string, int n, int n2) {
        if (this.isHistoryNavigation()) {
            this.setHistoryNavigation(false);
            return;
        }
        this.resolveHistory();
        if (this.linkHistory.size() >= 10) {
            this.linkHistory.removeElementAt(9);
        }
        if (this.linkHistory.size() == 0) {
            // empty if block
        }
        HTMLPageHistory hTMLPageHistory = new HTMLPageHistory(string, n, n2);
        if (this.linkHistory.size() == 0 && this.startPage == null) {
            this.startPage = hTMLPageHistory;
        }
        this.linkHistory.insertElementAt(hTMLPageHistory, 0);
    }

    private void resolveHistory() {
        for (int i = 0; i < this.historyPointer; ++i) {
            this.linkHistory.removeElementAt(0);
        }
        this.historyPointer = 0;
    }

    public void navigateBack() {
        if (this.historyPointer >= this.linkHistory.size() - 1) {
            return;
        }
        ++this.historyPointer;
        HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer);
        this.retrieveHTMLHistoryPage(hTMLPageHistory.getPageCode(), hTMLPageHistory.getStartLine(), 1, hTMLPageHistory.getSelectedLinkIndex());
    }

    public void navigateForward() {
        if (this.historyPointer < 1) {
            return;
        }
        --this.historyPointer;
        HTMLPageHistory hTMLPageHistory = (HTMLPageHistory)this.linkHistory.elementAt(this.historyPointer);
        this.retrieveHTMLHistoryPage(hTMLPageHistory.getPageCode(), hTMLPageHistory.getStartLine(), -1, hTMLPageHistory.getSelectedLinkIndex());
    }

    public HTMLRenderer getRenderer() {
        return this.htmlRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextFromInputStream(InputStream inputStream, String string) {
        block16: {
            String string2;
            try {
                int n;
                if (inputStream == null) {
                    String string3 = null;
                    return string3;
                }
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = inputStream.read()) != -1) {
                    if (n == 10 || n == 13) continue;
                    stringBuffer.append((char)n);
                }
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                logger.error("Exception loading page '" + string + "' from resource.", exception);
                break block16;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        return null;
    }

    public void renderHistory(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3 / 12;
        int n6 = this.linkHistory.size();
        int n7 = n2 + (n4 - n5);
        int n8 = n6 * n5;
        Color color = graphics.getColor();
        for (int i = 0; i < n6; ++i) {
            int n9 = (n6 - i - 1) * n5 + n5 / 2 + (n3 - n8) / 2;
            graphics.setColor(Color.white);
            graphics.fillRect(n9, n7, n5, n5);
            graphics.setColor(color);
            graphics.drawRect(n9, n7, n5, n5);
            if (i != this.historyPointer) continue;
            graphics.fillRect(n9, n7, n5, n5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class HTMLPageHistory {
        private String pageCode;
        private int startLine;
        private int selectedLinkIndex;
        private String title = null;

        public HTMLPageHistory(String string) {
            this(string, 0, 0);
        }

        public HTMLPageHistory(String string, int n, int n2) {
            this.setPageCode(string);
            this.setStartLine(n);
            this.setSelectedLinkIndex(n2);
        }

        public String getPageCode() {
            return this.pageCode;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getSelectedLinkIndex() {
            return this.selectedLinkIndex;
        }

        public String getTitle() {
            if (this.title != null) {
                return this.title;
            }
            return this.pageCode;
        }

        public void setPageCode(String string) {
            this.pageCode = string;
        }

        public void setStartLine(int n) {
            this.startLine = n;
        }

        public void setSelectedLinkIndex(int n) {
            this.selectedLinkIndex = n;
        }

        public void setTitle(String string) {
            this.title = string;
        }
    }
}

