/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.html;

import elgato.infrastructure.html.HTMLManager;
import elgato.infrastructure.html.HTMLRendererListener;
import elgato.infrastructure.html.HTMLTag;
import elgato.infrastructure.html.HTMLToken;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.widgets.EScrollbarHTML;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;

public class HTMLRenderer
extends JComponent {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$html$HTMLRenderer == null ? (class$elgato$infrastructure$html$HTMLRenderer = HTMLRenderer.class$("elgato.infrastructure.html.HTMLRenderer")) : class$elgato$infrastructure$html$HTMLRenderer).getName());
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$html$HTMLRenderer == null ? (class$elgato$infrastructure$html$HTMLRenderer = HTMLRenderer.class$("elgato.infrastructure.html.HTMLRenderer")) : class$elgato$infrastructure$html$HTMLRenderer);
    private String text = "";
    private boolean textDirty = false;
    private int baseFontSize = 15;
    private String baseFontStyle = "SansSerif";
    private int headerFontStep = 4;
    private HTMLRenderState renderState = new HTMLRenderState();
    private HTMLManager htmlManager = null;
    private boolean scrollingRequired = false;
    private Vector listeners = new Vector(3);
    private EScrollbarHTML scrollbar = null;
    private boolean scrollable = true;
    public static final int DEFAULT_COLUMN_WIDTH = 15;
    private boolean startLineInit = false;
    private int historySelectedLinkIndex = -1;
    private Hashtable variableReplacement = new Hashtable();
    private String[] variableKey;
    private int[] variableKeyLength;
    private String[] variableText;
    private Vector links = new Vector(11);
    private Vector linkHeads = new Vector(11);
    private Vector globalLinkHeads = new Vector(11);
    private int globalLinkIndex = 0;
    private int globalSelectedLinkIndex = -1;
    private int pageLinkOffset = 0;
    private HTMLLink selectedLink = null;
    private int selectedLinkIndex = -1;
    private int selectedHeadIndex = -1;
    private int prevSelectedLinkIndex = -2;
    private Hashtable relativeLinks = new Hashtable(11);
    private Font baseFont = null;
    private Font linkFont = null;
    private Font highlightFont = null;
    private Color baseFontColor = Color.black;
    private Color baseBGColor = Color.white;
    private Color linkFontColor = Color.blue;
    private Color linkBGColor = Color.yellow;
    private Color highlightFontColor = Color.yellow;
    private Color highlightBGColor = Color.red;
    private Color highlightRelativeFontColor = Color.yellow;
    private Color highlightRelativeBGColor = Color.blue;
    private Hashtable fonts = new Hashtable();
    private Hashtable fontColors = new Hashtable();
    private Hashtable fontBGColors = new Hashtable();
    private static Hashtable nameCodes = null;
    private Vector externalPainters = null;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLRenderer;

    public HTMLRenderer() {
        this.loadPropertiesFromResources();
        this.setBackground(this.baseBGColor);
        this.buildNameCodes();
    }

    public Color getBaseBGColor() {
        return this.baseBGColor;
    }

    public void clearVariableReplacement() {
        this.variableReplacement.clear();
    }

    public void addVariableReplacment(String string, String string2) {
        this.variableReplacement.put(string, string2);
    }

    public void removeVariableReplacement(String string) {
        this.variableReplacement.remove(string);
    }

    public void setHistorySelectedLinkIndex(int n) {
        this.historySelectedLinkIndex = n;
    }

    private boolean isTextDirty() {
        return this.textDirty;
    }

    public boolean isScrollingRequired() {
        return this.scrollingRequired;
    }

    public boolean isTop() {
        return this.renderState.isTop();
    }

    public boolean isBottom() {
        return this.renderState.isBottom();
    }

    public boolean isLinkUp() {
        if (this.selectedLink == null) {
            return true;
        }
        return this.selectedLink.getPageLinkIndex() > 0;
    }

    public boolean isLinkDown() {
        try {
            if (this.selectedLink == null) {
                return true;
            }
            return this.selectedLink.getPageLinkIndex() < this.globalLinkHeads.size() - 1;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private HTMLLink getSelectedLink() {
        return this.selectedLink;
    }

    public int getSelectedHeadIndex() {
        return this.selectedHeadIndex;
    }

    private void setSelectedLink(HTMLLink hTMLLink) {
        this.selectedLink = hTMLLink;
    }

    private void setSelectedLinkIndex(int n) {
        this.selectedLinkIndex = n;
    }

    public int getStartLine() {
        return this.renderState.getStartLine();
    }

    public void setStartLine(int n) {
        this.startLineInit = true;
        this.renderState.setStartLine(n);
    }

    public void setStartLineFromHistory(int n) {
        this.startLineInit = true;
        this.renderState.setStartLineFromHistory(n);
    }

    public void gotoRelativeLink(String string) {
        Integer n;
        if (string == null) {
            return;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if ((n = (Integer)this.relativeLinks.get(string)) == null) {
            return;
        }
        int n2 = n;
        this.renderState.setStartLine(n2);
        this.repaint();
    }

    public void setHTMLManager(HTMLManager hTMLManager) {
        this.htmlManager = hTMLManager;
    }

    public void setText(String string) {
        this.setTextDirty(true);
        this.optimizeVariableReplacement();
        this.text = this.handleTextReplacement(string);
    }

    private void setTextDirty(boolean bl) {
        this.textDirty = bl;
    }

    private void setMaxLines(int n) {
        this.renderState.setMaxLines(n);
    }

    private void setMaxWidth(int n) {
        this.renderState.setMaxWidth(n);
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    private void setFonts() {
        this.setFonts(this.baseFontSize);
    }

    public int getLinkCount() {
        return this.linkHeads.size();
    }

    private void buildNameCodes() {
        if (nameCodes != null) {
            return;
        }
        nameCodes = new Hashtable();
        nameCodes.put("lt", "60");
        nameCodes.put("gt", "62");
        nameCodes.put("nbsp", "160");
        nameCodes.put("copy", "169");
        nameCodes.put("reg", "174");
        nameCodes.put("quot", "34");
        nameCodes.put("amp", "38");
    }

    public String getText() {
        return this.text;
    }

    public static final Color getColor(String string) {
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("darkGray")) {
            return Color.darkGray;
        }
        if (string.equals("gray")) {
            return Color.gray;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("lightGray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("orange")) {
            return Color.orange;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        return Color.black;
    }

    private Font getTagFont(String string) {
        try {
            Font font = (Font)this.fonts.get(string);
            return font;
        }
        catch (Exception exception) {
            return this.baseFont;
        }
    }

    private Color getTagFontColor(String string) {
        try {
            Color color = (Color)this.fontColors.get(string);
            return color;
        }
        catch (Exception exception) {
            return this.baseFontColor;
        }
    }

    private void setFonts(int n) {
        this.baseFontSize = n;
        this.baseFont = new Font(this.baseFontStyle, 0, this.baseFontSize);
        this.linkFont = new Font(this.baseFontStyle, 1, this.baseFontSize);
        this.highlightFont = new Font(this.baseFontStyle, 1, this.baseFontSize);
        this.fonts.put(HTMLTag.TAGS[7], new Font(this.baseFontStyle, 1, this.baseFontSize));
        this.fonts.put(HTMLTag.TAGS[8], new Font(this.baseFontStyle, 2, this.baseFontSize));
        this.fonts.put(HTMLTag.TAGS[1], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep * 6));
        this.fonts.put(HTMLTag.TAGS[2], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep * 5));
        this.fonts.put(HTMLTag.TAGS[3], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep * 4));
        this.fonts.put(HTMLTag.TAGS[4], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep * 3));
        this.fonts.put(HTMLTag.TAGS[5], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep * 2));
        this.fonts.put(HTMLTag.TAGS[6], new Font(this.baseFontStyle, 1, this.baseFontSize + this.headerFontStep));
        this.fonts.put(HTMLTag.TAGS[9], this.linkFont);
        this.fonts.put(HTMLTag.TAGS[12], new Font("Monospaced", 0, this.baseFontSize));
        this.fonts.put(HTMLTag.TAGS[24], new Font(this.baseFontStyle, 1, this.baseFontSize));
    }

    public void addListener(HTMLRendererListener hTMLRendererListener) {
        this.listeners.addElement(hTMLRendererListener);
    }

    public void removeListener(HTMLRendererListener hTMLRendererListener) {
        this.listeners.removeElement(hTMLRendererListener);
    }

    public void fireFinishedHTMLRendering() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((HTMLRendererListener)this.listeners.elementAt(i)).finishedHTMLRendering();
        }
    }

    private void loadPropertiesFromResources() {
        try {
            int n;
            Color color;
            int n2;
            String string = res.getString("baseFontStyle");
            if (string != null) {
                this.baseFontStyle = string;
            }
            if ((string = res.getString("baseFontSize")) != null) {
                try {
                    this.baseFontSize = n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = res.getString("headerFontStep")) != null) {
                try {
                    this.headerFontStep = n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((color = res.getColor("baseFontColor")) != null) {
                this.baseFontColor = color;
            }
            if ((color = res.getColor("baseBGColor")) != null) {
                this.baseBGColor = color;
            }
            if ((color = res.getColor("linkFontColor")) != null) {
                this.linkFontColor = color;
            }
            if ((color = res.getColor("linkBGColor")) != null) {
                this.linkBGColor = color;
            }
            if ((color = res.getColor("highlightFontColor")) != null) {
                this.highlightFontColor = color;
            }
            if ((color = res.getColor("highlightBGColor")) != null) {
                this.highlightBGColor = color;
            }
            if ((color = res.getColor("highlightRelativeFontColor")) != null) {
                this.highlightRelativeFontColor = color;
            }
            if ((color = res.getColor("highlightRelativeBGColor")) != null) {
                this.highlightRelativeBGColor = color;
            }
            if ((string = res.getString("maxWidth")) != null) {
                try {
                    n = Integer.parseInt(string);
                    this.setMaxWidth(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = res.getString("maxLines")) != null) {
                try {
                    n = Integer.parseInt(string);
                    this.setMaxLines(n + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = res.getString("lineHeight")) != null) {
                try {
                    int n3 = Integer.parseInt(string);
                    this.renderState.setLineHeight(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = res.getString("xOffset")) != null) {
                try {
                    int n4 = Integer.parseInt(string);
                    this.renderState.setXOffset(n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = res.getString("yOffset")) != null) {
                try {
                    int n5 = Integer.parseInt(string);
                    this.renderState.setYOffset(n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setFonts();
            this.setFontColors();
            this.setTextDirty(true);
            this.render();
        }
        catch (Exception exception) {
            logger.error("Failure loading properties for HTML display.");
        }
    }

    private void setFontColors() {
        this.fontColors.put(HTMLTag.TAGS[7], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[8], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[1], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[2], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[3], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[4], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[5], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[6], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[9], this.linkFontColor);
        this.fontColors.put(HTMLTag.TAGS[12], this.baseFontColor);
        this.fontColors.put(HTMLTag.TAGS[24], this.baseFontColor);
        this.fontBGColors.put(HTMLTag.TAGS[7], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[8], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[1], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[2], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[3], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[4], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[5], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[6], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[9], this.linkBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[12], this.baseBGColor);
        this.fontBGColors.put(HTMLTag.TAGS[24], this.baseBGColor);
    }

    public void scrollUp() {
        this.scrollBy(-1);
    }

    public void scrollDown() {
        this.scrollBy(1);
    }

    public void scrollPageUp() {
        this.scrollBy(-((int)(0.8f * (float)this.renderState.getMaxLines())));
    }

    public void scrollPageDown() {
        this.scrollBy((int)(0.8f * (float)this.renderState.getMaxLines()));
    }

    public void scrollBy(int n) {
        if (this.renderState.getPageCount() <= 1) {
            return;
        }
        int n2 = this.renderState.getStartLine() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.renderState.getLineCount() - this.renderState.getMaxLines()) {
            n2 = this.renderState.getLineCount() - this.renderState.getMaxLines();
        }
        this.renderState.setStartLine(n2);
        this.renderState.setPreviousLine(-999999);
        this.render();
    }

    private void initLinks() {
        this.linkHeads.setSize(0);
        this.links.setSize(0);
        if (!this.renderState.isPaging() && this.renderState.getCurrentLine() != this.renderState.getPreviousLine()) {
            this.selectedHeadIndex = -1;
            this.selectedLinkIndex = -1;
            this.selectedLink = null;
        }
    }

    private void unselectLink(HTMLLink hTMLLink) {
        this.unhighlightLink(hTMLLink);
        this.unhighlightAllLinkWords(hTMLLink);
        this.setSelectedLink(null);
        this.setSelectedLinkIndex(-1);
    }

    private void highlightLink(HTMLLink hTMLLink) {
        if (hTMLLink.isRelative()) {
            this.highlightRelativeLinkText(hTMLLink.getLinkText(), hTMLLink.getX(), hTMLLink.getY());
        } else {
            this.highlightText(hTMLLink.getLinkText(), hTMLLink.getX(), hTMLLink.getY());
        }
    }

    private void unhighlightLink(HTMLLink hTMLLink) {
        this.unhighlightLinkText(hTMLLink.getLinkText(), hTMLLink.getX(), hTMLLink.getY());
    }

    public int getSelectedLinkIndex() {
        return this.selectedLinkIndex;
    }

    public String getSelectedLinkText() {
        if (this.selectedLink == null) {
            return null;
        }
        return this.getFullLinkText(this.selectedLink);
    }

    private void selectLinkHead(int n) {
        try {
            if (n < 0) {
                n = 0;
            }
            HTMLLink hTMLLink = (HTMLLink)this.linkHeads.elementAt(n);
            this.selectedLinkIndex = hTMLLink.getDisplayLinkIndex();
            this.selectLink(this.selectedLinkIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void selectLink(HTMLLink hTMLLink) {
        if (hTMLLink.isRelative()) {
            this.highlightRelativeLinkText(hTMLLink.getLinkText(), hTMLLink.getX(), hTMLLink.getY());
        } else {
            this.highlightText(hTMLLink.getLinkText(), hTMLLink.getX(), hTMLLink.getY());
        }
        this.highlightAllLinkWords(hTMLLink);
        this.setSelectedLink(hTMLLink);
        this.setSelectedLinkIndex(hTMLLink.getDisplayLinkIndex());
    }

    protected void selectGlobalLink(int n) {
        try {
            HTMLLink hTMLLink = (HTMLLink)this.globalLinkHeads.elementAt(n);
            this.setSelectedLink(hTMLLink);
            this.setSelectedLinkIndex(0);
            this.renderState.setStartLine(hTMLLink.getStartLine());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void selectLink(int n) {
        try {
            if (n < 0) {
                return;
            }
            int n2 = this.links.size();
            if (n2 == 0) {
                return;
            }
            if (n >= n2) {
                return;
            }
            HTMLLink hTMLLink = this.getSelectedLink();
            if (hTMLLink != null && this.renderState.getCurrentLine() == this.renderState.getPreviousLine()) {
                this.unselectLink(hTMLLink);
            }
            HTMLLink hTMLLink2 = (HTMLLink)this.links.elementAt(n);
            this.selectLink(hTMLLink2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setSelectedLinkIndex(-1);
            this.setSelectedLink(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePageLinkOffset() {
        try {
            if (this.globalSelectedLinkIndex < 0) {
                this.pageLinkOffset = 0;
                return;
            }
            HTMLLink hTMLLink = (HTMLLink)this.linkHeads.elementAt(0);
            if (hTMLLink == null) {
                this.pageLinkOffset = 0;
                return;
            }
            this.pageLinkOffset = this.globalSelectedLinkIndex - hTMLLink.getPageLinkIndex();
            if (this.pageLinkOffset < 0) {
                this.pageLinkOffset = 0;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.globalSelectedLinkIndex = -1;
        }
        this.pageLinkOffset = 0;
    }

    public void scrollLinkDown() {
        this.renderState.setGraphics(this.getGraphics());
        int n = this.linkHeads.size();
        if (n <= 0) {
            return;
        }
        if (this.selectedHeadIndex >= n - 1 || this.selectedHeadIndex < 0) {
            if (this.selectedLink == null) {
                return;
            }
            if (this.selectedLink.getPageLinkIndex() >= this.globalLinkHeads.size() - 1) {
                return;
            }
            this.globalSelectedLinkIndex = this.selectedLink.getPageLinkIndex() + 1;
            this.handleGlobalSelectedLinkIndex(this.renderState, 0.15);
            return;
        }
        ++this.selectedHeadIndex;
        HTMLLink hTMLLink = (HTMLLink)this.linkHeads.elementAt(this.selectedHeadIndex);
        this.selectedLinkIndex = hTMLLink.getDisplayLinkIndex();
        this.selectLink(this.selectedLinkIndex);
        this.renderState.getGraphics().dispose();
    }

    public void scrollLinkUp() {
        this.renderState.setGraphics(this.getGraphics());
        int n = this.linkHeads.size();
        if (n <= 0) {
            return;
        }
        if (this.selectedHeadIndex <= 0) {
            if (this.selectedLink == null) {
                return;
            }
            if (this.selectedLink.getPageLinkIndex() <= 0) {
                return;
            }
            this.globalSelectedLinkIndex = this.selectedLink.getPageLinkIndex() - 1;
            this.handleGlobalSelectedLinkIndex(this.renderState, 0.85);
            return;
        }
        --this.selectedHeadIndex;
        HTMLLink hTMLLink = (HTMLLink)this.linkHeads.elementAt(this.selectedHeadIndex);
        this.selectedLinkIndex = hTMLLink.getDisplayLinkIndex();
        this.selectLink(this.selectedLinkIndex);
        this.renderState.getGraphics().dispose();
    }

    public String getSelectedLinkPageCode() {
        if (this.selectedLink == null) {
            return null;
        }
        return this.selectedLink.getLinkPage();
    }

    private void unhighlightLinkText(String string, int n, int n2) {
        this.highlightText(this.linkFont, string, n, n2, this.linkFontColor, this.linkBGColor);
    }

    private void highlightText(String string, int n, int n2) {
        this.highlightText(this.highlightFont, string, n, n2, this.highlightFontColor, this.highlightBGColor);
    }

    private void highlightRelativeLinkText(String string, int n, int n2) {
        this.highlightText(this.highlightFont, string, n, n2, this.highlightRelativeFontColor, this.highlightRelativeBGColor);
    }

    private void highlightText(Font font, String string, int n, int n2, Color color, Color color2) {
        Graphics graphics = this.renderState.getGraphics();
        this.renderState.setClip();
        Color color3 = graphics.getColor();
        Font font2 = graphics.getFont();
        graphics.setColor(color2.brighter());
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.stringWidth(string) + 5;
        graphics.fillRect(n - 2, (int)((double)n2 - (double)n3 * 0.75), n4, n3);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
        graphics.setFont(font2);
        graphics.setColor(color3);
    }

    private void highlightAllLinkWords(HTMLLink hTMLLink) {
        int n = this.links.size();
        int n2 = hTMLLink.getDisplayLinkIndex() + 1;
        int n3 = hTMLLink.getLinkID();
        for (int i = n2; i < n; ++i) {
            HTMLLink hTMLLink2 = (HTMLLink)this.links.elementAt(i);
            if (hTMLLink2.getLinkID() > n3) {
                return;
            }
            this.highlightLink(hTMLLink2);
        }
    }

    private String getFullLinkText(HTMLLink hTMLLink) {
        HTMLLink hTMLLink2;
        int n = this.links.size();
        int n2 = hTMLLink.getDisplayLinkIndex();
        int n3 = hTMLLink.getLinkID();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n2; i < n && (hTMLLink2 = (HTMLLink)this.links.elementAt(i)).getLinkID() <= n3; ++i) {
            if (i != n2) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(hTMLLink2.getLinkText());
        }
        return stringBuffer.toString();
    }

    private void unhighlightAllLinkWords(HTMLLink hTMLLink) {
        int n = this.links.size();
        int n2 = hTMLLink.getDisplayLinkIndex() + 1;
        int n3 = hTMLLink.getLinkID();
        for (int i = n2; i < n; ++i) {
            HTMLLink hTMLLink2 = (HTMLLink)this.links.elementAt(i);
            if (hTMLLink2.getLinkID() > n3) {
                return;
            }
            this.unhighlightLink(hTMLLink2);
        }
    }

    private void formatToken(HTMLRenderState hTMLRenderState, HTMLToken hTMLToken) {
        Color color;
        Object object;
        hTMLRenderState.setClip();
        int n = hTMLToken.getTagType();
        if (n == 1 && this.htmlManager != null) {
            this.htmlManager.setTitle(hTMLToken.getText());
        }
        String string = HTMLTag.TAGS[n];
        if (hTMLToken.isStartTag()) {
            object = this.getTagFont(string);
            color = this.getTagFontColor(string);
            if (object != null) {
                hTMLRenderState.pushFont((Font)object);
            }
            if (color != null) {
                hTMLRenderState.pushColor(color);
            }
        } else {
            object = this.getTagFont(HTMLTag.TAGS[hTMLToken.getCloseTagType()]);
            color = this.getTagFontColor(HTMLTag.TAGS[hTMLToken.getCloseTagType()]);
            if (object != null) {
                hTMLRenderState.popFont();
            }
            if (color != null) {
                hTMLRenderState.popColor();
            }
        }
        switch (hTMLToken.getTagType()) {
            case 19: {
                hTMLRenderState.setImageFilename(hTMLToken.getAttribute("SRC"));
                break;
            }
            case 22: {
                hTMLRenderState.setListType(22);
                break;
            }
            case 23: {
                hTMLRenderState.setListType(23);
                hTMLRenderState.setOrderedListItem(0);
                break;
            }
            case 13: {
                hTMLRenderState.setTableMode(true);
                object = hTMLToken.getAttribute("BORDER");
                if (object == null) {
                    hTMLRenderState.setTableBorder(0);
                } else {
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hTMLRenderState.setTableBorder(n2);
                }
                String string2 = hTMLToken.getAttribute("BORDERCOLOR");
                if (string2 == null) {
                    string2 = "lightGray";
                }
                hTMLRenderState.setTableBorderColor(string2);
                hTMLRenderState.setRowY(0);
                break;
            }
            case 14: {
                hTMLRenderState.setRowDepth(0);
                hTMLRenderState.setColumnWidthSum(0);
                hTMLRenderState.setStartRowLine();
                break;
            }
            case 15: 
            case 24: {
                hTMLRenderState.setCurrentLine(hTMLRenderState.getStartRowLine());
                String string3 = hTMLToken.getAttribute("WIDTH");
                int n3 = hTMLRenderState.getTableColumnWidth();
                if (string3 != null) {
                    if (string3.endsWith("%")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    n3 = Integer.parseInt(string3);
                    hTMLRenderState.addTableColumnWidth(n3);
                }
                if (n3 < 0) {
                    n3 = 15;
                }
                hTMLRenderState.addToColumnWidthSum(hTMLRenderState.getColumnWidth());
                hTMLRenderState.setColumnWidth(n3);
                hTMLRenderState.incrementRowDepth();
                hTMLRenderState.setStartPosition(0);
                hTMLRenderState.setCurrentWidth(0);
                hTMLRenderState.setColumnX();
                break;
            }
        }
    }

    private void handlePreLine(HTMLRenderState hTMLRenderState, HTMLToken hTMLToken) {
        if (hTMLRenderState.isNewLine()) {
            return;
        }
        if (hTMLToken.isNewLineBefore()) {
            hTMLRenderState.linefeed();
        }
    }

    private void handlePostLine(HTMLRenderState hTMLRenderState, HTMLToken hTMLToken) {
        if (hTMLToken.isNewLineAfter()) {
            hTMLRenderState.linefeed();
        } else {
            hTMLRenderState.setNewLine(false);
        }
    }

    private void handleDrawLine(HTMLRenderState hTMLRenderState, HTMLToken hTMLToken) {
        if (hTMLToken.isDrawLine()) {
            hTMLRenderState.linefeed();
            if (hTMLRenderState.isPreRange()) {
                return;
            }
            int n = hTMLRenderState.getX();
            int n2 = hTMLRenderState.getY() - hTMLRenderState.getLineHeight() / 2;
            if (!hTMLRenderState.isPaging() && hTMLRenderState.isInRange()) {
                Graphics graphics = hTMLRenderState.getGraphics();
                hTMLRenderState.setClip();
                graphics.drawLine(n, n2, n + hTMLRenderState.getMaxWidth(), n2);
            }
            hTMLRenderState.linefeed();
        }
    }

    private String handleSpecialCharacters(String string) {
        try {
            int n = string.indexOf("&");
            if (n == -1) {
                return string;
            }
            int n2 = string.indexOf(";");
            if (n2 == -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1 && n2 != -1) {
                stringBuffer.append(string.substring(n3, n));
                stringBuffer.append(this.getSpecialCharacter(string.substring(n, n2 + 1)));
                n3 = n2 + 1;
                n = string.indexOf("&", n3);
                if (n == -1) continue;
                n2 = string.indexOf(";", n);
            }
            if (n == -1) {
                stringBuffer.append(string.substring(n2 + 1));
            } else if (n2 == -1) {
                stringBuffer.append(string.substring(n));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String getSpecialCharacter(String string) {
        try {
            String string2;
            int n = string.indexOf("#");
            if (n == 1) {
                string2 = string.substring(2, string.length() - 1);
            } else {
                string2 = string.substring(1, string.length() - 1);
                if ((string2 = (String)nameCodes.get(string2)) == null) {
                    string2 = "32";
                }
            }
            int n2 = Integer.parseInt(string2);
            char c = (char)n2;
            return "" + c;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void handleGlobalSelectedLinkIndex(HTMLRenderState hTMLRenderState, double d) {
        try {
            if (this.globalSelectedLinkIndex < 0) {
                return;
            }
            HTMLLink hTMLLink = (HTMLLink)this.globalLinkHeads.elementAt(this.globalSelectedLinkIndex);
            if (hTMLLink == null) {
                return;
            }
            hTMLRenderState.setStartLine(hTMLLink.getStartLine() - (int)((double)hTMLRenderState.getMaxLines() * d));
            hTMLRenderState.setPreviousLine(-999999);
            this.render();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void imageNotFound(HTMLRenderState hTMLRenderState) {
        Graphics graphics = hTMLRenderState.getGraphics();
        hTMLRenderState.setClip();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "";
        hTMLRenderState.addToCurrentWidth(fontMetrics.stringWidth(string));
        if (!hTMLRenderState.isPaging() && hTMLRenderState.isInRange()) {
            graphics.drawString(string, hTMLRenderState.getX(), hTMLRenderState.getY());
            hTMLRenderState.linefeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(HTMLRenderState hTMLRenderState, HTMLToken hTMLToken) {
        try {
            int n;
            String string = hTMLToken.getAttribute("SRC");
            if (string == null) {
                return;
            }
            Image image = null;
            try {
                image = ImageIcon.loadImage(this.htmlManager.getHTMLFileDir() + string, this);
            }
            catch (MissingResourceException missingResourceException) {
                logger.error("renderImage(): Image token = '" + string + "'", missingResourceException);
            }
            if (image == null) {
                this.imageNotFound(hTMLRenderState);
                return;
            }
            Graphics graphics = hTMLRenderState.getGraphics();
            int n2 = image.getHeight(null);
            int n3 = n2 / hTMLRenderState.getLineHeight();
            ++n3;
            if (!hTMLRenderState.isPaging()) {
                n = 0;
                if (hTMLRenderState.isInRange()) {
                    n = 1;
                }
                if (hTMLRenderState.getCurrentLine() + n3 > hTMLRenderState.getStartLine()) {
                    n = 1;
                }
                if (n != 0) {
                    try {
                        hTMLRenderState.setClip();
                        int n4 = hTMLRenderState.getX();
                        int n5 = hTMLRenderState.getY() - (int)((double)hTMLRenderState.getLineHeight() * 0.7);
                        graphics.drawImage(image, n4, n5, this);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        graphics.setClip(null);
                    }
                }
            }
            for (n = 0; n < n3; ++n) {
                hTMLRenderState.linefeed();
            }
        }
        catch (Exception exception) {
        }
        finally {
            hTMLRenderState.setImageRendering(false);
        }
    }

    private void renderToken(HTMLRenderState hTMLRenderState, String string) {
        String string2;
        int n;
        int n2;
        Object object;
        HTMLToken hTMLToken = HTMLToken.handleToken(string);
        if (!hTMLRenderState.isInBody()) {
            if (hTMLToken.getTagType() == 17) {
                hTMLRenderState.setInBody(true);
            } else {
                return;
            }
        }
        if (hTMLToken.getCloseTagType() == 17) {
            hTMLRenderState.abortRender();
            return;
        }
        this.formatToken(hTMLRenderState, hTMLToken);
        this.handlePreLine(hTMLRenderState, hTMLToken);
        if (hTMLRenderState.isRenderAborted()) {
            return;
        }
        this.handleDrawLine(hTMLRenderState, hTMLToken);
        if (hTMLRenderState.isRenderAborted()) {
            return;
        }
        hTMLRenderState.handlePaging();
        if (hTMLRenderState.isPostRange() && !hTMLRenderState.isTableMode()) {
            hTMLRenderState.abortRender();
            return;
        }
        if (hTMLToken.getTagType() == 19) {
            this.renderImage(hTMLRenderState, hTMLToken);
            return;
        }
        if (hTMLToken.getTagType() == 9 && (object = hTMLToken.getAttribute("HREF")) != null) {
            hTMLRenderState.setInAnchor(true);
            hTMLRenderState.setLinkPage((String)object);
        }
        object = new StringTokenizer(hTMLToken.getText());
        int n3 = 0;
        Graphics graphics = hTMLRenderState.getGraphics();
        hTMLRenderState.setClip();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.stringWidth(" ");
        if (hTMLToken.getTagType() == 21) {
            n2 = hTMLRenderState.getX();
            n = hTMLRenderState.getY();
            if (!hTMLRenderState.isPaging() && hTMLRenderState.isInRange() && hTMLRenderState.isOnScreen()) {
                if (hTMLRenderState.getListType() == 23) {
                    graphics.drawString("" + hTMLRenderState.getOrderedListItem() + ".", n2, n);
                } else {
                    graphics.fillRect(n2 + 8, n - fontMetrics.getHeight() / 2, 6, 6);
                }
            }
            hTMLRenderState.setCurrentWidth(22);
            hTMLRenderState.setStartPosition(hTMLRenderState.getCurrentWidth());
        }
        while (((StringTokenizer)object).hasMoreTokens()) {
            HTMLLink hTMLLink;
            String string3 = ((StringTokenizer)object).nextToken();
            if ((string3 = this.handleSpecialCharacters(string3)).startsWith("&") && string3.endsWith(";")) {
                string3 = this.handleSpecialCharacters(string3);
            }
            int n5 = fontMetrics.stringWidth(string3);
            hTMLRenderState.addToCurrentWidth(n5);
            if (hTMLRenderState.isNewLineNeeded()) {
                hTMLRenderState.setCurrentWidth(n5);
                hTMLRenderState.linefeed();
                if (hTMLRenderState.isPostRange() && !hTMLRenderState.isPaging()) {
                    return;
                }
                hTMLRenderState.setCurrentWidth(n5);
            }
            n2 = hTMLRenderState.getX();
            n = hTMLRenderState.getY();
            if (hTMLRenderState.isInAnchor() && ++n3 == 1) {
                if (hTMLRenderState.isPaging()) {
                    hTMLLink = new HTMLLink(hTMLRenderState.getLinkID(), this.links.size(), hTMLToken.getLinkPage(), hTMLRenderState.getLinkPage(), n2, n, graphics.getFont());
                    hTMLLink.setStartLine(hTMLRenderState.getCurrentLine() - 1);
                    hTMLLink.setPageLinkIndex(this.globalLinkIndex);
                    if (hTMLToken.getLinkPage() != null && hTMLToken.getLinkPage().startsWith("#")) {
                        hTMLLink.setRelative(true);
                    }
                    this.globalLinkHeads.addElement(hTMLLink);
                }
                ++this.globalLinkIndex;
            }
            if (!hTMLRenderState.isPaging() && (hTMLRenderState.isInRange() || hTMLRenderState.isTableMode())) {
                if (hTMLRenderState.isInAnchor()) {
                    if (hTMLRenderState.isOnScreen()) {
                        this.highlightText(this.linkFont, string3, n2, n, this.linkFontColor, this.linkBGColor);
                        string2 = hTMLRenderState.getLinkPage();
                        hTMLLink = new HTMLLink(hTMLRenderState.getLinkID(), this.links.size(), string3, string2, n2, n, graphics.getFont());
                        if (string2 != null) {
                            if (string2.startsWith("#")) {
                                hTMLLink.setRelative(true);
                            }
                            this.links.addElement(hTMLLink);
                        }
                        if (n3 == 1) {
                            hTMLLink.setStartLine(hTMLRenderState.getCurrentLine() - 1);
                            hTMLLink.setPageLinkIndex(this.globalLinkIndex - 1);
                            if (string2 != null) {
                                this.linkHeads.addElement(hTMLLink);
                            }
                        }
                    }
                } else if (hTMLRenderState.isOnScreen()) {
                    graphics.drawString(string3, n2, n);
                }
            }
            hTMLRenderState.addToCurrentWidth(n4);
            hTMLRenderState.setStartPosition(hTMLRenderState.getCurrentWidth());
        }
        if (hTMLToken.getTagType() == 9 && hTMLRenderState.isPaging() && (string2 = hTMLToken.getAttribute("NAME")) != null) {
            this.relativeLinks.put(string2, new Integer(hTMLRenderState.getCurrentLine() - 1));
        }
        if (hTMLToken.getCloseTagType() == 9 && hTMLRenderState.isInAnchor()) {
            hTMLRenderState.incrementLinkID();
            hTMLRenderState.setInAnchor(false);
            hTMLRenderState.setLinkPage(null);
        }
        if (hTMLToken.getCloseTagType() == 23) {
            hTMLRenderState.setListType(22);
        }
        if (hTMLToken.getCloseTagType() == 15 || hTMLToken.getCloseTagType() == 24) {
            hTMLRenderState.setEndRowLine();
            hTMLRenderState.setCurrentLine(hTMLRenderState.getStartRowLine());
        }
        if (hTMLToken.getCloseTagType() == 14) {
            hTMLRenderState.reconcileTableColumnWidths();
            hTMLRenderState.setCurrentLine(hTMLRenderState.getEndRowLine() + 1);
            hTMLRenderState.setRowY();
            hTMLRenderState.setEndRowLine(0);
        }
        if (hTMLToken.getCloseTagType() == 13) {
            hTMLRenderState.setTableMode(false);
        }
        this.handlePostLine(hTMLRenderState, hTMLToken);
    }

    private void renderTableLines(HTMLRenderState hTMLRenderState) {
        int n;
        int n2;
        if (hTMLRenderState.isPaging()) {
            return;
        }
        int n3 = hTMLRenderState.getTableBorder();
        if (n3 == 0) {
            return;
        }
        hTMLRenderState.setClip();
        Graphics graphics = hTMLRenderState.getGraphics();
        int n4 = hTMLRenderState.getTableRows();
        if (n4 == 0) {
            return;
        }
        Color color = graphics.getColor();
        String string = hTMLRenderState.getTableBorderColor();
        if (string != null) {
            graphics.setColor(HTMLRenderer.getColor(string));
        }
        int n5 = hTMLRenderState.getTableColumns();
        int n6 = 0;
        int n7 = 0;
        int n8 = hTMLRenderState.getXOffset() - 4;
        int n9 = n8 + hTMLRenderState.getMaxWidth();
        for (n2 = 0; n2 < n4; ++n2) {
            int n10 = hTMLRenderState.getTableRowY(n2) + 2;
            if (n2 == 0) {
                n6 = n10;
            }
            n7 = n10;
            for (n = 0; n < n3; ++n) {
                graphics.drawLine(n8, n10 + n, n9, n10 + n);
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            int n11 = hTMLRenderState.getTableColumnX(n2) - 4;
            for (n = 0; n < n3; ++n) {
                graphics.drawLine(n11 + n, n6, n11 + n, n7);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            graphics.drawLine(n9 + n2, n6, n9 + n2, n7);
        }
        graphics.setColor(color);
    }

    private void renderScrollBar(HTMLRenderState hTMLRenderState) {
        if (hTMLRenderState.isPaging()) {
            return;
        }
        if (!this.scrollable) {
            return;
        }
        if (hTMLRenderState.getLineCount() <= hTMLRenderState.getMaxLines()) {
            this.scrollingRequired = false;
            return;
        }
        Graphics graphics = hTMLRenderState.getGraphics();
        graphics.setClip(0, 0, hTMLRenderState.getMaxWidth() + hTMLRenderState.getXOffset() + 100, hTMLRenderState.getLineHeight() * (hTMLRenderState.getMaxLines() + 20));
        Color color = Color.black;
        if (this.scrollbar == null) {
            this.scrollbar = new EScrollbarHTML(this);
        }
        int n = hTMLRenderState.getStartLine();
        this.scrollbar.setPosition(n);
        this.scrollbar.setVisible(hTMLRenderState.getMaxLines());
        this.scrollbar.setMax(hTMLRenderState.getLineCount() - hTMLRenderState.getMaxLines());
        this.scrollbar.setAbsoluteMax(hTMLRenderState.getLineCount());
        Rectangle rectangle = new Rectangle(hTMLRenderState.getXOffset(), hTMLRenderState.getYOffset() - hTMLRenderState.getLineHeight(), hTMLRenderState.getMaxWidth() + 30, hTMLRenderState.getLineHeight() * hTMLRenderState.getMaxLines() + 28);
        this.scrollbar.paint(graphics, rectangle);
        this.scrollingRequired = this.scrollbar.isScrollingNecessary();
        graphics.setColor(color);
        hTMLRenderState.setClip();
    }

    private void optimizeVariableReplacement() {
        Enumeration enumeration = this.variableReplacement.keys();
        int n = this.variableReplacement.size();
        this.variableKey = new String[n];
        this.variableKeyLength = new int[n];
        this.variableText = new String[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            this.variableKey[n2] = (String)enumeration.nextElement();
            this.variableKeyLength[n2] = this.variableKey[n2].length();
            this.variableText[n2] = (String)this.variableReplacement.get(this.variableKey[n2]);
            ++n2;
        }
    }

    private String handleTextReplacement(String string) {
        if (this.variableKey.length == 0) {
            return string;
        }
        int n = this.variableKey.length;
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            while (n2 != -1) {
                n2 = string.indexOf(this.variableKey[i]);
                if (n2 == -1) continue;
                string = string.substring(0, n2) + this.variableText[i] + string.substring(n2 + this.variableKeyLength[i]);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderHTML(Graphics graphics) {
        try {
            try {
                if (this.renderState == null) {
                    this.renderState = new HTMLRenderState();
                }
                this.globalLinkIndex = 0;
                this.initLinks();
                this.renderState.reset();
                this.renderState.setGraphics(graphics);
                this.renderState.setClip();
                this.renderState.setTokenizer(new StringTokenizer(this.text, "<"));
                while (this.renderState.getTokenizer().hasMoreTokens()) {
                    String string = this.renderState.getTokenizer().nextToken();
                    this.renderToken(this.renderState, string);
                    if (!this.renderState.isRenderAborted()) continue;
                    Object var4_4 = null;
                    if (this.renderState.isPaging()) {
                        this.renderState.setLineCount(this.renderState.getCurrentLine());
                    } else {
                        if (this.renderState.getCurrentLine() != this.renderState.getPreviousLine()) {
                            this.calculatePageLinkOffset();
                            this.selectedHeadIndex = 0 + this.pageLinkOffset;
                            this.selectLinkHead(0 + this.pageLinkOffset);
                            this.pageLinkOffset = 0;
                        } else {
                            this.selectLinkHead(this.selectedHeadIndex);
                        }
                        this.renderState.setPreviousLine();
                        if (this.historySelectedLinkIndex >= 0) {
                            this.selectLinkHead(this.historySelectedLinkIndex);
                            this.selectedHeadIndex = this.historySelectedLinkIndex;
                            this.historySelectedLinkIndex = -1;
                        }
                    }
                    this.renderScrollBar(this.renderState);
                    this.renderTableLines(this.renderState);
                    return;
                }
                this.selectedHeadIndex = this.prevSelectedLinkIndex;
            }
            catch (Exception exception) {
                logger.error("Exception during HTML display", exception);
                Object var4_6 = null;
                if (this.renderState.isPaging()) {
                    this.renderState.setLineCount(this.renderState.getCurrentLine());
                } else {
                    if (this.renderState.getCurrentLine() != this.renderState.getPreviousLine()) {
                        this.calculatePageLinkOffset();
                        this.selectedHeadIndex = 0 + this.pageLinkOffset;
                        this.selectLinkHead(0 + this.pageLinkOffset);
                        this.pageLinkOffset = 0;
                    } else {
                        this.selectLinkHead(this.selectedHeadIndex);
                    }
                    this.renderState.setPreviousLine();
                    if (this.historySelectedLinkIndex >= 0) {
                        this.selectLinkHead(this.historySelectedLinkIndex);
                        this.selectedHeadIndex = this.historySelectedLinkIndex;
                        this.historySelectedLinkIndex = -1;
                    }
                }
                this.renderScrollBar(this.renderState);
                this.renderTableLines(this.renderState);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (this.renderState.isPaging()) {
                this.renderState.setLineCount(this.renderState.getCurrentLine());
            } else {
                if (this.renderState.getCurrentLine() != this.renderState.getPreviousLine()) {
                    this.calculatePageLinkOffset();
                    this.selectedHeadIndex = 0 + this.pageLinkOffset;
                    this.selectLinkHead(0 + this.pageLinkOffset);
                    this.pageLinkOffset = 0;
                } else {
                    this.selectLinkHead(this.selectedHeadIndex);
                }
                this.renderState.setPreviousLine();
                if (this.historySelectedLinkIndex >= 0) {
                    this.selectLinkHead(this.historySelectedLinkIndex);
                    this.selectedHeadIndex = this.historySelectedLinkIndex;
                    this.historySelectedLinkIndex = -1;
                }
            }
            this.renderScrollBar(this.renderState);
            this.renderTableLines(this.renderState);
            throw throwable;
        }
        Object var4_5 = null;
        if (this.renderState.isPaging()) {
            this.renderState.setLineCount(this.renderState.getCurrentLine());
        } else {
            if (this.renderState.getCurrentLine() != this.renderState.getPreviousLine()) {
                this.calculatePageLinkOffset();
                this.selectedHeadIndex = 0 + this.pageLinkOffset;
                this.selectLinkHead(0 + this.pageLinkOffset);
                this.pageLinkOffset = 0;
            } else {
                this.selectLinkHead(this.selectedHeadIndex);
            }
            this.renderState.setPreviousLine();
            if (this.historySelectedLinkIndex >= 0) {
                this.selectLinkHead(this.historySelectedLinkIndex);
                this.selectedHeadIndex = this.historySelectedLinkIndex;
                this.historySelectedLinkIndex = -1;
            }
        }
        this.renderScrollBar(this.renderState);
        this.renderTableLines(this.renderState);
    }

    public void render() {
        this.repaint();
    }

    public synchronized void render(Graphics graphics) {
        try {
            this.renderState.setGraphics(graphics);
            this.renderState.setClip();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setFont(this.baseFont);
            graphics.setColor(this.baseFontColor);
            if (this.isTextDirty()) {
                this.renderState.setPaging(true);
                if (!this.startLineInit) {
                    this.renderState.setStartLine(0);
                } else {
                    this.startLineInit = false;
                }
                this.relativeLinks.clear();
                this.globalLinkHeads.setSize(0);
                this.renderHTML(graphics);
                this.setTextDirty(false);
                this.renderState.setPaging(false);
            }
            this.renderHTML(graphics);
            this.fireFinishedHTMLRendering();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addExternalPainter(HTMLRendererExternalPainter hTMLRendererExternalPainter) {
        if (this.externalPainters == null) {
            this.externalPainters = new Vector();
        }
        this.externalPainters.addElement(hTMLRendererExternalPainter);
    }

    protected void paintComponent(Graphics graphics) {
        this.render(graphics);
        if (this.externalPainters == null) {
            return;
        }
        for (int i = 0; i < this.externalPainters.size(); ++i) {
            HTMLRendererExternalPainter hTMLRendererExternalPainter = (HTMLRendererExternalPainter)this.externalPainters.elementAt(i);
            hTMLRendererExternalPainter.paintHTMLRenderer(graphics);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class HTMLLink {
        int linkID = -1;
        int displayLinkIndex = -1;
        String linkText = "";
        String linkPage = "";
        Font linkFont = null;
        int startLine = 0;
        int pageLinkIndex = 0;
        int x = 0;
        int y = 0;
        boolean relative = false;

        public HTMLLink(int n, int n2, String string, String string2, int n3, int n4, Font font) {
            this.setLinkID(n);
            this.setDisplayLinkIndex(n2);
            this.setLinkText(string);
            this.setLinkPage(string2);
            this.setX(n3);
            this.setY(n4);
            this.setLinkFont(font);
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setRelative(boolean bl) {
            this.relative = bl;
        }

        public int getLinkID() {
            return this.linkID;
        }

        public int getDisplayLinkIndex() {
            return this.displayLinkIndex;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public String getLinkPage() {
            return this.linkPage;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getPageLinkIndex() {
            return this.pageLinkIndex;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Font getLinkFont() {
            return this.linkFont;
        }

        public void setLinkID(int n) {
            this.linkID = n;
        }

        public void setDisplayLinkIndex(int n) {
            this.displayLinkIndex = n;
        }

        public void setLinkText(String string) {
            this.linkText = string;
        }

        public void setLinkPage(String string) {
            this.linkPage = string;
        }

        public void setStartLine(int n) {
            this.startLine = n;
        }

        public void setPageLinkIndex(int n) {
            this.pageLinkIndex = n;
        }

        public void setX(int n) {
            this.x = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public void setLinkFont(Font font) {
            this.linkFont = font;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("Link::id: " + this.linkID);
                stringBuffer.append(";ndx: " + this.displayLinkIndex);
                stringBuffer.append(";txt: " + this.linkText);
                stringBuffer.append(";lnk: " + this.linkPage);
                stringBuffer.append(";x,y: " + this.x + "," + this.y);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }
    }

    class HTMLRenderState {
        private Graphics graphics = null;
        private StringTokenizer tokenizer = null;
        private int pageCount = 0;
        private int lineCount = 0;
        private int currentLine = 0;
        private int previousLine = 0;
        private int startLine = 0;
        private int maxLines = 10;
        private int maxWidth = 200;
        private int currentWidth = 0;
        private boolean preRange = false;
        private boolean inRange = false;
        private boolean postRange = false;
        private boolean paging = false;
        private boolean renderAborted = false;
        private boolean inBody = false;
        private boolean inAnchor = false;
        private int rowDepth = 0;
        private int xOffset = 10;
        private int yOffset = 50;
        private int linkID = 0;
        private String linkPage = null;
        private int startPosition = 0;
        private int lineHeight = 25;
        private int columnWidth = 0;
        private int columnWidthSum = 0;
        private boolean tableMode = false;
        private String imageFilename = null;
        private boolean imageRendering = false;
        private boolean newLine = false;
        private Vector tableColumnX = new Vector();
        private Vector tableRowY = new Vector();
        private int tableBorder = 0;
        private String tableBorderColor = null;
        private int listType = 22;
        private int orderedListItem = 0;
        private boolean onScreen = false;
        private int startRowLine = 0;
        private int endRowLine = 0;
        private Vector tableColumnWidths = new Vector();
        int tableReconcile = 0;
        private Stack fontStack = new Stack();
        private Stack colorStack = new Stack();

        public Graphics getGraphics() {
            return this.graphics;
        }

        public StringTokenizer getTokenizer() {
            return this.tokenizer;
        }

        public int getCurrentLine() {
            return this.currentLine;
        }

        public int getPreviousLine() {
            return this.previousLine;
        }

        public int getCurrentWidth() {
            return this.currentWidth;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getMaxLines() {
            return this.maxLines;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getPageCount() {
            return this.pageCount;
        }

        public boolean isPreRange() {
            return this.preRange;
        }

        public boolean isInRange() {
            return this.inRange;
        }

        public boolean isOnScreen() {
            return this.onScreen;
        }

        public boolean isPostRange() {
            return this.postRange;
        }

        public boolean isPaging() {
            return this.paging;
        }

        public boolean isInAnchor() {
            return this.inAnchor;
        }

        public void setInAnchor(boolean bl) {
            this.inAnchor = bl;
        }

        public String getLinkPage() {
            return this.linkPage;
        }

        public void setLinkPage(String string) {
            this.linkPage = string;
        }

        public boolean isRenderAborted() {
            return this.renderAborted;
        }

        public int getRowDepth() {
            return this.rowDepth;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public int getLinkID() {
            return this.linkID;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getLineHeight() {
            return this.lineHeight;
        }

        public boolean isInBody() {
            return this.inBody;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        public int getColumnWidthSum() {
            return this.columnWidthSum;
        }

        public boolean isTableMode() {
            return this.tableMode;
        }

        public String getImageFilename() {
            return this.imageFilename;
        }

        public boolean isImageRendering() {
            return this.imageRendering;
        }

        public boolean isNewLine() {
            return this.newLine;
        }

        public void setGraphics(Graphics graphics) {
            this.graphics = graphics;
        }

        public void setTokenizer(StringTokenizer stringTokenizer) {
            this.tokenizer = stringTokenizer;
        }

        public void setCurrentLine(int n) {
            this.currentLine = n;
        }

        public void setPreviousLine(int n) {
            this.previousLine = n;
        }

        public void setPreviousLine() {
            this.setPreviousLine(this.currentLine);
        }

        public void setCurrentWidth(int n) {
            this.currentWidth = n;
        }

        public boolean isTop() {
            return this.startLine == 0;
        }

        public boolean isBottom() {
            return this.startLine >= HTMLRenderer.this.renderState.getLineCount() - HTMLRenderer.this.renderState.getMaxLines();
        }

        public void setStartLineFromHistory(int n) {
            if (n < 0) {
                this.startLine = 0;
                return;
            }
            this.startLine = n;
        }

        public void setStartLine(int n) {
            try {
                if (n <= 0) {
                    this.startLine = 0;
                    return;
                }
                if (n > HTMLRenderer.this.renderState.getLineCount() - HTMLRenderer.this.renderState.getMaxLines()) {
                    this.startLine = HTMLRenderer.this.renderState.getLineCount() - HTMLRenderer.this.renderState.getMaxLines();
                    if (this.startLine < 0) {
                        this.startLine = 0;
                    }
                    return;
                }
                this.startLine = n;
                return;
            }
            catch (Exception exception) {
                this.startLine = 0;
                return;
            }
        }

        public void setMaxLines(int n) {
            this.maxLines = n;
        }

        public void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public void setLineCount(int n) {
            this.lineCount = n;
            this.calculatePageCount();
        }

        public void setPageCount(int n) {
            this.pageCount = n;
        }

        private void setPreRange(boolean bl) {
            this.preRange = bl;
        }

        private void setInRange(boolean bl) {
            this.inRange = bl;
        }

        private void setOnScreen(boolean bl) {
            this.onScreen = bl;
        }

        private void setPostRange(boolean bl) {
            this.postRange = bl;
        }

        public void setPaging(boolean bl) {
            this.paging = bl;
        }

        public void setRenderAborted(boolean bl) {
            this.renderAborted = bl;
        }

        public void setRowDepth(int n) {
            if (n == 0) {
                this.setColumnWidthSum(0);
                this.setColumnWidth(0);
                this.setCurrentWidth(0);
            }
            this.rowDepth = n;
        }

        public void setStartRowLine() {
            this.startRowLine = this.currentLine;
        }

        public int getStartRowLine() {
            return this.startRowLine;
        }

        public void setEndRowLine() {
            this.endRowLine = this.endRowLine > this.currentLine ? this.endRowLine : this.currentLine;
        }

        public void setEndRowLine(int n) {
            this.endRowLine = n;
        }

        public int getEndRowLine() {
            return this.endRowLine;
        }

        public void setXOffset(int n) {
            this.xOffset = n;
        }

        public void setYOffset(int n) {
            this.yOffset = n;
        }

        public void setLinkID(int n) {
            this.linkID = n;
        }

        public void setStartPosition(int n) {
            this.startPosition = n;
        }

        public void setLineHeight(int n) {
            this.lineHeight = n;
        }

        public void setInBody(boolean bl) {
            this.inBody = bl;
        }

        public void setColumnWidth(int n) {
            this.columnWidth = n;
        }

        public void setColumnWidthSum(int n) {
            this.columnWidthSum = n;
        }

        public void setTableMode(boolean bl) {
            if (!bl) {
                HTMLRenderer.this.renderTableLines(this);
                this.tableColumnX.setSize(0);
                this.tableRowY.setSize(0);
                this.tableBorder = 0;
                this.setCurrentWidth(0);
                this.tableColumnWidths.setSize(0);
            } else {
                this.tableReconcile = 0;
            }
            this.tableMode = bl;
        }

        public void setImageFilename(String string) {
            this.imageFilename = string;
        }

        public void setImageRendering(boolean bl) {
            this.imageRendering = bl;
        }

        public void setNewLine(boolean bl) {
            this.newLine = bl;
        }

        public void setClip() {
            try {
                this.graphics.setClip(0, 0, this.getMaxWidth() + this.getXOffset() + 1000, this.getLineHeight() * (this.getMaxLines() + 2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void reset() {
            this.setTokenizer(null);
            this.setCurrentLine(0);
            this.setCurrentWidth(0);
            this.setRenderAborted(false);
            this.setPreRange(false);
            this.setInRange(false);
            this.setOnScreen(false);
            this.setPostRange(false);
            this.setRowDepth(0);
            this.setStartPosition(0);
            this.setInBody(false);
            this.setLinkID(0);
            this.setLinkPage(null);
            this.setTableMode(false);
            this.setInAnchor(false);
            this.fontStack.removeAllElements();
            this.colorStack.removeAllElements();
        }

        private void calculatePageCount() {
            try {
                if (this.lineCount == 0) {
                    this.setPageCount(0);
                    return;
                }
                int n = this.lineCount / this.maxLines;
                if (this.lineCount % this.maxLines > 0) {
                    ++n;
                }
                this.setPageCount(n);
                return;
            }
            catch (Exception exception) {
                this.setPageCount(0);
                return;
            }
        }

        public int addToColumnWidthSum(int n) {
            return this.columnWidthSum += n;
        }

        public int getColumnOffset() {
            try {
                return this.columnWidthSum * this.maxWidth / 100 + this.xOffset;
            }
            catch (Exception exception) {
                return this.xOffset;
            }
        }

        public int getColumnMaxWidth() {
            try {
                if (this.columnWidth <= 0) {
                    return this.maxWidth - this.columnWidthSum * this.maxWidth / 100;
                }
                return this.columnWidth * this.maxWidth / 100;
            }
            catch (Exception exception) {
                return this.maxWidth;
            }
        }

        public int getListType() {
            return this.listType;
        }

        public void setListType(int n) {
            this.listType = n;
        }

        public int getOrderedListItem() {
            return ++this.orderedListItem;
        }

        public void setOrderedListItem(int n) {
            this.orderedListItem = n;
        }

        public String getTableBorderColor() {
            return this.tableBorderColor;
        }

        public void setTableBorderColor(String string) {
            this.tableBorderColor = string;
        }

        public int getTableBorder() {
            return this.tableBorder;
        }

        public void setTableBorder(int n) {
            this.tableBorder = n;
        }

        public int getTableRows() {
            return this.tableRowY.size();
        }

        public int getTableColumns() {
            return this.tableColumnX.size();
        }

        public int getTableRowY(int n) {
            try {
                Integer n2 = (Integer)this.tableRowY.elementAt(n);
                if (n2 != null) {
                    return n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public int getTableColumnX(int n) {
            try {
                Integer n2 = (Integer)this.tableColumnX.elementAt(n);
                if (n2 != null) {
                    return n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void setRowY() {
            this.setRowY(-1);
        }

        public void setRowY(int n) {
            this.tableRowY.addElement(new Integer(this.getY() + n * this.lineHeight));
        }

        public void setColumnX() {
            this.tableColumnX.addElement(new Integer(this.getX()));
        }

        public int getX() {
            try {
                if (this.tableMode) {
                    int n = this.getColumnOffset() + this.startPosition;
                    return n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.xOffset + this.startPosition;
        }

        public int getY() {
            if (this.startLine < 0) {
                return this.yOffset + this.lineHeight * this.currentLine;
            }
            return this.yOffset + this.lineHeight * (this.currentLine - this.startLine);
        }

        public void reconcileTableColumnWidths() {
            try {
                if (this.tableReconcile++ > 0) {
                    return;
                }
                int n = this.tableColumnWidths.size();
                if (n == 0) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    n3 = (Integer)this.tableColumnWidths.elementAt(i);
                    if (n3 <= 0) {
                        n3 = 15;
                    }
                    n2 += n3;
                }
                if (n2 == 100) {
                    return;
                }
                Integer n4 = new Integer(100 - (n2 - n3));
                this.tableColumnWidths.setElementAt(n4, --n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getTableColumnWidth() {
            try {
                int n = this.getRowDepth();
                if (n < 0) {
                    return 15;
                }
                int n2 = this.tableColumnWidths.size() - 1;
                if (n > n2) {
                    return 15;
                }
                int n3 = (Integer)this.tableColumnWidths.elementAt(n);
                if (n3 <= 0) {
                    n3 = 15;
                }
                return n3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 15;
            }
        }

        public void addTableColumnWidth(int n) {
            try {
                int n2 = this.getRowDepth();
                if (n2 < 0) {
                    return;
                }
                if (n2 > this.tableColumnWidths.size() - 1) {
                    while (n2 > this.tableColumnWidths.size()) {
                        this.tableColumnWidths.addElement(new Integer(-1));
                    }
                    this.tableColumnWidths.addElement(new Integer(n));
                } else {
                    this.tableColumnWidths.setElementAt(new Integer(n), n2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int incrementRowDepth() {
            return ++this.rowDepth;
        }

        public int incrementLinkID() {
            return ++this.linkID;
        }

        public int addToCurrentWidth(int n) {
            this.currentWidth += n;
            return this.currentWidth;
        }

        public boolean isNewLineNeeded() {
            try {
                if (this.isTableMode()) {
                    if (this.rowDepth <= 0) {
                        return false;
                    }
                    return this.currentWidth >= this.getColumnMaxWidth() - 6;
                }
                return this.currentWidth >= this.maxWidth;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void linefeed() {
            try {
                ++this.currentLine;
                int n = 0;
                this.setStartPosition(0);
                this.setCurrentWidth(n);
                if (this.paging) {
                    return;
                }
                if (this.maxLines <= 0) {
                    return;
                }
                this.setNewLine(true);
                this.handlePaging();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void handlePaging() {
            try {
                if (this.paging) {
                    this.setInRange(true);
                    this.setOnScreen(false);
                    return;
                }
                if (this.startLine < 0) {
                    this.setInRange(true);
                    return;
                }
                if (this.startLine > this.currentLine + 20) {
                    this.setPreRange(true);
                    return;
                }
                if (this.maxLines < 0) {
                    this.setInRange(true);
                    this.setOnScreen(true);
                    return;
                }
                if (this.currentLine < this.startLine + this.maxLines + 20) {
                    if (this.currentLine >= this.startLine && this.currentLine <= this.startLine + this.maxLines) {
                        this.setOnScreen(true);
                    } else {
                        this.setOnScreen(false);
                    }
                    this.setInRange(true);
                    return;
                }
                this.setOnScreen(false);
                this.setPostRange(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void abortRender() {
            try {
                this.setRenderAborted(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("RenderState:");
                stringBuffer.append("\nstartLine: " + this.startLine);
                stringBuffer.append("\nstartPosition: " + this.startPosition);
                stringBuffer.append("\nmaxWidth: " + this.maxWidth);
                stringBuffer.append("\nmaxLines: " + this.maxLines);
                stringBuffer.append("\ncurrentLine:  " + this.currentLine);
                stringBuffer.append("\nrenderAborted? " + this.renderAborted);
                stringBuffer.append("\ndepth: " + this.rowDepth);
                stringBuffer.append("\npaging: " + this.paging);
                stringBuffer.append("\nlinkID: " + this.linkID);
                stringBuffer.append("\ninAchor: " + this.inAnchor);
                stringBuffer.append("\nlinkPage: " + this.linkPage);
                stringBuffer.append("\nlineCount: " + this.lineCount);
                stringBuffer.append("\npageCount: " + this.pageCount);
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return stringBuffer.toString();
            }
        }

        public void pushFont(Font font) {
            if (this.graphics != null) {
                this.fontStack.push(this.graphics.getFont());
                this.graphics.setFont(font);
            }
        }

        public void popFont() {
            if (this.graphics != null && !this.fontStack.empty()) {
                try {
                    Font font = (Font)this.fontStack.pop();
                    this.graphics.setFont(font);
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
        }

        public void pushColor(Color color) {
            if (this.graphics != null) {
                this.colorStack.push(this.graphics.getColor());
                this.graphics.setColor(color);
            }
        }

        public void popColor() {
            if (this.graphics != null && !this.colorStack.empty()) {
                try {
                    Color color = (Color)this.colorStack.pop();
                    this.graphics.setColor(color);
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
        }
    }

    public static interface HTMLRendererExternalPainter {
        public void paintHTMLRenderer(Graphics var1);
    }
}

