/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.html;

import elgato.infrastructure.html.HTMLManager;
import elgato.infrastructure.html.HTMLRenderer;
import elgato.infrastructure.html.HTMLRendererListener;
import elgato.infrastructure.mainScreens.ModeScreen;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;

public class HTMLScreen
extends Screen
implements ScrollWheelListener,
HTMLRendererListener {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$html$HTMLScreen == null ? (class$elgato$infrastructure$html$HTMLScreen = HTMLScreen.class$("elgato.infrastructure.html.HTMLScreen")) : class$elgato$infrastructure$html$HTMLScreen).getName());
    public static final HydroBorderPainterConfig BORDER_CONFIG = res.getBorderConfig("border");
    protected HTMLRenderer htmlRenderer = new HTMLRenderer();
    protected HTMLManager htmlManager = new HTMLManager();
    protected ScreenManager sm;
    private String rightMenuTitle = "";
    private boolean displayBrowser = true;
    protected boolean sessionCacheable = false;
    private StartPageButton startPageButton = null;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLScreen;

    public HTMLScreen(ScreenManager screenManager) {
        this(screenManager, true, "");
    }

    public HTMLScreen(ScreenManager screenManager, boolean bl, String string) {
        this.sm = screenManager;
        this.displayBrowser = bl;
        this.rightMenuTitle = string;
    }

    public HTMLManager getHTMLManager() {
        return this.htmlManager;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.sm = screenManager;
        this.htmlManager.setHTMLRenderer(this.htmlRenderer);
        this.htmlRenderer.setHTMLManager(this.htmlManager);
        this.htmlRenderer.addListener(this);
        this.htmlManager.setHeaderIncluded(true);
        this.htmlManager.setFooterIncluded(true);
        screenManager.installRightMenu(this.buildRightMenu());
        Menu menu = new Menu("", new MenuItem[0]);
        if (this.displayBrowser) {
            menu = this.buildLeftMenu();
        }
        screenManager.getLeftMenuPanel().installMenu(menu);
        screenManager.installDisplay(new BorderWrapper(this.htmlRenderer, BORDER_CONFIG, true));
        ScrollWheelManager.instance().addScrollWheelListener(this);
    }

    protected Menu buildLeftMenu() {
        return new Menu(Text.Help, new MenuItem[]{null, null, null, null, null, null, this.makeDoneButton()});
    }

    public Menu buildRightMenu() {
        if (this.displayBrowser) {
            return new Menu(this.rightMenuTitle, new MenuItem[]{this.makePageUpButton(), this.makePageDownButton(), this.makeLinkUpButton(), this.makeLinkDownButton(), this.makeFollowLinkButton(""), this.makeForwardButton(), this.makeBackButton()});
        }
        return new Menu(this.rightMenuTitle, new MenuItem[]{this.makePageUpButton(), this.makePageDownButton(), null, null, null, null, this.makeDoneButton()});
    }

    private MenuItem makeBackButton() {
        return new LinkBackButton("\n    " + Text.Back, "");
    }

    private MenuItem makeForwardButton() {
        return new LinkForwardButton("\n" + Text.Forward, "");
    }

    private MenuItem makePageUpButton() {
        return new PageUpButton(Text.Page_Up, "");
    }

    private MenuItem makePageDownButton() {
        return new PageDownButton(Text.Page_Down, "");
    }

    private MenuItem makeLinkUpButton() {
        return new LinkUpButton("", null);
    }

    private MenuItem makeLinkDownButton() {
        return new LinkDownButton("", null);
    }

    private MenuItem makeFollowLinkButton(String string) {
        return new NavigateLinkButton(Text.Goto, "", string);
    }

    private StartPageButton makeStartPageButton() {
        return new StartPageButton(this.htmlManager.getStartPageTitle(), "", this.htmlManager.getStartPageCode());
    }

    private MenuItem makeDoneButton() {
        String string = Text.Exit_Help;
        if (!this.sessionCacheable) {
            string = Text.Back;
        }
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLScreen.this.exitHTMLScreen();
            }
        });
    }

    void exitHTMLScreen() {
        if (this.sessionCacheable) {
            this.htmlManager.setCurrentStartLine();
            HTMLManager.cacheSession(this.htmlManager);
            this.sm.popScreen();
            if (this.sm.getCurrentScreen() instanceof ModeScreen) {
                HTMLManager.resetCacheSession();
            }
        } else {
            this.sm.popScreen();
        }
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        this.htmlRenderer.scrollBy(scrollWheelEvent.getUnitsMoved() * 5);
    }

    public void scrollWheelMoveComplete() {
    }

    public void finishedHTMLRendering() {
        if (this.displayBrowser) {
            this.handleLinkButtons();
            this.handleHistoryButtons();
            this.handleStartButton();
        }
        this.handleScrollingButtons();
        this.sm.getLeftMenuPanel().repaint();
        this.sm.getRightMenuPanel().repaint();
    }

    private void handleStartButton() {
        if (!this.displayBrowser) {
            return;
        }
        try {
            MenuPanel menuPanel = this.sm.getLeftMenuPanel();
            if (this.startPageButton == null) {
                this.startPageButton = this.makeStartPageButton();
            } else if (this.startPageButton.getText().equals("")) {
                this.startPageButton.setText(this.htmlManager.getStartPageTitle());
                this.startPageButton.setPageCode(this.htmlManager.getStartPageCode());
            }
            menuPanel.setMenuItem(this.startPageButton, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleLinkButtons() {
        boolean bl = this.htmlRenderer.getLinkCount() > 0;
        MenuPanel menuPanel = this.sm.getRightMenuPanel();
        menuPanel.getMenuItems()[2].setEnabled(bl && this.htmlRenderer.isLinkUp());
        menuPanel.getMenuItems()[3].setEnabled(bl && this.htmlRenderer.isLinkDown());
        this.refreshLinkButton();
        menuPanel.getMenuItems()[4].setEnabled(bl);
    }

    private void refreshLinkButton() {
        String string = this.htmlRenderer.getSelectedLinkText();
        if (string == null) {
            string = "";
        }
        MenuPanel menuPanel = this.sm.getRightMenuPanel();
        menuPanel.setMenuItem(this.makeFollowLinkButton(string), 4);
    }

    private void handleScrollingButtons() {
        boolean bl = this.htmlRenderer.isScrollingRequired();
        MenuPanel menuPanel = this.sm.getRightMenuPanel();
        menuPanel.getMenuItems()[0].setEnabled(bl && !this.htmlRenderer.isTop());
        menuPanel.getMenuItems()[1].setEnabled(bl && !this.htmlRenderer.isBottom());
    }

    private void handleHistoryButtons() {
        MenuItem menuItem;
        MenuPanel menuPanel = this.sm.getRightMenuPanel();
        MenuItem[] menuItemArray = menuPanel.getMenuItems();
        if (menuItemArray == null) {
            return;
        }
        MenuItem menuItem2 = menuItemArray[5];
        if (menuItem2 != null) {
            menuItem2.setEnabled(this.htmlManager.isHistoryForward());
        }
        if ((menuItem = menuItemArray[6]) != null) {
            menuItem.setEnabled(this.htmlManager.isHistoryBack());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 38: {
                keyEvent.consume();
                this.htmlRenderer.scrollPageUp();
                break;
            }
            case 40: {
                keyEvent.consume();
                this.htmlRenderer.scrollPageDown();
                break;
            }
            case 27: {
                keyEvent.consume();
                this.exitHTMLScreen();
            }
        }
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.htmlRenderer.removeListener(this);
        ScrollWheelManager.instance().removeScrollWheelListener(this);
        super.uninstallScreen(screenManager);
    }

    public String ft_content() {
        return this.htmlRenderer.getText();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StartPageButton
    extends PushButton
    implements ActionListener {
        String linkName;
        String text;

        public StartPageButton(String string, String string2, String string3) {
            super("", string2);
            this.text = string;
            this.linkName = string3;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlManager.navigateToStartPage();
        }

        public void setLinkName(String string) {
            this.linkName = string;
        }

        public void setPageCode(String string) {
            this.setLinkName(string);
        }

        public void setText(String string) {
            super.setText(this.wrapButtonText(string));
        }

        protected String wrapButtonText(String string) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 11;
                int n2 = 0;
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if ((n2 += string2.length()) > n) {
                        stringBuffer.append("\n");
                        n2 = string2.length();
                        if (++n3 > 2) {
                            break;
                        }
                    } else {
                        ++n2;
                    }
                    stringBuffer.append(string2 + " ");
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                return string;
            }
        }
    }

    class NavigateLinkButton
    extends PushButton
    implements ActionListener {
        String text;

        public NavigateLinkButton(String string, String string2, String string3) {
            super("", string2);
            this.text = string;
            this.setBodyText(string3);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlManager.navigateLink();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            this.drawSelect(graphics, n, n2, n3, n4);
        }

        protected void drawSelect(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = 10;
            int n6 = 10;
            int[] nArray = new int[]{n, n + n5, n + n5};
            int[] nArray2 = new int[]{n2 + n6, n2 - n5 / 2 + n6, n2 + n5 / 2 + n6};
            int n7 = 3;
            graphics.fillPolygon(nArray, nArray2, n7);
            graphics.drawLine(n + n5, n2 + n6, n + (int)(1.5 * (double)n5), n2 + n6);
            graphics.drawLine(n + (int)(1.5 * (double)n5), n2 + n6, n + (int)(1.5 * (double)n5), n2 + n6 - n5);
            graphics.drawString(this.text, n + (int)(1.5 * (double)n5) + 8, n2 + n6 + 3);
        }
    }

    private class LinkBackButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;

        public LinkBackButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlManager.navigateBack();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            HTMLScreen.this.htmlManager.renderHistory(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 24;
                int n6 = n5 / 4;
                int n7 = 8;
                int n8 = n7 / 2;
                int n9 = 0;
                int n10 = (n4 - n5) / 2;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11, n11 + n7, n11 + n7, n11 + n7 + n8, n11 + n7 + n8, n11 + n7, n11 + n7};
                this.yPts = new int[]{n12 + 2 * n6, n12, n12 + n6, n12 + n6, n12 + 3 * n6, n12 + 3 * n6, n12 + 4 * n6};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    private class LinkForwardButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;

        public LinkForwardButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlManager.navigateForward();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            HTMLScreen.this.htmlManager.renderHistory(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 24;
                int n6 = n5 / 4;
                int n7 = 8;
                int n8 = n7 / 2;
                int n9 = n3 - n7 - n8;
                int n10 = (n4 - n5) / 2;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11 + n7 + n8, n11 + n8, n11 + n8, n11, n11, n11 + n8, n11 + n8};
                this.yPts = new int[]{n12 + 2 * n6, n12 + 4 * n6, n12 + 3 * n6, n12 + 3 * n6, n12 + n6, n12 + n6, n12};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    class LinkDownButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;

        public LinkDownButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlRenderer.scrollLinkDown();
            HTMLScreen.this.handleLinkButtons();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 32;
                int n6 = n5 / 4;
                int n7 = 10;
                int n8 = n7 / 2;
                int n9 = (n3 - n5) / 2;
                int n10 = n4 / 2;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11 + 2 * n6, n11 + 4 * n6, n11 + 3 * n6, n11 + 3 * n6, n11 + n6, n11 + n6, n11};
                this.yPts = new int[]{n12 + (n7 + n8), n12 + n8, n12 + n8, n12, n12, n12 + n8, n12 + n8};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    class LinkUpButton
    extends PushButton
    implements ActionListener {
        int[] xPts = null;
        int[] yPts = null;

        public LinkUpButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlRenderer.scrollLinkUp();
            HTMLScreen.this.handleLinkButtons();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            if (this.xPts == null) {
                int n5 = 32;
                int n6 = n5 / 4;
                int n7 = 10;
                int n8 = n7 / 2;
                int n9 = (n3 - n5) / 2;
                int n10 = n4 / 2 - n7;
                int n11 = n9 + n;
                int n12 = n10 + n2;
                this.xPts = new int[]{n11 + 2 * n6, n11, n11 + n6, n11 + n6, n11 + 3 * n6, n11 + 3 * n6, n11 + 4 * n6};
                this.yPts = new int[]{n12, n12 + n7, n12 + n7, n12 + (n7 + n8), n12 + (n7 + n8), n12 + n7, n12 + n7};
            }
            graphics.fillPolygon(this.xPts, this.yPts, this.xPts.length);
        }
    }

    private class PageDownButton
    extends PushButton
    implements ActionListener {
        public PageDownButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlRenderer.scrollPageDown();
        }
    }

    private class PageUpButton
    extends PushButton
    implements ActionListener {
        public PageUpButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HTMLScreen.this.htmlRenderer.scrollPageUp();
        }
    }
}

