/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.html;

import elgato.infrastructure.html.HTMLTag;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HTMLToken {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$html$HTMLToken == null ? (class$elgato$infrastructure$html$HTMLToken = HTMLToken.class$("elgato.infrastructure.html.HTMLToken")) : class$elgato$infrastructure$html$HTMLToken);
    private String text = "";
    private int tagType = 0;
    private int closeTagType = 0;
    private Hashtable attributes = null;
    private boolean newLineBefore = false;
    private boolean newLineAfter = false;
    private boolean drawLine = false;
    private boolean startTag = false;
    static /* synthetic */ Class class$elgato$infrastructure$html$HTMLToken;

    public HTMLToken(String string, int n) {
        this.setText(string);
        this.setTagType(n);
    }

    public HTMLToken(String string, int n, int n2) {
        this.setText(string);
        this.setTagType(n);
        this.setCloseTagType(n2);
    }

    public void setText(String string) {
        this.text = string;
    }

    private void setTagType(int n) {
        this.tagType = n;
    }

    private void setNewLineBefore(boolean bl) {
        this.newLineBefore = bl;
    }

    private void setNewLineAfter(boolean bl) {
        this.newLineAfter = bl;
    }

    private void setDrawLine(boolean bl) {
        this.drawLine = bl;
    }

    private void setCloseTagType(int n) {
        this.closeTagType = n;
    }

    private void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    private void setStartTag(boolean bl) {
        this.startTag = bl;
    }

    public String getText() {
        return this.text;
    }

    public int getTagType() {
        return this.tagType;
    }

    public boolean isNewLineBefore() {
        return this.newLineBefore;
    }

    public boolean isNewLineAfter() {
        return this.newLineAfter;
    }

    public boolean isDrawLine() {
        return this.drawLine;
    }

    public int getCloseTagType() {
        return this.closeTagType;
    }

    public boolean isStartTag() {
        return this.startTag;
    }

    public String getAttribute(String string) {
        try {
            if (this.attributes == null) {
                return null;
            }
            return (String)this.attributes.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLinkPage() {
        try {
            String string = this.getAttribute("HREF");
            if (string == null) {
                return this.getText();
            }
            return string;
        }
        catch (Exception exception) {
            return this.getText();
        }
    }

    private static Hashtable determineAttributes(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>(7);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n < 0) continue;
                try {
                    String string3 = string2.substring(0, n).toUpperCase();
                    String string4 = string2.substring(++n).replace('\"', ' ').trim();
                    hashtable.put(string3, string4);
                }
                catch (Exception exception) {}
            }
            if (hashtable.size() == 0) {
                return null;
            }
            return hashtable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int determineTagType(String string) {
        try {
            for (int i = 0; i < 25; ++i) {
                if (!string.toUpperCase().equals(HTMLTag.TAGS[i])) continue;
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private void handleLines() {
        try {
            switch (this.getTagType()) {
                case 1: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 2: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 3: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 4: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 5: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 6: {
                    this.setNewLineAfter(true);
                    break;
                }
                case 10: {
                    this.setNewLineBefore(true);
                    break;
                }
                case 18: {
                    this.setNewLineBefore(true);
                    break;
                }
                case 11: {
                    this.setNewLineBefore(true);
                    this.setDrawLine(true);
                    break;
                }
                case 21: {
                    this.setNewLineBefore(true);
                    break;
                }
                case 13: {
                    this.setNewLineBefore(true);
                    this.setNewLineAfter(true);
                    break;
                }
            }
            switch (this.getCloseTagType()) {
                case 22: {
                    this.setNewLineBefore(true);
                    break;
                }
                case 14: {
                    this.setNewLineBefore(true);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HTMLToken handleToken(String string) {
        try {
            int n;
            int n2 = string.indexOf(">");
            if (n2 == -1) {
                return new HTMLToken(string, 0);
            }
            int n3 = string.indexOf(" ");
            int n4 = string.indexOf("/");
            int n5 = 0;
            boolean bl = false;
            if (n4 == 0) {
                n = n2;
                if (n3 != -1 && n3 < n2) {
                    n = n3;
                }
                if (n < 0) {
                    n = 0;
                }
                n5 = HTMLToken.determineTagType(string.substring(1, n));
            } else {
                bl = true;
            }
            n = n2;
            Hashtable hashtable = null;
            if (n3 >= 0 && n2 > n3) {
                n = n3;
                hashtable = HTMLToken.determineAttributes(string.substring(n3, n2));
            }
            String string2 = string.substring(0, n);
            int n6 = HTMLToken.determineTagType(string2);
            String string3 = string.substring(++n2);
            HTMLToken hTMLToken = new HTMLToken(string3, n6, n5);
            if (hashtable != null) {
                hTMLToken.setAttributes(hashtable);
            }
            hTMLToken.setStartTag(bl);
            hTMLToken.handleLines();
            return hTMLToken;
        }
        catch (Exception exception) {
            logger.debug("Exception handling token '" + string + "'." + exception);
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("text: " + this.text);
        stringBuffer.append("; type: " + this.tagType + "<" + HTMLTag.TAGS[this.tagType] + ">");
        stringBuffer.append("; ctype: " + this.closeTagType + "</" + HTMLTag.TAGS[this.closeTagType] + ">");
        if (this.attributes != null) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n" + string + "=" + this.attributes.get(string));
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

