/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.mainScreens;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.widgets.ProgressIndicator;
import elgato.infrastructure.widgets.WrappedTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

public class DefaultProgressIndicator
extends JComponent
implements ProgressIndicator {
    static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$mainScreens$DefaultProgressIndicator == null ? (class$elgato$infrastructure$mainScreens$DefaultProgressIndicator = DefaultProgressIndicator.class$("elgato.infrastructure.mainScreens.DefaultProgressIndicator")) : class$elgato$infrastructure$mainScreens$DefaultProgressIndicator);
    private static final Color OUTLINE_COLOR = new Color(32, 32, 255);
    private static final Color FILL_COLOR = new Color(140, 140, 255);
    private static final Color SLIDER_COLOR = new Color(0, 0, 255);
    private static final int SLIDER_WIDTH = 40;
    private static final int BAR_WIDTH = 140;
    private static final int BAR_HEIGHT = 22;
    private static final int GAP = 8;
    private static final int ONE_CYCLE = 1000;
    private static final int DELAY = 100;
    private static final Font FONT = ProgressIndicator.res.getFont("message.font");
    private static final Color COLOR = ProgressIndicator.res.getColor("message.color");
    private long beginTime;
    private String[] messages;
    private WrappedTimer timer;
    Rectangle lastBarBounds;
    private ComponentAdapter componentListener;
    static /* synthetic */ Class class$elgato$infrastructure$mainScreens$DefaultProgressIndicator;

    public DefaultProgressIndicator(String[] stringArray) {
        this.messages = stringArray;
        this.setBackground(Color.black);
        this.timer = new WrappedTimer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DefaultProgressIndicator.this.lastBarBounds == null) {
                    DefaultProgressIndicator.this.lastBarBounds = new Rectangle(DefaultProgressIndicator.this.getSize());
                }
                DefaultProgressIndicator.this.paintImmediately(DefaultProgressIndicator.this.lastBarBounds);
            }
        });
        this.componentListener = new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("componentShown()");
                }
                DefaultProgressIndicator.this.start();
            }

            public void componentHidden(ComponentEvent componentEvent) {
                if (logger.isDebugEnabled()) {
                    logger.debug("componentHidden()");
                }
                DefaultProgressIndicator.this.stop();
            }
        };
        this.addComponentListener(this.componentListener);
    }

    public DefaultProgressIndicator(String string) {
        this(new String[]{string});
    }

    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("start()");
        }
        this.timer.start();
    }

    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("stop()");
        }
        this.timer.stop();
    }

    public void removeAllListeners() {
        this.timer.removeActionListener();
        this.removeComponentListener(this.componentListener);
        this.componentListener = null;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.getParent() == null) {
            this.stop();
        }
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = this.drawMessages(graphics, dimension);
        this.drawBar(graphics, dimension, n);
    }

    private int drawMessages(Graphics graphics, Dimension dimension) {
        graphics.setFont(FONT);
        graphics.setColor(COLOR);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() + 8;
        int n2 = this.messages.length;
        int n3 = (dimension.height - (n2 * n + 22)) / 2;
        int n4 = n3 + fontMetrics.getAscent();
        for (int i = 0; i < n2; ++i) {
            graphics.drawString(this.messages[i], (dimension.width - fontMetrics.stringWidth(this.messages[i])) / 2, n4);
            n4 += n;
        }
        return n4 += n;
    }

    private void drawBar(Graphics graphics, Dimension dimension, int n) {
        int n2 = (dimension.width - 140) / 2;
        this.drawProgressBar(graphics, n2, n, 140, 22);
    }

    private int getSliderPosition(int n, int n2) {
        int n3 = n2 - 40;
        long l = this.getDuration();
        int n4 = 1;
        if (l > 0L) {
            long l2 = this.positionInCycle(l);
            n4 = this.nearEnd(l2) ? n3 : (this.nearBegin(l2) ? 1 : this.absolutePosition(n3, l2));
            if (logger.isDebugEnabled()) {
                logger.debug("position " + n4 + " range " + n3);
            }
        }
        if (this.isForward(l)) {
            return this.positionFromBegin(n, n4);
        }
        return this.positionFromEnd(n, n2, n4);
    }

    private long positionInCycle(long l) {
        return l % 1000L;
    }

    private int absolutePosition(int n, long l) {
        return (int)((long)n * l / 1000L);
    }

    private int positionFromEnd(int n, int n2, int n3) {
        return n + n2 - n3 - 40 - 1;
    }

    private int positionFromBegin(int n, int n2) {
        return n + n2 + 1;
    }

    private boolean isForward(long l) {
        return l % 2000L >= 1000L;
    }

    private boolean nearBegin(long l) {
        return l < 100L;
    }

    private boolean nearEnd(long l) {
        return 1000L - l < 100L;
    }

    private int getDuration() {
        long l = System.currentTimeMillis();
        if (this.beginTime == 0L) {
            this.beginTime = l;
            return 0;
        }
        return (int)(l - this.beginTime);
    }

    private void drawProgressBar(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawOutline(graphics, n, n2, n3, n4);
        this.drawBarBackground(graphics, n, n2, n3, n4);
        this.drawSlider(graphics, n, n2, n4, n3);
        this.lastBarBounds = new Rectangle(n, n2, n3, n4);
        this.lastBarBounds.x = n;
        this.lastBarBounds.y = n2;
        this.lastBarBounds.width = n3;
        this.lastBarBounds.height = n4;
    }

    private void drawSlider(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SLIDER_COLOR);
        graphics.fillRect(this.getSliderPosition(n, n4), n2 + 1, 40, n3 - 2);
    }

    private void drawBarBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(FILL_COLOR);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    private void drawOutline(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(OUTLINE_COLOR);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

